/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum ServerCapability {
    DA("DA", "Provides current data."),
    HD("HD", "Provides historical data."),
    AC("AC", "Provides alarms and conditions that may require operator interaction."),
    HE("HE", "Provides historical alarms and events."),
    GDS("GDS", "Supports the Global Discovery Server information model."),
    LDS("LDS", "Only supports the Discovery Services. Cannot be used in combination with any other capability."),
    DI("DI", "Supports the Device Integration (DI) information model."),
    ADI("ADI", "Supports the Analyser Device Integration (ADI) information model."),
    FDI("FDI", "Supports the Field Device Integration (FDI) information model."),
    FDIC("FDIC", "Supports the Field Device Integration (FDI) Communication Server information model."),
    PLC("PLC", "Supports the PLCopen information model."),
    S95("S95", "Supports the ISA95 information model.");

    public static final String NOT_AVAILABLE = "NA";
    private static final Map<String, ServerCapability> map;
    private final String identifier;
    private final String description;

    public static String[] getIdentifiers(EnumSet<ServerCapability> enumSet) {
        return ServerCapability.getIdentifiers(enumSet.toArray(new ServerCapability[enumSet.size()]));
    }

    public static String[] getIdentifiers(ServerCapability ... serverCapabilityArray) {
        if (serverCapabilityArray.length == 0) {
            return new String[]{NOT_AVAILABLE};
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ServerCapability serverCapability : serverCapabilityArray) {
            arrayList.add(serverCapability.identifier);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static EnumSet<ServerCapability> getSet(String ... stringArray) {
        ArrayList<ServerCapability> arrayList = new ArrayList<ServerCapability>();
        for (String string : stringArray) {
            ServerCapability serverCapability = ServerCapability.valueOfId(string);
            if (serverCapability == null) continue;
            arrayList.add(serverCapability);
        }
        if (arrayList.isEmpty()) {
            return EnumSet.noneOf(ServerCapability.class);
        }
        return EnumSet.copyOf(arrayList);
    }

    public static String toString(EnumSet<ServerCapability> enumSet) {
        return enumSet.toString();
    }

    public static ServerCapability valueOfId(String string) {
        if (NOT_AVAILABLE.equals(string)) {
            return null;
        }
        ServerCapability serverCapability = map.get(string);
        if (serverCapability == null) {
            throw new IllegalArgumentException("The identifier is invalid: " + string);
        }
        return serverCapability;
    }

    private ServerCapability(String string2, String string3) {
        this.identifier = string2;
        this.description = string3;
    }

    public String getDescription() {
        return this.description;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    static {
        map = new HashMap<String, ServerCapability>();
        for (ServerCapability serverCapability : ServerCapability.values()) {
            map.put(serverCapability.identifier, serverCapability);
        }
    }
}

