/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=392")
public class ResponseHeader
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.ResponseHeader_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.ResponseHeader_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.ResponseHeader_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.ResponseHeader;
    public static final StructureSpecification SPECIFICATION;
    private DateTime timestamp;
    private UnsignedInteger requestHandle;
    private StatusCode serviceResult;
    private DiagnosticInfo serviceDiagnostics;
    private String[] stringTable;
    private ExtensionObject additionalHeader;

    public ResponseHeader() {
    }

    public ResponseHeader(DateTime dateTime, UnsignedInteger unsignedInteger, StatusCode statusCode, DiagnosticInfo diagnosticInfo, String[] stringArray, ExtensionObject extensionObject) {
        this.timestamp = dateTime;
        this.requestHandle = unsignedInteger;
        this.serviceResult = statusCode;
        this.serviceDiagnostics = diagnosticInfo;
        this.stringTable = stringArray;
        this.additionalHeader = extensionObject;
    }

    public DateTime getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(DateTime dateTime) {
        this.timestamp = dateTime;
    }

    public UnsignedInteger getRequestHandle() {
        return this.requestHandle;
    }

    public void setRequestHandle(UnsignedInteger unsignedInteger) {
        this.requestHandle = unsignedInteger;
    }

    public StatusCode getServiceResult() {
        return this.serviceResult;
    }

    public void setServiceResult(StatusCode statusCode) {
        this.serviceResult = statusCode;
    }

    public DiagnosticInfo getServiceDiagnostics() {
        return this.serviceDiagnostics;
    }

    public void setServiceDiagnostics(DiagnosticInfo diagnosticInfo) {
        this.serviceDiagnostics = diagnosticInfo;
    }

    public String[] getStringTable() {
        return this.stringTable;
    }

    public void setStringTable(String[] stringArray) {
        this.stringTable = stringArray;
    }

    public ExtensionObject getAdditionalHeader() {
        return this.additionalHeader;
    }

    public void setAdditionalHeader(ExtensionObject extensionObject) {
        this.additionalHeader = extensionObject;
    }

    @Override
    public ResponseHeader clone() {
        ResponseHeader responseHeader = (ResponseHeader)super.clone();
        responseHeader.timestamp = StructureUtils.clone(this.timestamp);
        responseHeader.requestHandle = StructureUtils.clone(this.requestHandle);
        responseHeader.serviceResult = StructureUtils.clone(this.serviceResult);
        responseHeader.serviceDiagnostics = StructureUtils.clone(this.serviceDiagnostics);
        responseHeader.stringTable = StructureUtils.clone(this.stringTable);
        responseHeader.additionalHeader = StructureUtils.clone(this.additionalHeader);
        return responseHeader;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ResponseHeader responseHeader = (ResponseHeader)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getTimestamp(), responseHeader.getTimestamp())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getRequestHandle(), responseHeader.getRequestHandle())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getServiceResult(), responseHeader.getServiceResult())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getServiceDiagnostics(), responseHeader.getServiceDiagnostics())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getStringTable(), responseHeader.getStringTable())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getAdditionalHeader(), responseHeader.getAdditionalHeader());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getTimestamp(), this.getRequestHandle(), this.getServiceResult(), this.getServiceDiagnostics(), this.getStringTable(), this.getAdditionalHeader());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.Timestamp.getSpecification().equals(fieldSpecification)) {
            return this.getTimestamp();
        }
        if (Fields.RequestHandle.getSpecification().equals(fieldSpecification)) {
            return this.getRequestHandle();
        }
        if (Fields.ServiceResult.getSpecification().equals(fieldSpecification)) {
            return this.getServiceResult();
        }
        if (Fields.ServiceDiagnostics.getSpecification().equals(fieldSpecification)) {
            return this.getServiceDiagnostics();
        }
        if (Fields.StringTable.getSpecification().equals(fieldSpecification)) {
            return this.getStringTable();
        }
        if (Fields.AdditionalHeader.getSpecification().equals(fieldSpecification)) {
            return this.getAdditionalHeader();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.Timestamp.getSpecification().equals(fieldSpecification)) {
            this.setTimestamp((DateTime)object);
            return;
        }
        if (Fields.RequestHandle.getSpecification().equals(fieldSpecification)) {
            this.setRequestHandle((UnsignedInteger)object);
            return;
        }
        if (Fields.ServiceResult.getSpecification().equals(fieldSpecification)) {
            this.setServiceResult((StatusCode)object);
            return;
        }
        if (Fields.ServiceDiagnostics.getSpecification().equals(fieldSpecification)) {
            this.setServiceDiagnostics((DiagnosticInfo)object);
            return;
        }
        if (Fields.StringTable.getSpecification().equals(fieldSpecification)) {
            this.setStringTable((String[])object);
            return;
        }
        if (Fields.AdditionalHeader.getSpecification().equals(fieldSpecification)) {
            this.setAdditionalHeader((ExtensionObject)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = ResponseHeader.builder();
        builder.setTimestamp(this.getTimestamp());
        builder.setRequestHandle(this.getRequestHandle());
        builder.setServiceResult(this.getServiceResult());
        builder.setServiceDiagnostics(this.getServiceDiagnostics());
        builder.setStringTable(this.getStringTable());
        builder.setAdditionalHeader(this.getAdditionalHeader());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.Timestamp.getSpecification());
        builder.addField(Fields.RequestHandle.getSpecification());
        builder.addField(Fields.ServiceResult.getSpecification());
        builder.addField(Fields.ServiceDiagnostics.getSpecification());
        builder.addField(Fields.StringTable.getSpecification());
        builder.addField(Fields.AdditionalHeader.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("ResponseHeader");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.ResponseHeaderSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return ResponseHeader.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private DateTime timestamp;
        private UnsignedInteger requestHandle;
        private StatusCode serviceResult;
        private DiagnosticInfo serviceDiagnostics;
        private String[] stringTable;
        private ExtensionObject additionalHeader;

        protected Builder() {
        }

        public Builder setTimestamp(DateTime dateTime) {
            this.timestamp = dateTime;
            return this;
        }

        public Builder setRequestHandle(UnsignedInteger unsignedInteger) {
            this.requestHandle = unsignedInteger;
            return this;
        }

        public Builder setServiceResult(StatusCode statusCode) {
            this.serviceResult = statusCode;
            return this;
        }

        public Builder setServiceDiagnostics(DiagnosticInfo diagnosticInfo) {
            this.serviceDiagnostics = diagnosticInfo;
            return this;
        }

        public Builder setStringTable(String[] stringArray) {
            this.stringTable = stringArray;
            return this;
        }

        public Builder setAdditionalHeader(ExtensionObject extensionObject) {
            this.additionalHeader = extensionObject;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.Timestamp.getSpecification().equals(fieldSpecification)) {
                this.setTimestamp((DateTime)object);
                return this;
            }
            if (Fields.RequestHandle.getSpecification().equals(fieldSpecification)) {
                this.setRequestHandle((UnsignedInteger)object);
                return this;
            }
            if (Fields.ServiceResult.getSpecification().equals(fieldSpecification)) {
                this.setServiceResult((StatusCode)object);
                return this;
            }
            if (Fields.ServiceDiagnostics.getSpecification().equals(fieldSpecification)) {
                this.setServiceDiagnostics((DiagnosticInfo)object);
                return this;
            }
            if (Fields.StringTable.getSpecification().equals(fieldSpecification)) {
                this.setStringTable((String[])object);
                return this;
            }
            if (Fields.AdditionalHeader.getSpecification().equals(fieldSpecification)) {
                this.setAdditionalHeader((ExtensionObject)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public ResponseHeader build() {
            return new ResponseHeader(this.timestamp, this.requestHandle, this.serviceResult, this.serviceDiagnostics, this.stringTable, this.additionalHeader);
        }
    }

    public static enum Fields {
        Timestamp("Timestamp", DateTime.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=294")), -1),
        RequestHandle("RequestHandle", UnsignedInteger.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=288")), -1),
        ServiceResult("ServiceResult", StatusCode.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=19")), -1),
        ServiceDiagnostics("ServiceDiagnostics", DiagnosticInfo.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=25")), -1),
        StringTable("StringTable", String[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), 1),
        AdditionalHeader("AdditionalHeader", Structure.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=22")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

