/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.RegisterServerResponse;
import com.prosysopc.ua.stack.core.RegisteredServer;
import com.prosysopc.ua.stack.core.RequestHeader;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=435")
public class RegisterServerRequest
extends AbstractStructure
implements ServiceRequest<RegisterServerResponse> {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.RegisterServerRequest_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.RegisterServerRequest_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.RegisterServerRequest_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.RegisterServerRequest;
    public static final StructureSpecification SPECIFICATION;
    private RequestHeader requestHeader;
    private RegisteredServer server;

    public RegisterServerRequest() {
    }

    public RegisterServerRequest(RequestHeader requestHeader, RegisteredServer registeredServer) {
        this.requestHeader = requestHeader;
        this.server = registeredServer;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    @Override
    public void setRequestHeader(RequestHeader requestHeader) {
        this.requestHeader = requestHeader;
    }

    public RegisteredServer getServer() {
        return this.server;
    }

    public void setServer(RegisteredServer registeredServer) {
        this.server = registeredServer;
    }

    @Override
    public RegisterServerRequest clone() {
        RegisterServerRequest registerServerRequest = (RegisterServerRequest)super.clone();
        registerServerRequest.requestHeader = StructureUtils.clone(this.requestHeader);
        registerServerRequest.server = StructureUtils.clone(this.server);
        return registerServerRequest;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RegisterServerRequest registerServerRequest = (RegisterServerRequest)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getRequestHeader(), registerServerRequest.getRequestHeader())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getServer(), registerServerRequest.getServer());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getRequestHeader(), this.getServer());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
            return this.getRequestHeader();
        }
        if (Fields.Server.getSpecification().equals(fieldSpecification)) {
            return this.getServer();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
            this.setRequestHeader((RequestHeader)object);
            return;
        }
        if (Fields.Server.getSpecification().equals(fieldSpecification)) {
            this.setServer((RegisteredServer)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = RegisterServerRequest.builder();
        builder.setRequestHeader(this.getRequestHeader());
        builder.setServer(this.getServer());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.RequestHeader.getSpecification());
        builder.addField(Fields.Server.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("RegisterServerRequest");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.RegisterServerRequestSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return RegisterServerRequest.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private RequestHeader requestHeader;
        private RegisteredServer server;

        protected Builder() {
        }

        public Builder setRequestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return this;
        }

        public Builder setServer(RegisteredServer registeredServer) {
            this.server = registeredServer;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
                this.setRequestHeader((RequestHeader)object);
                return this;
            }
            if (Fields.Server.getSpecification().equals(fieldSpecification)) {
                this.setServer((RegisteredServer)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public RegisterServerRequest build() {
            return new RegisterServerRequest(this.requestHeader, this.server);
        }
    }

    public static enum Fields {
        RequestHeader("RequestHeader", RequestHeader.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=389")), -1),
        Server("Server", RegisteredServer.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=432")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

