/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.RegisterNodesResponse;
import com.prosysopc.ua.stack.core.RequestHeader;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=558")
public class RegisterNodesRequest
extends AbstractStructure
implements ServiceRequest<RegisterNodesResponse> {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.RegisterNodesRequest_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.RegisterNodesRequest_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.RegisterNodesRequest_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.RegisterNodesRequest;
    public static final StructureSpecification SPECIFICATION;
    private RequestHeader requestHeader;
    private NodeId[] nodesToRegister;

    public RegisterNodesRequest() {
    }

    public RegisterNodesRequest(RequestHeader requestHeader, NodeId[] nodeIdArray) {
        this.requestHeader = requestHeader;
        this.nodesToRegister = nodeIdArray;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    @Override
    public void setRequestHeader(RequestHeader requestHeader) {
        this.requestHeader = requestHeader;
    }

    public NodeId[] getNodesToRegister() {
        return this.nodesToRegister;
    }

    public void setNodesToRegister(NodeId[] nodeIdArray) {
        this.nodesToRegister = nodeIdArray;
    }

    @Override
    public RegisterNodesRequest clone() {
        RegisterNodesRequest registerNodesRequest = (RegisterNodesRequest)super.clone();
        registerNodesRequest.requestHeader = StructureUtils.clone(this.requestHeader);
        registerNodesRequest.nodesToRegister = StructureUtils.clone(this.nodesToRegister);
        return registerNodesRequest;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RegisterNodesRequest registerNodesRequest = (RegisterNodesRequest)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getRequestHeader(), registerNodesRequest.getRequestHeader())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getNodesToRegister(), registerNodesRequest.getNodesToRegister());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getRequestHeader(), this.getNodesToRegister());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
            return this.getRequestHeader();
        }
        if (Fields.NodesToRegister.getSpecification().equals(fieldSpecification)) {
            return this.getNodesToRegister();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
            this.setRequestHeader((RequestHeader)object);
            return;
        }
        if (Fields.NodesToRegister.getSpecification().equals(fieldSpecification)) {
            this.setNodesToRegister((NodeId[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = RegisterNodesRequest.builder();
        builder.setRequestHeader(this.getRequestHeader());
        builder.setNodesToRegister(this.getNodesToRegister());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.RequestHeader.getSpecification());
        builder.addField(Fields.NodesToRegister.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("RegisterNodesRequest");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.RegisterNodesRequestSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return RegisterNodesRequest.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private RequestHeader requestHeader;
        private NodeId[] nodesToRegister;

        protected Builder() {
        }

        public Builder setRequestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return this;
        }

        public Builder setNodesToRegister(NodeId[] nodeIdArray) {
            this.nodesToRegister = nodeIdArray;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
                this.setRequestHeader((RequestHeader)object);
                return this;
            }
            if (Fields.NodesToRegister.getSpecification().equals(fieldSpecification)) {
                this.setNodesToRegister((NodeId[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public RegisterNodesRequest build() {
            return new RegisterNodesRequest(this.requestHeader, this.nodesToRegister);
        }
    }

    public static enum Fields {
        RequestHeader("RequestHeader", RequestHeader.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=389")), -1),
        NodesToRegister("NodesToRegister", NodeId[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=17")), 1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

