/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.NodeAttributes;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=367")
public class ReferenceTypeAttributes
extends NodeAttributes {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.ReferenceTypeAttributes_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.ReferenceTypeAttributes_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.ReferenceTypeAttributes_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.ReferenceTypeAttributes;
    public static final StructureSpecification SPECIFICATION;
    private Boolean isAbstract;
    private Boolean symmetric;
    private LocalizedText inverseName;

    public ReferenceTypeAttributes() {
    }

    public ReferenceTypeAttributes(Boolean bl, Boolean bl2, LocalizedText localizedText) {
        this.isAbstract = bl;
        this.symmetric = bl2;
        this.inverseName = localizedText;
    }

    public ReferenceTypeAttributes(UnsignedInteger unsignedInteger, LocalizedText localizedText, LocalizedText localizedText2, UnsignedInteger unsignedInteger2, UnsignedInteger unsignedInteger3, Boolean bl, Boolean bl2, LocalizedText localizedText3) {
        super(unsignedInteger, localizedText, localizedText2, unsignedInteger2, unsignedInteger3);
        this.isAbstract = bl;
        this.symmetric = bl2;
        this.inverseName = localizedText3;
    }

    public Boolean getIsAbstract() {
        return this.isAbstract;
    }

    public void setIsAbstract(Boolean bl) {
        this.isAbstract = bl;
    }

    public Boolean getSymmetric() {
        return this.symmetric;
    }

    public void setSymmetric(Boolean bl) {
        this.symmetric = bl;
    }

    public LocalizedText getInverseName() {
        return this.inverseName;
    }

    public void setInverseName(LocalizedText localizedText) {
        this.inverseName = localizedText;
    }

    @Override
    public ReferenceTypeAttributes clone() {
        ReferenceTypeAttributes referenceTypeAttributes = (ReferenceTypeAttributes)super.clone();
        referenceTypeAttributes.isAbstract = StructureUtils.clone(this.isAbstract);
        referenceTypeAttributes.symmetric = StructureUtils.clone(this.symmetric);
        referenceTypeAttributes.inverseName = StructureUtils.clone(this.inverseName);
        return referenceTypeAttributes;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ReferenceTypeAttributes referenceTypeAttributes = (ReferenceTypeAttributes)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getSpecifiedAttributes(), referenceTypeAttributes.getSpecifiedAttributes())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getDisplayName(), referenceTypeAttributes.getDisplayName())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getDescription(), referenceTypeAttributes.getDescription())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getWriteMask(), referenceTypeAttributes.getWriteMask())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getUserWriteMask(), referenceTypeAttributes.getUserWriteMask())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getIsAbstract(), referenceTypeAttributes.getIsAbstract())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getSymmetric(), referenceTypeAttributes.getSymmetric())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getInverseName(), referenceTypeAttributes.getInverseName());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getSpecifiedAttributes(), this.getDisplayName(), this.getDescription(), this.getWriteMask(), this.getUserWriteMask(), this.getIsAbstract(), this.getSymmetric(), this.getInverseName());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.SpecifiedAttributes.getSpecification().equals(fieldSpecification)) {
            return this.getSpecifiedAttributes();
        }
        if (Fields.DisplayName.getSpecification().equals(fieldSpecification)) {
            return this.getDisplayName();
        }
        if (Fields.Description.getSpecification().equals(fieldSpecification)) {
            return this.getDescription();
        }
        if (Fields.WriteMask.getSpecification().equals(fieldSpecification)) {
            return this.getWriteMask();
        }
        if (Fields.UserWriteMask.getSpecification().equals(fieldSpecification)) {
            return this.getUserWriteMask();
        }
        if (Fields.IsAbstract.getSpecification().equals(fieldSpecification)) {
            return this.getIsAbstract();
        }
        if (Fields.Symmetric.getSpecification().equals(fieldSpecification)) {
            return this.getSymmetric();
        }
        if (Fields.InverseName.getSpecification().equals(fieldSpecification)) {
            return this.getInverseName();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.SpecifiedAttributes.getSpecification().equals(fieldSpecification)) {
            this.setSpecifiedAttributes((UnsignedInteger)object);
            return;
        }
        if (Fields.DisplayName.getSpecification().equals(fieldSpecification)) {
            this.setDisplayName((LocalizedText)object);
            return;
        }
        if (Fields.Description.getSpecification().equals(fieldSpecification)) {
            this.setDescription((LocalizedText)object);
            return;
        }
        if (Fields.WriteMask.getSpecification().equals(fieldSpecification)) {
            this.setWriteMask((UnsignedInteger)object);
            return;
        }
        if (Fields.UserWriteMask.getSpecification().equals(fieldSpecification)) {
            this.setUserWriteMask((UnsignedInteger)object);
            return;
        }
        if (Fields.IsAbstract.getSpecification().equals(fieldSpecification)) {
            this.setIsAbstract((Boolean)object);
            return;
        }
        if (Fields.Symmetric.getSpecification().equals(fieldSpecification)) {
            this.setSymmetric((Boolean)object);
            return;
        }
        if (Fields.InverseName.getSpecification().equals(fieldSpecification)) {
            this.setInverseName((LocalizedText)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = ReferenceTypeAttributes.builder();
        builder.setSpecifiedAttributes(this.getSpecifiedAttributes());
        builder.setDisplayName(this.getDisplayName());
        builder.setDescription(this.getDescription());
        builder.setWriteMask(this.getWriteMask());
        builder.setUserWriteMask(this.getUserWriteMask());
        builder.setIsAbstract(this.getIsAbstract());
        builder.setSymmetric(this.getSymmetric());
        builder.setInverseName(this.getInverseName());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.SpecifiedAttributes.getSpecification());
        builder.addField(Fields.DisplayName.getSpecification());
        builder.addField(Fields.Description.getSpecification());
        builder.addField(Fields.WriteMask.getSpecification());
        builder.addField(Fields.UserWriteMask.getSpecification());
        builder.addField(Fields.IsAbstract.getSpecification());
        builder.addField(Fields.Symmetric.getSpecification());
        builder.addField(Fields.InverseName.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("ReferenceTypeAttributes");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.ReferenceTypeAttributesSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return ReferenceTypeAttributes.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends NodeAttributes.Builder {
        private UnsignedInteger specifiedAttributes;
        private LocalizedText displayName;
        private LocalizedText description;
        private UnsignedInteger writeMask;
        private UnsignedInteger userWriteMask;
        private Boolean isAbstract;
        private Boolean symmetric;
        private LocalizedText inverseName;

        protected Builder() {
        }

        @Override
        public Builder setSpecifiedAttributes(UnsignedInteger unsignedInteger) {
            this.specifiedAttributes = unsignedInteger;
            return this;
        }

        @Override
        public Builder setDisplayName(LocalizedText localizedText) {
            this.displayName = localizedText;
            return this;
        }

        @Override
        public Builder setDescription(LocalizedText localizedText) {
            this.description = localizedText;
            return this;
        }

        @Override
        public Builder setWriteMask(UnsignedInteger unsignedInteger) {
            this.writeMask = unsignedInteger;
            return this;
        }

        @Override
        public Builder setUserWriteMask(UnsignedInteger unsignedInteger) {
            this.userWriteMask = unsignedInteger;
            return this;
        }

        public Builder setIsAbstract(Boolean bl) {
            this.isAbstract = bl;
            return this;
        }

        public Builder setSymmetric(Boolean bl) {
            this.symmetric = bl;
            return this;
        }

        public Builder setInverseName(LocalizedText localizedText) {
            this.inverseName = localizedText;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.SpecifiedAttributes.getSpecification().equals(fieldSpecification)) {
                this.setSpecifiedAttributes((UnsignedInteger)object);
                return this;
            }
            if (Fields.DisplayName.getSpecification().equals(fieldSpecification)) {
                this.setDisplayName((LocalizedText)object);
                return this;
            }
            if (Fields.Description.getSpecification().equals(fieldSpecification)) {
                this.setDescription((LocalizedText)object);
                return this;
            }
            if (Fields.WriteMask.getSpecification().equals(fieldSpecification)) {
                this.setWriteMask((UnsignedInteger)object);
                return this;
            }
            if (Fields.UserWriteMask.getSpecification().equals(fieldSpecification)) {
                this.setUserWriteMask((UnsignedInteger)object);
                return this;
            }
            if (Fields.IsAbstract.getSpecification().equals(fieldSpecification)) {
                this.setIsAbstract((Boolean)object);
                return this;
            }
            if (Fields.Symmetric.getSpecification().equals(fieldSpecification)) {
                this.setSymmetric((Boolean)object);
                return this;
            }
            if (Fields.InverseName.getSpecification().equals(fieldSpecification)) {
                this.setInverseName((LocalizedText)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public ReferenceTypeAttributes build() {
            return new ReferenceTypeAttributes(this.specifiedAttributes, this.displayName, this.description, this.writeMask, this.userWriteMask, this.isAbstract, this.symmetric, this.inverseName);
        }
    }

    public static enum Fields {
        SpecifiedAttributes("SpecifiedAttributes", UnsignedInteger.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=7")), -1),
        DisplayName("DisplayName", LocalizedText.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=21")), -1),
        Description("Description", LocalizedText.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=21")), -1),
        WriteMask("WriteMask", UnsignedInteger.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=7")), -1),
        UserWriteMask("UserWriteMask", UnsignedInteger.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=7")), -1),
        IsAbstract("IsAbstract", Boolean.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=1")), -1),
        Symmetric("Symmetric", Boolean.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=1")), -1),
        InverseName("InverseName", LocalizedText.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=21")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

