/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.core.ServerState;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=853")
public class RedundantServerDataType
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.RedundantServerDataType_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.RedundantServerDataType_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.RedundantServerDataType_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.RedundantServerDataType;
    public static final StructureSpecification SPECIFICATION;
    private String serverId;
    private UnsignedByte serviceLevel;
    private ServerState serverState;

    public RedundantServerDataType() {
    }

    public RedundantServerDataType(String string, UnsignedByte unsignedByte, ServerState serverState) {
        this.serverId = string;
        this.serviceLevel = unsignedByte;
        this.serverState = serverState;
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String string) {
        this.serverId = string;
    }

    public UnsignedByte getServiceLevel() {
        return this.serviceLevel;
    }

    public void setServiceLevel(UnsignedByte unsignedByte) {
        this.serviceLevel = unsignedByte;
    }

    public ServerState getServerState() {
        return this.serverState;
    }

    public void setServerState(ServerState serverState) {
        this.serverState = serverState;
    }

    @Override
    public RedundantServerDataType clone() {
        RedundantServerDataType redundantServerDataType = (RedundantServerDataType)super.clone();
        redundantServerDataType.serverId = StructureUtils.clone(this.serverId);
        redundantServerDataType.serviceLevel = StructureUtils.clone(this.serviceLevel);
        redundantServerDataType.serverState = StructureUtils.clone(this.serverState);
        return redundantServerDataType;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RedundantServerDataType redundantServerDataType = (RedundantServerDataType)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getServerId(), redundantServerDataType.getServerId())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getServiceLevel(), redundantServerDataType.getServiceLevel())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getServerState(), redundantServerDataType.getServerState());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getServerId(), this.getServiceLevel(), this.getServerState());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.ServerId.getSpecification().equals(fieldSpecification)) {
            return this.getServerId();
        }
        if (Fields.ServiceLevel.getSpecification().equals(fieldSpecification)) {
            return this.getServiceLevel();
        }
        if (Fields.ServerState.getSpecification().equals(fieldSpecification)) {
            return this.getServerState();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.ServerId.getSpecification().equals(fieldSpecification)) {
            this.setServerId((String)object);
            return;
        }
        if (Fields.ServiceLevel.getSpecification().equals(fieldSpecification)) {
            this.setServiceLevel((UnsignedByte)object);
            return;
        }
        if (Fields.ServerState.getSpecification().equals(fieldSpecification)) {
            this.setServerState((ServerState)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = RedundantServerDataType.builder();
        builder.setServerId(this.getServerId());
        builder.setServiceLevel(this.getServiceLevel());
        builder.setServerState(this.getServerState());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.ServerId.getSpecification());
        builder.addField(Fields.ServiceLevel.getSpecification());
        builder.addField(Fields.ServerState.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("RedundantServerDataType");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.RedundantServerDataTypeSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return RedundantServerDataType.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private String serverId;
        private UnsignedByte serviceLevel;
        private ServerState serverState;

        protected Builder() {
        }

        public Builder setServerId(String string) {
            this.serverId = string;
            return this;
        }

        public Builder setServiceLevel(UnsignedByte unsignedByte) {
            this.serviceLevel = unsignedByte;
            return this;
        }

        public Builder setServerState(ServerState serverState) {
            this.serverState = serverState;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.ServerId.getSpecification().equals(fieldSpecification)) {
                this.setServerId((String)object);
                return this;
            }
            if (Fields.ServiceLevel.getSpecification().equals(fieldSpecification)) {
                this.setServiceLevel((UnsignedByte)object);
                return this;
            }
            if (Fields.ServerState.getSpecification().equals(fieldSpecification)) {
                this.setServerState((ServerState)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public RedundantServerDataType build() {
            return new RedundantServerDataType(this.serverId, this.serviceLevel, this.serverState);
        }
    }

    public static enum Fields {
        ServerId("ServerId", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), -1),
        ServiceLevel("ServiceLevel", UnsignedByte.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=3")), -1),
        ServerState("ServerState", ServerState.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=852")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

