/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=626")
public class ReadValueId
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.ReadValueId_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.ReadValueId_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.ReadValueId_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.ReadValueId;
    public static final StructureSpecification SPECIFICATION;
    private NodeId nodeId;
    private UnsignedInteger attributeId;
    private String indexRange;
    private QualifiedName dataEncoding;

    public ReadValueId() {
    }

    public ReadValueId(NodeId nodeId, UnsignedInteger unsignedInteger, String string, QualifiedName qualifiedName) {
        this.nodeId = nodeId;
        this.attributeId = unsignedInteger;
        this.indexRange = string;
        this.dataEncoding = qualifiedName;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(NodeId nodeId) {
        this.nodeId = nodeId;
    }

    public UnsignedInteger getAttributeId() {
        return this.attributeId;
    }

    public void setAttributeId(UnsignedInteger unsignedInteger) {
        this.attributeId = unsignedInteger;
    }

    public String getIndexRange() {
        return this.indexRange;
    }

    public void setIndexRange(String string) {
        this.indexRange = string;
    }

    public QualifiedName getDataEncoding() {
        return this.dataEncoding;
    }

    public void setDataEncoding(QualifiedName qualifiedName) {
        this.dataEncoding = qualifiedName;
    }

    @Override
    public ReadValueId clone() {
        ReadValueId readValueId = (ReadValueId)super.clone();
        readValueId.nodeId = StructureUtils.clone(this.nodeId);
        readValueId.attributeId = StructureUtils.clone(this.attributeId);
        readValueId.indexRange = StructureUtils.clone(this.indexRange);
        readValueId.dataEncoding = StructureUtils.clone(this.dataEncoding);
        return readValueId;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ReadValueId readValueId = (ReadValueId)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getNodeId(), readValueId.getNodeId())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getAttributeId(), readValueId.getAttributeId())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getIndexRange(), readValueId.getIndexRange())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getDataEncoding(), readValueId.getDataEncoding());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getNodeId(), this.getAttributeId(), this.getIndexRange(), this.getDataEncoding());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.NodeId.getSpecification().equals(fieldSpecification)) {
            return this.getNodeId();
        }
        if (Fields.AttributeId.getSpecification().equals(fieldSpecification)) {
            return this.getAttributeId();
        }
        if (Fields.IndexRange.getSpecification().equals(fieldSpecification)) {
            return this.getIndexRange();
        }
        if (Fields.DataEncoding.getSpecification().equals(fieldSpecification)) {
            return this.getDataEncoding();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.NodeId.getSpecification().equals(fieldSpecification)) {
            this.setNodeId((NodeId)object);
            return;
        }
        if (Fields.AttributeId.getSpecification().equals(fieldSpecification)) {
            this.setAttributeId((UnsignedInteger)object);
            return;
        }
        if (Fields.IndexRange.getSpecification().equals(fieldSpecification)) {
            this.setIndexRange((String)object);
            return;
        }
        if (Fields.DataEncoding.getSpecification().equals(fieldSpecification)) {
            this.setDataEncoding((QualifiedName)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = ReadValueId.builder();
        builder.setNodeId(this.getNodeId());
        builder.setAttributeId(this.getAttributeId());
        builder.setIndexRange(this.getIndexRange());
        builder.setDataEncoding(this.getDataEncoding());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.NodeId.getSpecification());
        builder.addField(Fields.AttributeId.getSpecification());
        builder.addField(Fields.IndexRange.getSpecification());
        builder.addField(Fields.DataEncoding.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("ReadValueId");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.ReadValueIdSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return ReadValueId.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private NodeId nodeId;
        private UnsignedInteger attributeId;
        private String indexRange;
        private QualifiedName dataEncoding;

        protected Builder() {
        }

        public Builder setNodeId(NodeId nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public Builder setAttributeId(UnsignedInteger unsignedInteger) {
            this.attributeId = unsignedInteger;
            return this;
        }

        public Builder setIndexRange(String string) {
            this.indexRange = string;
            return this;
        }

        public Builder setDataEncoding(QualifiedName qualifiedName) {
            this.dataEncoding = qualifiedName;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.NodeId.getSpecification().equals(fieldSpecification)) {
                this.setNodeId((NodeId)object);
                return this;
            }
            if (Fields.AttributeId.getSpecification().equals(fieldSpecification)) {
                this.setAttributeId((UnsignedInteger)object);
                return this;
            }
            if (Fields.IndexRange.getSpecification().equals(fieldSpecification)) {
                this.setIndexRange((String)object);
                return this;
            }
            if (Fields.DataEncoding.getSpecification().equals(fieldSpecification)) {
                this.setDataEncoding((QualifiedName)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public ReadValueId build() {
            return new ReadValueId(this.nodeId, this.attributeId, this.indexRange, this.dataEncoding);
        }
    }

    public static enum Fields {
        NodeId("NodeId", NodeId.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=17")), -1),
        AttributeId("AttributeId", UnsignedInteger.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=288")), -1),
        IndexRange("IndexRange", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=291")), -1),
        DataEncoding("DataEncoding", QualifiedName.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=20")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

