/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.AggregateConfiguration;
import com.prosysopc.ua.stack.core.HistoryReadDetails;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=650")
public class ReadProcessedDetails
extends HistoryReadDetails {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.ReadProcessedDetails_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.ReadProcessedDetails_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.ReadProcessedDetails_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.ReadProcessedDetails;
    public static final StructureSpecification SPECIFICATION;
    private DateTime startTime;
    private DateTime endTime;
    private Double processingInterval;
    private NodeId[] aggregateType;
    private AggregateConfiguration aggregateConfiguration;

    public ReadProcessedDetails() {
    }

    public ReadProcessedDetails(DateTime dateTime, DateTime dateTime2, Double d2, NodeId[] nodeIdArray, AggregateConfiguration aggregateConfiguration) {
        this.startTime = dateTime;
        this.endTime = dateTime2;
        this.processingInterval = d2;
        this.aggregateType = nodeIdArray;
        this.aggregateConfiguration = aggregateConfiguration;
    }

    public DateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(DateTime dateTime) {
        this.startTime = dateTime;
    }

    public DateTime getEndTime() {
        return this.endTime;
    }

    public void setEndTime(DateTime dateTime) {
        this.endTime = dateTime;
    }

    public Double getProcessingInterval() {
        return this.processingInterval;
    }

    public void setProcessingInterval(Double d2) {
        this.processingInterval = d2;
    }

    public NodeId[] getAggregateType() {
        return this.aggregateType;
    }

    public void setAggregateType(NodeId[] nodeIdArray) {
        this.aggregateType = nodeIdArray;
    }

    public AggregateConfiguration getAggregateConfiguration() {
        return this.aggregateConfiguration;
    }

    public void setAggregateConfiguration(AggregateConfiguration aggregateConfiguration) {
        this.aggregateConfiguration = aggregateConfiguration;
    }

    @Override
    public ReadProcessedDetails clone() {
        ReadProcessedDetails readProcessedDetails = (ReadProcessedDetails)super.clone();
        readProcessedDetails.startTime = StructureUtils.clone(this.startTime);
        readProcessedDetails.endTime = StructureUtils.clone(this.endTime);
        readProcessedDetails.processingInterval = StructureUtils.clone(this.processingInterval);
        readProcessedDetails.aggregateType = StructureUtils.clone(this.aggregateType);
        readProcessedDetails.aggregateConfiguration = StructureUtils.clone(this.aggregateConfiguration);
        return readProcessedDetails;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ReadProcessedDetails readProcessedDetails = (ReadProcessedDetails)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getStartTime(), readProcessedDetails.getStartTime())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getEndTime(), readProcessedDetails.getEndTime())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getProcessingInterval(), readProcessedDetails.getProcessingInterval())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getAggregateType(), readProcessedDetails.getAggregateType())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getAggregateConfiguration(), readProcessedDetails.getAggregateConfiguration());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getStartTime(), this.getEndTime(), this.getProcessingInterval(), this.getAggregateType(), this.getAggregateConfiguration());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.StartTime.getSpecification().equals(fieldSpecification)) {
            return this.getStartTime();
        }
        if (Fields.EndTime.getSpecification().equals(fieldSpecification)) {
            return this.getEndTime();
        }
        if (Fields.ProcessingInterval.getSpecification().equals(fieldSpecification)) {
            return this.getProcessingInterval();
        }
        if (Fields.AggregateType.getSpecification().equals(fieldSpecification)) {
            return this.getAggregateType();
        }
        if (Fields.AggregateConfiguration.getSpecification().equals(fieldSpecification)) {
            return this.getAggregateConfiguration();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.StartTime.getSpecification().equals(fieldSpecification)) {
            this.setStartTime((DateTime)object);
            return;
        }
        if (Fields.EndTime.getSpecification().equals(fieldSpecification)) {
            this.setEndTime((DateTime)object);
            return;
        }
        if (Fields.ProcessingInterval.getSpecification().equals(fieldSpecification)) {
            this.setProcessingInterval((Double)object);
            return;
        }
        if (Fields.AggregateType.getSpecification().equals(fieldSpecification)) {
            this.setAggregateType((NodeId[])object);
            return;
        }
        if (Fields.AggregateConfiguration.getSpecification().equals(fieldSpecification)) {
            this.setAggregateConfiguration((AggregateConfiguration)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = ReadProcessedDetails.builder();
        builder.setStartTime(this.getStartTime());
        builder.setEndTime(this.getEndTime());
        builder.setProcessingInterval(this.getProcessingInterval());
        builder.setAggregateType(this.getAggregateType());
        builder.setAggregateConfiguration(this.getAggregateConfiguration());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.StartTime.getSpecification());
        builder.addField(Fields.EndTime.getSpecification());
        builder.addField(Fields.ProcessingInterval.getSpecification());
        builder.addField(Fields.AggregateType.getSpecification());
        builder.addField(Fields.AggregateConfiguration.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("ReadProcessedDetails");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.ReadProcessedDetailsSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return ReadProcessedDetails.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends HistoryReadDetails.Builder {
        private DateTime startTime;
        private DateTime endTime;
        private Double processingInterval;
        private NodeId[] aggregateType;
        private AggregateConfiguration aggregateConfiguration;

        protected Builder() {
        }

        public Builder setStartTime(DateTime dateTime) {
            this.startTime = dateTime;
            return this;
        }

        public Builder setEndTime(DateTime dateTime) {
            this.endTime = dateTime;
            return this;
        }

        public Builder setProcessingInterval(Double d2) {
            this.processingInterval = d2;
            return this;
        }

        public Builder setAggregateType(NodeId[] nodeIdArray) {
            this.aggregateType = nodeIdArray;
            return this;
        }

        public Builder setAggregateConfiguration(AggregateConfiguration aggregateConfiguration) {
            this.aggregateConfiguration = aggregateConfiguration;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.StartTime.getSpecification().equals(fieldSpecification)) {
                this.setStartTime((DateTime)object);
                return this;
            }
            if (Fields.EndTime.getSpecification().equals(fieldSpecification)) {
                this.setEndTime((DateTime)object);
                return this;
            }
            if (Fields.ProcessingInterval.getSpecification().equals(fieldSpecification)) {
                this.setProcessingInterval((Double)object);
                return this;
            }
            if (Fields.AggregateType.getSpecification().equals(fieldSpecification)) {
                this.setAggregateType((NodeId[])object);
                return this;
            }
            if (Fields.AggregateConfiguration.getSpecification().equals(fieldSpecification)) {
                this.setAggregateConfiguration((AggregateConfiguration)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public ReadProcessedDetails build() {
            return new ReadProcessedDetails(this.startTime, this.endTime, this.processingInterval, this.aggregateType, this.aggregateConfiguration);
        }
    }

    public static enum Fields {
        StartTime("StartTime", DateTime.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=294")), -1),
        EndTime("EndTime", DateTime.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=294")), -1),
        ProcessingInterval("ProcessingInterval", Double.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=290")), -1),
        AggregateType("AggregateType", NodeId[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=17")), 1),
        AggregateConfiguration("AggregateConfiguration", AggregateConfiguration.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=948")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

