/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.HistoryReadDetails;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=653")
public class ReadAtTimeDetails
extends HistoryReadDetails {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.ReadAtTimeDetails_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.ReadAtTimeDetails_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.ReadAtTimeDetails_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.ReadAtTimeDetails;
    public static final StructureSpecification SPECIFICATION;
    private DateTime[] reqTimes;
    private Boolean useSimpleBounds;

    public ReadAtTimeDetails() {
    }

    public ReadAtTimeDetails(DateTime[] dateTimeArray, Boolean bl) {
        this.reqTimes = dateTimeArray;
        this.useSimpleBounds = bl;
    }

    public DateTime[] getReqTimes() {
        return this.reqTimes;
    }

    public void setReqTimes(DateTime[] dateTimeArray) {
        this.reqTimes = dateTimeArray;
    }

    public Boolean getUseSimpleBounds() {
        return this.useSimpleBounds;
    }

    public void setUseSimpleBounds(Boolean bl) {
        this.useSimpleBounds = bl;
    }

    @Override
    public ReadAtTimeDetails clone() {
        ReadAtTimeDetails readAtTimeDetails = (ReadAtTimeDetails)super.clone();
        readAtTimeDetails.reqTimes = StructureUtils.clone(this.reqTimes);
        readAtTimeDetails.useSimpleBounds = StructureUtils.clone(this.useSimpleBounds);
        return readAtTimeDetails;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ReadAtTimeDetails readAtTimeDetails = (ReadAtTimeDetails)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getReqTimes(), readAtTimeDetails.getReqTimes())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getUseSimpleBounds(), readAtTimeDetails.getUseSimpleBounds());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getReqTimes(), this.getUseSimpleBounds());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.ReqTimes.getSpecification().equals(fieldSpecification)) {
            return this.getReqTimes();
        }
        if (Fields.UseSimpleBounds.getSpecification().equals(fieldSpecification)) {
            return this.getUseSimpleBounds();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.ReqTimes.getSpecification().equals(fieldSpecification)) {
            this.setReqTimes((DateTime[])object);
            return;
        }
        if (Fields.UseSimpleBounds.getSpecification().equals(fieldSpecification)) {
            this.setUseSimpleBounds((Boolean)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = ReadAtTimeDetails.builder();
        builder.setReqTimes(this.getReqTimes());
        builder.setUseSimpleBounds(this.getUseSimpleBounds());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.ReqTimes.getSpecification());
        builder.addField(Fields.UseSimpleBounds.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("ReadAtTimeDetails");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.ReadAtTimeDetailsSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return ReadAtTimeDetails.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends HistoryReadDetails.Builder {
        private DateTime[] reqTimes;
        private Boolean useSimpleBounds;

        protected Builder() {
        }

        public Builder setReqTimes(DateTime[] dateTimeArray) {
            this.reqTimes = dateTimeArray;
            return this;
        }

        public Builder setUseSimpleBounds(Boolean bl) {
            this.useSimpleBounds = bl;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.ReqTimes.getSpecification().equals(fieldSpecification)) {
                this.setReqTimes((DateTime[])object);
                return this;
            }
            if (Fields.UseSimpleBounds.getSpecification().equals(fieldSpecification)) {
                this.setUseSimpleBounds((Boolean)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public ReadAtTimeDetails build() {
            return new ReadAtTimeDetails(this.reqTimes, this.useSimpleBounds);
        }
    }

    public static enum Fields {
        ReqTimes("ReqTimes", DateTime[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=294")), 1),
        UseSimpleBounds("UseSimpleBounds", Boolean.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=1")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

