/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=884")
public class Range
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.Range_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.Range_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.Range_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.Range;
    public static final StructureSpecification SPECIFICATION;
    private Double low;
    private Double high;

    public Range() {
    }

    public Range(Double d2, Double d3) {
        this.low = d2;
        this.high = d3;
    }

    public Double getLow() {
        return this.low;
    }

    public void setLow(Double d2) {
        this.low = d2;
    }

    public Double getHigh() {
        return this.high;
    }

    public void setHigh(Double d2) {
        this.high = d2;
    }

    @Override
    public Range clone() {
        Range range = (Range)super.clone();
        range.low = StructureUtils.clone(this.low);
        range.high = StructureUtils.clone(this.high);
        return range;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Range range = (Range)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getLow(), range.getLow())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getHigh(), range.getHigh());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getLow(), this.getHigh());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.Low.getSpecification().equals(fieldSpecification)) {
            return this.getLow();
        }
        if (Fields.High.getSpecification().equals(fieldSpecification)) {
            return this.getHigh();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.Low.getSpecification().equals(fieldSpecification)) {
            this.setLow((Double)object);
            return;
        }
        if (Fields.High.getSpecification().equals(fieldSpecification)) {
            this.setHigh((Double)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = Range.builder();
        builder.setLow(this.getLow());
        builder.setHigh(this.getHigh());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.Low.getSpecification());
        builder.addField(Fields.High.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("Range");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.RangeSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return Range.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private Double low;
        private Double high;

        protected Builder() {
        }

        public Builder setLow(Double d2) {
            this.low = d2;
            return this;
        }

        public Builder setHigh(Double d2) {
            this.high = d2;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.Low.getSpecification().equals(fieldSpecification)) {
                this.setLow((Double)object);
                return this;
            }
            if (Fields.High.getSpecification().equals(fieldSpecification)) {
                this.setHigh((Double)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Range build() {
            return new Range(this.low, this.high);
        }
    }

    public static enum Fields {
        Low("Low", Double.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=11")), -1),
        High("High", Double.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=11")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

