/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ServiceResponse;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.QueryDataSet;
import com.prosysopc.ua.stack.core.ResponseHeader;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=622")
public class QueryNextResponse
extends AbstractStructure
implements ServiceResponse {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.QueryNextResponse_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.QueryNextResponse_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.QueryNextResponse_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.QueryNextResponse;
    public static final StructureSpecification SPECIFICATION;
    private ResponseHeader responseHeader;
    private QueryDataSet[] queryDataSets;
    private ByteString revisedContinuationPoint;

    public QueryNextResponse() {
    }

    public QueryNextResponse(ResponseHeader responseHeader, QueryDataSet[] queryDataSetArray, ByteString byteString) {
        this.responseHeader = responseHeader;
        this.queryDataSets = queryDataSetArray;
        this.revisedContinuationPoint = byteString;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    @Override
    public void setResponseHeader(ResponseHeader responseHeader) {
        this.responseHeader = responseHeader;
    }

    public QueryDataSet[] getQueryDataSets() {
        return this.queryDataSets;
    }

    public void setQueryDataSets(QueryDataSet[] queryDataSetArray) {
        this.queryDataSets = queryDataSetArray;
    }

    public ByteString getRevisedContinuationPoint() {
        return this.revisedContinuationPoint;
    }

    public void setRevisedContinuationPoint(ByteString byteString) {
        this.revisedContinuationPoint = byteString;
    }

    @Override
    public QueryNextResponse clone() {
        QueryNextResponse queryNextResponse = (QueryNextResponse)super.clone();
        queryNextResponse.responseHeader = StructureUtils.clone(this.responseHeader);
        queryNextResponse.queryDataSets = StructureUtils.clone(this.queryDataSets);
        queryNextResponse.revisedContinuationPoint = StructureUtils.clone(this.revisedContinuationPoint);
        return queryNextResponse;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        QueryNextResponse queryNextResponse = (QueryNextResponse)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getResponseHeader(), queryNextResponse.getResponseHeader())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getQueryDataSets(), queryNextResponse.getQueryDataSets())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getRevisedContinuationPoint(), queryNextResponse.getRevisedContinuationPoint());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getResponseHeader(), this.getQueryDataSets(), this.getRevisedContinuationPoint());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.ResponseHeader.getSpecification().equals(fieldSpecification)) {
            return this.getResponseHeader();
        }
        if (Fields.QueryDataSets.getSpecification().equals(fieldSpecification)) {
            return this.getQueryDataSets();
        }
        if (Fields.RevisedContinuationPoint.getSpecification().equals(fieldSpecification)) {
            return this.getRevisedContinuationPoint();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.ResponseHeader.getSpecification().equals(fieldSpecification)) {
            this.setResponseHeader((ResponseHeader)object);
            return;
        }
        if (Fields.QueryDataSets.getSpecification().equals(fieldSpecification)) {
            this.setQueryDataSets((QueryDataSet[])object);
            return;
        }
        if (Fields.RevisedContinuationPoint.getSpecification().equals(fieldSpecification)) {
            this.setRevisedContinuationPoint((ByteString)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = QueryNextResponse.builder();
        builder.setResponseHeader(this.getResponseHeader());
        builder.setQueryDataSets(this.getQueryDataSets());
        builder.setRevisedContinuationPoint(this.getRevisedContinuationPoint());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.ResponseHeader.getSpecification());
        builder.addField(Fields.QueryDataSets.getSpecification());
        builder.addField(Fields.RevisedContinuationPoint.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("QueryNextResponse");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.QueryNextResponseSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return QueryNextResponse.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private ResponseHeader responseHeader;
        private QueryDataSet[] queryDataSets;
        private ByteString revisedContinuationPoint;

        protected Builder() {
        }

        public Builder setResponseHeader(ResponseHeader responseHeader) {
            this.responseHeader = responseHeader;
            return this;
        }

        public Builder setQueryDataSets(QueryDataSet[] queryDataSetArray) {
            this.queryDataSets = queryDataSetArray;
            return this;
        }

        public Builder setRevisedContinuationPoint(ByteString byteString) {
            this.revisedContinuationPoint = byteString;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.ResponseHeader.getSpecification().equals(fieldSpecification)) {
                this.setResponseHeader((ResponseHeader)object);
                return this;
            }
            if (Fields.QueryDataSets.getSpecification().equals(fieldSpecification)) {
                this.setQueryDataSets((QueryDataSet[])object);
                return this;
            }
            if (Fields.RevisedContinuationPoint.getSpecification().equals(fieldSpecification)) {
                this.setRevisedContinuationPoint((ByteString)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public QueryNextResponse build() {
            return new QueryNextResponse(this.responseHeader, this.queryDataSets, this.revisedContinuationPoint);
        }
    }

    public static enum Fields {
        ResponseHeader("ResponseHeader", ResponseHeader.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=392")), -1),
        QueryDataSets("QueryDataSets", QueryDataSet[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=577")), 1),
        RevisedContinuationPoint("RevisedContinuationPoint", ByteString.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=521")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

