/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.RelativePath;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=570")
public class QueryDataDescription
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.QueryDataDescription_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.QueryDataDescription_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.QueryDataDescription_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.QueryDataDescription;
    public static final StructureSpecification SPECIFICATION;
    private RelativePath relativePath;
    private UnsignedInteger attributeId;
    private String indexRange;

    public QueryDataDescription() {
    }

    public QueryDataDescription(RelativePath relativePath, UnsignedInteger unsignedInteger, String string) {
        this.relativePath = relativePath;
        this.attributeId = unsignedInteger;
        this.indexRange = string;
    }

    public RelativePath getRelativePath() {
        return this.relativePath;
    }

    public void setRelativePath(RelativePath relativePath) {
        this.relativePath = relativePath;
    }

    public UnsignedInteger getAttributeId() {
        return this.attributeId;
    }

    public void setAttributeId(UnsignedInteger unsignedInteger) {
        this.attributeId = unsignedInteger;
    }

    public String getIndexRange() {
        return this.indexRange;
    }

    public void setIndexRange(String string) {
        this.indexRange = string;
    }

    @Override
    public QueryDataDescription clone() {
        QueryDataDescription queryDataDescription = (QueryDataDescription)super.clone();
        queryDataDescription.relativePath = StructureUtils.clone(this.relativePath);
        queryDataDescription.attributeId = StructureUtils.clone(this.attributeId);
        queryDataDescription.indexRange = StructureUtils.clone(this.indexRange);
        return queryDataDescription;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        QueryDataDescription queryDataDescription = (QueryDataDescription)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getRelativePath(), queryDataDescription.getRelativePath())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getAttributeId(), queryDataDescription.getAttributeId())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getIndexRange(), queryDataDescription.getIndexRange());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getRelativePath(), this.getAttributeId(), this.getIndexRange());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.RelativePath.getSpecification().equals(fieldSpecification)) {
            return this.getRelativePath();
        }
        if (Fields.AttributeId.getSpecification().equals(fieldSpecification)) {
            return this.getAttributeId();
        }
        if (Fields.IndexRange.getSpecification().equals(fieldSpecification)) {
            return this.getIndexRange();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.RelativePath.getSpecification().equals(fieldSpecification)) {
            this.setRelativePath((RelativePath)object);
            return;
        }
        if (Fields.AttributeId.getSpecification().equals(fieldSpecification)) {
            this.setAttributeId((UnsignedInteger)object);
            return;
        }
        if (Fields.IndexRange.getSpecification().equals(fieldSpecification)) {
            this.setIndexRange((String)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = QueryDataDescription.builder();
        builder.setRelativePath(this.getRelativePath());
        builder.setAttributeId(this.getAttributeId());
        builder.setIndexRange(this.getIndexRange());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.RelativePath.getSpecification());
        builder.addField(Fields.AttributeId.getSpecification());
        builder.addField(Fields.IndexRange.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("QueryDataDescription");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.QueryDataDescriptionSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return QueryDataDescription.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private RelativePath relativePath;
        private UnsignedInteger attributeId;
        private String indexRange;

        protected Builder() {
        }

        public Builder setRelativePath(RelativePath relativePath) {
            this.relativePath = relativePath;
            return this;
        }

        public Builder setAttributeId(UnsignedInteger unsignedInteger) {
            this.attributeId = unsignedInteger;
            return this;
        }

        public Builder setIndexRange(String string) {
            this.indexRange = string;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.RelativePath.getSpecification().equals(fieldSpecification)) {
                this.setRelativePath((RelativePath)object);
                return this;
            }
            if (Fields.AttributeId.getSpecification().equals(fieldSpecification)) {
                this.setAttributeId((UnsignedInteger)object);
                return this;
            }
            if (Fields.IndexRange.getSpecification().equals(fieldSpecification)) {
                this.setIndexRange((String)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public QueryDataDescription build() {
            return new QueryDataDescription(this.relativePath, this.attributeId, this.indexRange);
        }
    }

    public static enum Fields {
        RelativePath("RelativePath", RelativePath.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=540")), -1),
        AttributeId("AttributeId", UnsignedInteger.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=288")), -1),
        IndexRange("IndexRange", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=291")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

