/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=610")
public class ParsingResult
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.ParsingResult_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.ParsingResult_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.ParsingResult_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.ParsingResult;
    public static final StructureSpecification SPECIFICATION;
    private StatusCode statusCode;
    private StatusCode[] dataStatusCodes;
    private DiagnosticInfo[] dataDiagnosticInfos;

    public ParsingResult() {
    }

    public ParsingResult(StatusCode statusCode, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) {
        this.statusCode = statusCode;
        this.dataStatusCodes = statusCodeArray;
        this.dataDiagnosticInfos = diagnosticInfoArray;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(StatusCode statusCode) {
        this.statusCode = statusCode;
    }

    public StatusCode[] getDataStatusCodes() {
        return this.dataStatusCodes;
    }

    public void setDataStatusCodes(StatusCode[] statusCodeArray) {
        this.dataStatusCodes = statusCodeArray;
    }

    public DiagnosticInfo[] getDataDiagnosticInfos() {
        return this.dataDiagnosticInfos;
    }

    public void setDataDiagnosticInfos(DiagnosticInfo[] diagnosticInfoArray) {
        this.dataDiagnosticInfos = diagnosticInfoArray;
    }

    @Override
    public ParsingResult clone() {
        ParsingResult parsingResult = (ParsingResult)super.clone();
        parsingResult.statusCode = StructureUtils.clone(this.statusCode);
        parsingResult.dataStatusCodes = StructureUtils.clone(this.dataStatusCodes);
        parsingResult.dataDiagnosticInfos = StructureUtils.clone(this.dataDiagnosticInfos);
        return parsingResult;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ParsingResult parsingResult = (ParsingResult)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getStatusCode(), parsingResult.getStatusCode())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getDataStatusCodes(), parsingResult.getDataStatusCodes())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getDataDiagnosticInfos(), parsingResult.getDataDiagnosticInfos());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getStatusCode(), this.getDataStatusCodes(), this.getDataDiagnosticInfos());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.StatusCode.getSpecification().equals(fieldSpecification)) {
            return this.getStatusCode();
        }
        if (Fields.DataStatusCodes.getSpecification().equals(fieldSpecification)) {
            return this.getDataStatusCodes();
        }
        if (Fields.DataDiagnosticInfos.getSpecification().equals(fieldSpecification)) {
            return this.getDataDiagnosticInfos();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.StatusCode.getSpecification().equals(fieldSpecification)) {
            this.setStatusCode((StatusCode)object);
            return;
        }
        if (Fields.DataStatusCodes.getSpecification().equals(fieldSpecification)) {
            this.setDataStatusCodes((StatusCode[])object);
            return;
        }
        if (Fields.DataDiagnosticInfos.getSpecification().equals(fieldSpecification)) {
            this.setDataDiagnosticInfos((DiagnosticInfo[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = ParsingResult.builder();
        builder.setStatusCode(this.getStatusCode());
        builder.setDataStatusCodes(this.getDataStatusCodes());
        builder.setDataDiagnosticInfos(this.getDataDiagnosticInfos());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.StatusCode.getSpecification());
        builder.addField(Fields.DataStatusCodes.getSpecification());
        builder.addField(Fields.DataDiagnosticInfos.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("ParsingResult");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.ParsingResultSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return ParsingResult.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private StatusCode statusCode;
        private StatusCode[] dataStatusCodes;
        private DiagnosticInfo[] dataDiagnosticInfos;

        protected Builder() {
        }

        public Builder setStatusCode(StatusCode statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder setDataStatusCodes(StatusCode[] statusCodeArray) {
            this.dataStatusCodes = statusCodeArray;
            return this;
        }

        public Builder setDataDiagnosticInfos(DiagnosticInfo[] diagnosticInfoArray) {
            this.dataDiagnosticInfos = diagnosticInfoArray;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.StatusCode.getSpecification().equals(fieldSpecification)) {
                this.setStatusCode((StatusCode)object);
                return this;
            }
            if (Fields.DataStatusCodes.getSpecification().equals(fieldSpecification)) {
                this.setDataStatusCodes((StatusCode[])object);
                return this;
            }
            if (Fields.DataDiagnosticInfos.getSpecification().equals(fieldSpecification)) {
                this.setDataDiagnosticInfos((DiagnosticInfo[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public ParsingResult build() {
            return new ParsingResult(this.statusCode, this.dataStatusCodes, this.dataDiagnosticInfos);
        }
    }

    public static enum Fields {
        StatusCode("StatusCode", StatusCode.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=19")), -1),
        DataStatusCodes("DataStatusCodes", StatusCode[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=19")), 1),
        DataDiagnosticInfos("DataDiagnosticInfos", DiagnosticInfo[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=25")), 1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

