/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ServiceResponse;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.ChannelSecurityToken;
import com.prosysopc.ua.stack.core.ResponseHeader;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=447")
public class OpenSecureChannelResponse
extends AbstractStructure
implements ServiceResponse {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.OpenSecureChannelResponse_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.OpenSecureChannelResponse_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.OpenSecureChannelResponse_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.OpenSecureChannelResponse;
    public static final StructureSpecification SPECIFICATION;
    private ResponseHeader responseHeader;
    private UnsignedInteger serverProtocolVersion;
    private ChannelSecurityToken securityToken;
    private ByteString serverNonce;

    public OpenSecureChannelResponse() {
    }

    public OpenSecureChannelResponse(ResponseHeader responseHeader, UnsignedInteger unsignedInteger, ChannelSecurityToken channelSecurityToken, ByteString byteString) {
        this.responseHeader = responseHeader;
        this.serverProtocolVersion = unsignedInteger;
        this.securityToken = channelSecurityToken;
        this.serverNonce = byteString;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    @Override
    public void setResponseHeader(ResponseHeader responseHeader) {
        this.responseHeader = responseHeader;
    }

    public UnsignedInteger getServerProtocolVersion() {
        return this.serverProtocolVersion;
    }

    public void setServerProtocolVersion(UnsignedInteger unsignedInteger) {
        this.serverProtocolVersion = unsignedInteger;
    }

    public ChannelSecurityToken getSecurityToken() {
        return this.securityToken;
    }

    public void setSecurityToken(ChannelSecurityToken channelSecurityToken) {
        this.securityToken = channelSecurityToken;
    }

    public ByteString getServerNonce() {
        return this.serverNonce;
    }

    public void setServerNonce(ByteString byteString) {
        this.serverNonce = byteString;
    }

    @Override
    public OpenSecureChannelResponse clone() {
        OpenSecureChannelResponse openSecureChannelResponse = (OpenSecureChannelResponse)super.clone();
        openSecureChannelResponse.responseHeader = StructureUtils.clone(this.responseHeader);
        openSecureChannelResponse.serverProtocolVersion = StructureUtils.clone(this.serverProtocolVersion);
        openSecureChannelResponse.securityToken = StructureUtils.clone(this.securityToken);
        openSecureChannelResponse.serverNonce = StructureUtils.clone(this.serverNonce);
        return openSecureChannelResponse;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        OpenSecureChannelResponse openSecureChannelResponse = (OpenSecureChannelResponse)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getResponseHeader(), openSecureChannelResponse.getResponseHeader())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getServerProtocolVersion(), openSecureChannelResponse.getServerProtocolVersion())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getSecurityToken(), openSecureChannelResponse.getSecurityToken())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getServerNonce(), openSecureChannelResponse.getServerNonce());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getResponseHeader(), this.getServerProtocolVersion(), this.getSecurityToken(), this.getServerNonce());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.ResponseHeader.getSpecification().equals(fieldSpecification)) {
            return this.getResponseHeader();
        }
        if (Fields.ServerProtocolVersion.getSpecification().equals(fieldSpecification)) {
            return this.getServerProtocolVersion();
        }
        if (Fields.SecurityToken.getSpecification().equals(fieldSpecification)) {
            return this.getSecurityToken();
        }
        if (Fields.ServerNonce.getSpecification().equals(fieldSpecification)) {
            return this.getServerNonce();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.ResponseHeader.getSpecification().equals(fieldSpecification)) {
            this.setResponseHeader((ResponseHeader)object);
            return;
        }
        if (Fields.ServerProtocolVersion.getSpecification().equals(fieldSpecification)) {
            this.setServerProtocolVersion((UnsignedInteger)object);
            return;
        }
        if (Fields.SecurityToken.getSpecification().equals(fieldSpecification)) {
            this.setSecurityToken((ChannelSecurityToken)object);
            return;
        }
        if (Fields.ServerNonce.getSpecification().equals(fieldSpecification)) {
            this.setServerNonce((ByteString)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = OpenSecureChannelResponse.builder();
        builder.setResponseHeader(this.getResponseHeader());
        builder.setServerProtocolVersion(this.getServerProtocolVersion());
        builder.setSecurityToken(this.getSecurityToken());
        builder.setServerNonce(this.getServerNonce());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.ResponseHeader.getSpecification());
        builder.addField(Fields.ServerProtocolVersion.getSpecification());
        builder.addField(Fields.SecurityToken.getSpecification());
        builder.addField(Fields.ServerNonce.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("OpenSecureChannelResponse");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.OpenSecureChannelResponseSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return OpenSecureChannelResponse.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private ResponseHeader responseHeader;
        private UnsignedInteger serverProtocolVersion;
        private ChannelSecurityToken securityToken;
        private ByteString serverNonce;

        protected Builder() {
        }

        public Builder setResponseHeader(ResponseHeader responseHeader) {
            this.responseHeader = responseHeader;
            return this;
        }

        public Builder setServerProtocolVersion(UnsignedInteger unsignedInteger) {
            this.serverProtocolVersion = unsignedInteger;
            return this;
        }

        public Builder setSecurityToken(ChannelSecurityToken channelSecurityToken) {
            this.securityToken = channelSecurityToken;
            return this;
        }

        public Builder setServerNonce(ByteString byteString) {
            this.serverNonce = byteString;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.ResponseHeader.getSpecification().equals(fieldSpecification)) {
                this.setResponseHeader((ResponseHeader)object);
                return this;
            }
            if (Fields.ServerProtocolVersion.getSpecification().equals(fieldSpecification)) {
                this.setServerProtocolVersion((UnsignedInteger)object);
                return this;
            }
            if (Fields.SecurityToken.getSpecification().equals(fieldSpecification)) {
                this.setSecurityToken((ChannelSecurityToken)object);
                return this;
            }
            if (Fields.ServerNonce.getSpecification().equals(fieldSpecification)) {
                this.setServerNonce((ByteString)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public OpenSecureChannelResponse build() {
            return new OpenSecureChannelResponse(this.responseHeader, this.serverProtocolVersion, this.securityToken, this.serverNonce);
        }
    }

    public static enum Fields {
        ResponseHeader("ResponseHeader", ResponseHeader.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=392")), -1),
        ServerProtocolVersion("ServerProtocolVersion", UnsignedInteger.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=7")), -1),
        SecurityToken("SecurityToken", ChannelSecurityToken.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=441")), -1),
        ServerNonce("ServerNonce", ByteString.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=15")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

