/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.core.OpenSecureChannelResponse;
import com.prosysopc.ua.stack.core.RequestHeader;
import com.prosysopc.ua.stack.core.SecurityTokenRequestType;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=444")
public class OpenSecureChannelRequest
extends AbstractStructure
implements ServiceRequest<OpenSecureChannelResponse> {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.OpenSecureChannelRequest_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.OpenSecureChannelRequest_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.OpenSecureChannelRequest_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.OpenSecureChannelRequest;
    public static final StructureSpecification SPECIFICATION;
    private RequestHeader requestHeader;
    private UnsignedInteger clientProtocolVersion;
    private SecurityTokenRequestType requestType;
    private MessageSecurityMode securityMode;
    private ByteString clientNonce;
    private UnsignedInteger requestedLifetime;

    public OpenSecureChannelRequest() {
    }

    public OpenSecureChannelRequest(RequestHeader requestHeader, UnsignedInteger unsignedInteger, SecurityTokenRequestType securityTokenRequestType, MessageSecurityMode messageSecurityMode, ByteString byteString, UnsignedInteger unsignedInteger2) {
        this.requestHeader = requestHeader;
        this.clientProtocolVersion = unsignedInteger;
        this.requestType = securityTokenRequestType;
        this.securityMode = messageSecurityMode;
        this.clientNonce = byteString;
        this.requestedLifetime = unsignedInteger2;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    @Override
    public void setRequestHeader(RequestHeader requestHeader) {
        this.requestHeader = requestHeader;
    }

    public UnsignedInteger getClientProtocolVersion() {
        return this.clientProtocolVersion;
    }

    public void setClientProtocolVersion(UnsignedInteger unsignedInteger) {
        this.clientProtocolVersion = unsignedInteger;
    }

    public SecurityTokenRequestType getRequestType() {
        return this.requestType;
    }

    public void setRequestType(SecurityTokenRequestType securityTokenRequestType) {
        this.requestType = securityTokenRequestType;
    }

    public MessageSecurityMode getSecurityMode() {
        return this.securityMode;
    }

    public void setSecurityMode(MessageSecurityMode messageSecurityMode) {
        this.securityMode = messageSecurityMode;
    }

    public ByteString getClientNonce() {
        return this.clientNonce;
    }

    public void setClientNonce(ByteString byteString) {
        this.clientNonce = byteString;
    }

    public UnsignedInteger getRequestedLifetime() {
        return this.requestedLifetime;
    }

    public void setRequestedLifetime(UnsignedInteger unsignedInteger) {
        this.requestedLifetime = unsignedInteger;
    }

    @Override
    public OpenSecureChannelRequest clone() {
        OpenSecureChannelRequest openSecureChannelRequest = (OpenSecureChannelRequest)super.clone();
        openSecureChannelRequest.requestHeader = StructureUtils.clone(this.requestHeader);
        openSecureChannelRequest.clientProtocolVersion = StructureUtils.clone(this.clientProtocolVersion);
        openSecureChannelRequest.requestType = StructureUtils.clone(this.requestType);
        openSecureChannelRequest.securityMode = StructureUtils.clone(this.securityMode);
        openSecureChannelRequest.clientNonce = StructureUtils.clone(this.clientNonce);
        openSecureChannelRequest.requestedLifetime = StructureUtils.clone(this.requestedLifetime);
        return openSecureChannelRequest;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        OpenSecureChannelRequest openSecureChannelRequest = (OpenSecureChannelRequest)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getRequestHeader(), openSecureChannelRequest.getRequestHeader())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getClientProtocolVersion(), openSecureChannelRequest.getClientProtocolVersion())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getRequestType(), openSecureChannelRequest.getRequestType())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getSecurityMode(), openSecureChannelRequest.getSecurityMode())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getClientNonce(), openSecureChannelRequest.getClientNonce())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getRequestedLifetime(), openSecureChannelRequest.getRequestedLifetime());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getRequestHeader(), this.getClientProtocolVersion(), this.getRequestType(), this.getSecurityMode(), this.getClientNonce(), this.getRequestedLifetime());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
            return this.getRequestHeader();
        }
        if (Fields.ClientProtocolVersion.getSpecification().equals(fieldSpecification)) {
            return this.getClientProtocolVersion();
        }
        if (Fields.RequestType.getSpecification().equals(fieldSpecification)) {
            return this.getRequestType();
        }
        if (Fields.SecurityMode.getSpecification().equals(fieldSpecification)) {
            return this.getSecurityMode();
        }
        if (Fields.ClientNonce.getSpecification().equals(fieldSpecification)) {
            return this.getClientNonce();
        }
        if (Fields.RequestedLifetime.getSpecification().equals(fieldSpecification)) {
            return this.getRequestedLifetime();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
            this.setRequestHeader((RequestHeader)object);
            return;
        }
        if (Fields.ClientProtocolVersion.getSpecification().equals(fieldSpecification)) {
            this.setClientProtocolVersion((UnsignedInteger)object);
            return;
        }
        if (Fields.RequestType.getSpecification().equals(fieldSpecification)) {
            this.setRequestType((SecurityTokenRequestType)object);
            return;
        }
        if (Fields.SecurityMode.getSpecification().equals(fieldSpecification)) {
            this.setSecurityMode((MessageSecurityMode)object);
            return;
        }
        if (Fields.ClientNonce.getSpecification().equals(fieldSpecification)) {
            this.setClientNonce((ByteString)object);
            return;
        }
        if (Fields.RequestedLifetime.getSpecification().equals(fieldSpecification)) {
            this.setRequestedLifetime((UnsignedInteger)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = OpenSecureChannelRequest.builder();
        builder.setRequestHeader(this.getRequestHeader());
        builder.setClientProtocolVersion(this.getClientProtocolVersion());
        builder.setRequestType(this.getRequestType());
        builder.setSecurityMode(this.getSecurityMode());
        builder.setClientNonce(this.getClientNonce());
        builder.setRequestedLifetime(this.getRequestedLifetime());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.RequestHeader.getSpecification());
        builder.addField(Fields.ClientProtocolVersion.getSpecification());
        builder.addField(Fields.RequestType.getSpecification());
        builder.addField(Fields.SecurityMode.getSpecification());
        builder.addField(Fields.ClientNonce.getSpecification());
        builder.addField(Fields.RequestedLifetime.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("OpenSecureChannelRequest");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.OpenSecureChannelRequestSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return OpenSecureChannelRequest.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private RequestHeader requestHeader;
        private UnsignedInteger clientProtocolVersion;
        private SecurityTokenRequestType requestType;
        private MessageSecurityMode securityMode;
        private ByteString clientNonce;
        private UnsignedInteger requestedLifetime;

        protected Builder() {
        }

        public Builder setRequestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return this;
        }

        public Builder setClientProtocolVersion(UnsignedInteger unsignedInteger) {
            this.clientProtocolVersion = unsignedInteger;
            return this;
        }

        public Builder setRequestType(SecurityTokenRequestType securityTokenRequestType) {
            this.requestType = securityTokenRequestType;
            return this;
        }

        public Builder setSecurityMode(MessageSecurityMode messageSecurityMode) {
            this.securityMode = messageSecurityMode;
            return this;
        }

        public Builder setClientNonce(ByteString byteString) {
            this.clientNonce = byteString;
            return this;
        }

        public Builder setRequestedLifetime(UnsignedInteger unsignedInteger) {
            this.requestedLifetime = unsignedInteger;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
                this.setRequestHeader((RequestHeader)object);
                return this;
            }
            if (Fields.ClientProtocolVersion.getSpecification().equals(fieldSpecification)) {
                this.setClientProtocolVersion((UnsignedInteger)object);
                return this;
            }
            if (Fields.RequestType.getSpecification().equals(fieldSpecification)) {
                this.setRequestType((SecurityTokenRequestType)object);
                return this;
            }
            if (Fields.SecurityMode.getSpecification().equals(fieldSpecification)) {
                this.setSecurityMode((MessageSecurityMode)object);
                return this;
            }
            if (Fields.ClientNonce.getSpecification().equals(fieldSpecification)) {
                this.setClientNonce((ByteString)object);
                return this;
            }
            if (Fields.RequestedLifetime.getSpecification().equals(fieldSpecification)) {
                this.setRequestedLifetime((UnsignedInteger)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public OpenSecureChannelRequest build() {
            return new OpenSecureChannelRequest(this.requestHeader, this.clientProtocolVersion, this.requestType, this.securityMode, this.clientNonce, this.requestedLifetime);
        }
    }

    public static enum Fields {
        RequestHeader("RequestHeader", RequestHeader.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=389")), -1),
        ClientProtocolVersion("ClientProtocolVersion", UnsignedInteger.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=7")), -1),
        RequestType("RequestType", SecurityTokenRequestType.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=315")), -1),
        SecurityMode("SecurityMode", MessageSecurityMode.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=302")), -1),
        ClientNonce("ClientNonce", ByteString.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=15")), -1),
        RequestedLifetime("RequestedLifetime", UnsignedInteger.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=7")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

