/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.QueryDataDescription;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=573")
public class NodeTypeDescription
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.NodeTypeDescription_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.NodeTypeDescription_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.NodeTypeDescription_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.NodeTypeDescription;
    public static final StructureSpecification SPECIFICATION;
    private ExpandedNodeId typeDefinitionNode;
    private Boolean includeSubTypes;
    private QueryDataDescription[] dataToReturn;

    public NodeTypeDescription() {
    }

    public NodeTypeDescription(ExpandedNodeId expandedNodeId, Boolean bl, QueryDataDescription[] queryDataDescriptionArray) {
        this.typeDefinitionNode = expandedNodeId;
        this.includeSubTypes = bl;
        this.dataToReturn = queryDataDescriptionArray;
    }

    public ExpandedNodeId getTypeDefinitionNode() {
        return this.typeDefinitionNode;
    }

    public void setTypeDefinitionNode(ExpandedNodeId expandedNodeId) {
        this.typeDefinitionNode = expandedNodeId;
    }

    public Boolean getIncludeSubTypes() {
        return this.includeSubTypes;
    }

    public void setIncludeSubTypes(Boolean bl) {
        this.includeSubTypes = bl;
    }

    public QueryDataDescription[] getDataToReturn() {
        return this.dataToReturn;
    }

    public void setDataToReturn(QueryDataDescription[] queryDataDescriptionArray) {
        this.dataToReturn = queryDataDescriptionArray;
    }

    @Override
    public NodeTypeDescription clone() {
        NodeTypeDescription nodeTypeDescription = (NodeTypeDescription)super.clone();
        nodeTypeDescription.typeDefinitionNode = StructureUtils.clone(this.typeDefinitionNode);
        nodeTypeDescription.includeSubTypes = StructureUtils.clone(this.includeSubTypes);
        nodeTypeDescription.dataToReturn = StructureUtils.clone(this.dataToReturn);
        return nodeTypeDescription;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        NodeTypeDescription nodeTypeDescription = (NodeTypeDescription)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getTypeDefinitionNode(), nodeTypeDescription.getTypeDefinitionNode())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getIncludeSubTypes(), nodeTypeDescription.getIncludeSubTypes())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getDataToReturn(), nodeTypeDescription.getDataToReturn());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getTypeDefinitionNode(), this.getIncludeSubTypes(), this.getDataToReturn());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.TypeDefinitionNode.getSpecification().equals(fieldSpecification)) {
            return this.getTypeDefinitionNode();
        }
        if (Fields.IncludeSubTypes.getSpecification().equals(fieldSpecification)) {
            return this.getIncludeSubTypes();
        }
        if (Fields.DataToReturn.getSpecification().equals(fieldSpecification)) {
            return this.getDataToReturn();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.TypeDefinitionNode.getSpecification().equals(fieldSpecification)) {
            this.setTypeDefinitionNode((ExpandedNodeId)object);
            return;
        }
        if (Fields.IncludeSubTypes.getSpecification().equals(fieldSpecification)) {
            this.setIncludeSubTypes((Boolean)object);
            return;
        }
        if (Fields.DataToReturn.getSpecification().equals(fieldSpecification)) {
            this.setDataToReturn((QueryDataDescription[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = NodeTypeDescription.builder();
        builder.setTypeDefinitionNode(this.getTypeDefinitionNode());
        builder.setIncludeSubTypes(this.getIncludeSubTypes());
        builder.setDataToReturn(this.getDataToReturn());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.TypeDefinitionNode.getSpecification());
        builder.addField(Fields.IncludeSubTypes.getSpecification());
        builder.addField(Fields.DataToReturn.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("NodeTypeDescription");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.NodeTypeDescriptionSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return NodeTypeDescription.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private ExpandedNodeId typeDefinitionNode;
        private Boolean includeSubTypes;
        private QueryDataDescription[] dataToReturn;

        protected Builder() {
        }

        public Builder setTypeDefinitionNode(ExpandedNodeId expandedNodeId) {
            this.typeDefinitionNode = expandedNodeId;
            return this;
        }

        public Builder setIncludeSubTypes(Boolean bl) {
            this.includeSubTypes = bl;
            return this;
        }

        public Builder setDataToReturn(QueryDataDescription[] queryDataDescriptionArray) {
            this.dataToReturn = queryDataDescriptionArray;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.TypeDefinitionNode.getSpecification().equals(fieldSpecification)) {
                this.setTypeDefinitionNode((ExpandedNodeId)object);
                return this;
            }
            if (Fields.IncludeSubTypes.getSpecification().equals(fieldSpecification)) {
                this.setIncludeSubTypes((Boolean)object);
                return this;
            }
            if (Fields.DataToReturn.getSpecification().equals(fieldSpecification)) {
                this.setDataToReturn((QueryDataDescription[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public NodeTypeDescription build() {
            return new NodeTypeDescription(this.typeDefinitionNode, this.includeSubTypes, this.dataToReturn);
        }
    }

    public static enum Fields {
        TypeDefinitionNode("TypeDefinitionNode", ExpandedNodeId.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=18")), -1),
        IncludeSubTypes("IncludeSubTypes", Boolean.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=1")), -1),
        DataToReturn("DataToReturn", QueryDataDescription[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=570")), 1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

