/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.Enumeration;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.typedictionary.EnumerationSpecification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=257")
public enum NodeClass implements Enumeration
{
    Unspecified(0),
    Object(1),
    Variable(2),
    Method(4),
    ObjectType(8),
    VariableType(16),
    ReferenceType(32),
    DataType(64),
    View(128);

    public static final EnumerationSpecification SPECIFICATION;
    public static final EnumSet<NodeClass> NONE;
    public static final EnumSet<NodeClass> ALL;
    private static final Map<Integer, NodeClass> map;
    private final int value;

    private NodeClass(int n3) {
        this.value = n3;
    }

    @Override
    public EnumerationSpecification specification() {
        return SPECIFICATION;
    }

    public static NodeClass valueOf(int n2) {
        return map.get(n2);
    }

    public static NodeClass valueOf(Integer n2) {
        return n2 == null ? null : NodeClass.valueOf((int)n2);
    }

    public static NodeClass valueOf(UnsignedInteger unsignedInteger) {
        return unsignedInteger == null ? null : NodeClass.valueOf(unsignedInteger.intValue());
    }

    public static NodeClass[] valueOf(int[] nArray) {
        NodeClass[] nodeClassArray = new NodeClass[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nodeClassArray[i2] = NodeClass.valueOf(nArray[i2]);
        }
        return nodeClassArray;
    }

    public static NodeClass[] valueOf(Integer[] integerArray) {
        NodeClass[] nodeClassArray = new NodeClass[integerArray.length];
        for (int i2 = 0; i2 < integerArray.length; ++i2) {
            nodeClassArray[i2] = NodeClass.valueOf(integerArray[i2]);
        }
        return nodeClassArray;
    }

    public static NodeClass[] valueOf(UnsignedInteger[] unsignedIntegerArray) {
        NodeClass[] nodeClassArray = new NodeClass[unsignedIntegerArray.length];
        for (int i2 = 0; i2 < unsignedIntegerArray.length; ++i2) {
            nodeClassArray[i2] = NodeClass.valueOf(unsignedIntegerArray[i2]);
        }
        return nodeClassArray;
    }

    public static UnsignedInteger getMask(NodeClass ... nodeClassArray) {
        int n2 = 0;
        for (NodeClass nodeClass : nodeClassArray) {
            n2 |= nodeClass.value;
        }
        return UnsignedInteger.getFromBits(n2);
    }

    public static UnsignedInteger getMask(Collection<NodeClass> collection) {
        int n2 = 0;
        for (NodeClass nodeClass : collection) {
            n2 |= nodeClass.value;
        }
        return UnsignedInteger.getFromBits(n2);
    }

    public static EnumSet<NodeClass> getSet(UnsignedInteger unsignedInteger) {
        return NodeClass.getSet(unsignedInteger.intValue());
    }

    public static EnumSet<NodeClass> getSet(int n2) {
        ArrayList<NodeClass> arrayList = new ArrayList<NodeClass>();
        for (NodeClass nodeClass : NodeClass.values()) {
            if ((n2 & nodeClass.value) != nodeClass.value) continue;
            arrayList.add(nodeClass);
        }
        return EnumSet.copyOf(arrayList);
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        Builder builder = NodeClass.builder();
        builder.setValue(this.getValue());
        return builder;
    }

    static {
        NONE = EnumSet.noneOf(NodeClass.class);
        ALL = EnumSet.allOf(NodeClass.class);
        NodeClass[] nodeClassArray = EnumerationSpecification.builder();
        nodeClassArray.setName("NodeClass");
        nodeClassArray.setTypeId(UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=257")));
        nodeClassArray.addMapping(0, "Unspecified");
        nodeClassArray.addMapping(1, "Object");
        nodeClassArray.addMapping(2, "Variable");
        nodeClassArray.addMapping(4, "Method");
        nodeClassArray.addMapping(8, "ObjectType");
        nodeClassArray.addMapping(16, "VariableType");
        nodeClassArray.addMapping(32, "ReferenceType");
        nodeClassArray.addMapping(64, "DataType");
        nodeClassArray.addMapping(128, "View");
        nodeClassArray.setBuilderSupplier(new EnumerationSpecification.EnumerationBuilderSupplier(){

            @Override
            public Enumeration.Builder get() {
                return NodeClass.builder();
            }
        });
        SPECIFICATION = nodeClassArray.build();
        map = new HashMap<Integer, NodeClass>();
        for (NodeClass nodeClass : NodeClass.values()) {
            map.put(nodeClass.value, nodeClass);
        }
    }

    public static class Builder
    implements Enumeration.Builder {
        private NodeClass value;

        private Builder() {
        }

        @Override
        public NodeClass build() {
            return this.value;
        }

        @Override
        public Builder setValue(int n2) {
            this.value = NodeClass.valueOf(n2);
            if (this.value == null) {
                throw new IllegalArgumentException("Unknown enum NodeClass int value: " + n2);
            }
            return this;
        }
    }
}

