/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=349")
public class NodeAttributes
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.NodeAttributes_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.NodeAttributes_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.NodeAttributes_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.NodeAttributes;
    public static final StructureSpecification SPECIFICATION;
    private UnsignedInteger specifiedAttributes;
    private LocalizedText displayName;
    private LocalizedText description;
    private UnsignedInteger writeMask;
    private UnsignedInteger userWriteMask;

    public NodeAttributes() {
    }

    public NodeAttributes(UnsignedInteger unsignedInteger, LocalizedText localizedText, LocalizedText localizedText2, UnsignedInteger unsignedInteger2, UnsignedInteger unsignedInteger3) {
        this.specifiedAttributes = unsignedInteger;
        this.displayName = localizedText;
        this.description = localizedText2;
        this.writeMask = unsignedInteger2;
        this.userWriteMask = unsignedInteger3;
    }

    public UnsignedInteger getSpecifiedAttributes() {
        return this.specifiedAttributes;
    }

    public void setSpecifiedAttributes(UnsignedInteger unsignedInteger) {
        this.specifiedAttributes = unsignedInteger;
    }

    public LocalizedText getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(LocalizedText localizedText) {
        this.displayName = localizedText;
    }

    public LocalizedText getDescription() {
        return this.description;
    }

    public void setDescription(LocalizedText localizedText) {
        this.description = localizedText;
    }

    public UnsignedInteger getWriteMask() {
        return this.writeMask;
    }

    public void setWriteMask(UnsignedInteger unsignedInteger) {
        this.writeMask = unsignedInteger;
    }

    public UnsignedInteger getUserWriteMask() {
        return this.userWriteMask;
    }

    public void setUserWriteMask(UnsignedInteger unsignedInteger) {
        this.userWriteMask = unsignedInteger;
    }

    @Override
    public NodeAttributes clone() {
        NodeAttributes nodeAttributes = (NodeAttributes)super.clone();
        nodeAttributes.specifiedAttributes = StructureUtils.clone(this.specifiedAttributes);
        nodeAttributes.displayName = StructureUtils.clone(this.displayName);
        nodeAttributes.description = StructureUtils.clone(this.description);
        nodeAttributes.writeMask = StructureUtils.clone(this.writeMask);
        nodeAttributes.userWriteMask = StructureUtils.clone(this.userWriteMask);
        return nodeAttributes;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        NodeAttributes nodeAttributes = (NodeAttributes)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getSpecifiedAttributes(), nodeAttributes.getSpecifiedAttributes())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getDisplayName(), nodeAttributes.getDisplayName())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getDescription(), nodeAttributes.getDescription())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getWriteMask(), nodeAttributes.getWriteMask())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getUserWriteMask(), nodeAttributes.getUserWriteMask());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getSpecifiedAttributes(), this.getDisplayName(), this.getDescription(), this.getWriteMask(), this.getUserWriteMask());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.SpecifiedAttributes.getSpecification().equals(fieldSpecification)) {
            return this.getSpecifiedAttributes();
        }
        if (Fields.DisplayName.getSpecification().equals(fieldSpecification)) {
            return this.getDisplayName();
        }
        if (Fields.Description.getSpecification().equals(fieldSpecification)) {
            return this.getDescription();
        }
        if (Fields.WriteMask.getSpecification().equals(fieldSpecification)) {
            return this.getWriteMask();
        }
        if (Fields.UserWriteMask.getSpecification().equals(fieldSpecification)) {
            return this.getUserWriteMask();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.SpecifiedAttributes.getSpecification().equals(fieldSpecification)) {
            this.setSpecifiedAttributes((UnsignedInteger)object);
            return;
        }
        if (Fields.DisplayName.getSpecification().equals(fieldSpecification)) {
            this.setDisplayName((LocalizedText)object);
            return;
        }
        if (Fields.Description.getSpecification().equals(fieldSpecification)) {
            this.setDescription((LocalizedText)object);
            return;
        }
        if (Fields.WriteMask.getSpecification().equals(fieldSpecification)) {
            this.setWriteMask((UnsignedInteger)object);
            return;
        }
        if (Fields.UserWriteMask.getSpecification().equals(fieldSpecification)) {
            this.setUserWriteMask((UnsignedInteger)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = NodeAttributes.builder();
        builder.setSpecifiedAttributes(this.getSpecifiedAttributes());
        builder.setDisplayName(this.getDisplayName());
        builder.setDescription(this.getDescription());
        builder.setWriteMask(this.getWriteMask());
        builder.setUserWriteMask(this.getUserWriteMask());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.SpecifiedAttributes.getSpecification());
        builder.addField(Fields.DisplayName.getSpecification());
        builder.addField(Fields.Description.getSpecification());
        builder.addField(Fields.WriteMask.getSpecification());
        builder.addField(Fields.UserWriteMask.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("NodeAttributes");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.NodeAttributesSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return NodeAttributes.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private UnsignedInteger specifiedAttributes;
        private LocalizedText displayName;
        private LocalizedText description;
        private UnsignedInteger writeMask;
        private UnsignedInteger userWriteMask;

        protected Builder() {
        }

        public Builder setSpecifiedAttributes(UnsignedInteger unsignedInteger) {
            this.specifiedAttributes = unsignedInteger;
            return this;
        }

        public Builder setDisplayName(LocalizedText localizedText) {
            this.displayName = localizedText;
            return this;
        }

        public Builder setDescription(LocalizedText localizedText) {
            this.description = localizedText;
            return this;
        }

        public Builder setWriteMask(UnsignedInteger unsignedInteger) {
            this.writeMask = unsignedInteger;
            return this;
        }

        public Builder setUserWriteMask(UnsignedInteger unsignedInteger) {
            this.userWriteMask = unsignedInteger;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.SpecifiedAttributes.getSpecification().equals(fieldSpecification)) {
                this.setSpecifiedAttributes((UnsignedInteger)object);
                return this;
            }
            if (Fields.DisplayName.getSpecification().equals(fieldSpecification)) {
                this.setDisplayName((LocalizedText)object);
                return this;
            }
            if (Fields.Description.getSpecification().equals(fieldSpecification)) {
                this.setDescription((LocalizedText)object);
                return this;
            }
            if (Fields.WriteMask.getSpecification().equals(fieldSpecification)) {
                this.setWriteMask((UnsignedInteger)object);
                return this;
            }
            if (Fields.UserWriteMask.getSpecification().equals(fieldSpecification)) {
                this.setUserWriteMask((UnsignedInteger)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public NodeAttributes build() {
            return new NodeAttributes(this.specifiedAttributes, this.displayName, this.description, this.writeMask, this.userWriteMask);
        }
    }

    public static enum Fields {
        SpecifiedAttributes("SpecifiedAttributes", UnsignedInteger.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=7")), -1),
        DisplayName("DisplayName", LocalizedText.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=21")), -1),
        Description("Description", LocalizedText.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=21")), -1),
        WriteMask("WriteMask", UnsignedInteger.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=7")), -1),
        UserWriteMask("UserWriteMask", UnsignedInteger.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=7")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

