/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=740")
public class MonitoringParameters
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.MonitoringParameters_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.MonitoringParameters_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.MonitoringParameters_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.MonitoringParameters;
    public static final StructureSpecification SPECIFICATION;
    private UnsignedInteger clientHandle;
    private Double samplingInterval;
    private ExtensionObject filter;
    private UnsignedInteger queueSize;
    private Boolean discardOldest;

    public MonitoringParameters() {
    }

    public MonitoringParameters(UnsignedInteger unsignedInteger, Double d2, ExtensionObject extensionObject, UnsignedInteger unsignedInteger2, Boolean bl) {
        this.clientHandle = unsignedInteger;
        this.samplingInterval = d2;
        this.filter = extensionObject;
        this.queueSize = unsignedInteger2;
        this.discardOldest = bl;
    }

    public UnsignedInteger getClientHandle() {
        return this.clientHandle;
    }

    public void setClientHandle(UnsignedInteger unsignedInteger) {
        this.clientHandle = unsignedInteger;
    }

    public Double getSamplingInterval() {
        return this.samplingInterval;
    }

    public void setSamplingInterval(Double d2) {
        this.samplingInterval = d2;
    }

    public ExtensionObject getFilter() {
        return this.filter;
    }

    public void setFilter(ExtensionObject extensionObject) {
        this.filter = extensionObject;
    }

    public UnsignedInteger getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(UnsignedInteger unsignedInteger) {
        this.queueSize = unsignedInteger;
    }

    public Boolean getDiscardOldest() {
        return this.discardOldest;
    }

    public void setDiscardOldest(Boolean bl) {
        this.discardOldest = bl;
    }

    @Override
    public MonitoringParameters clone() {
        MonitoringParameters monitoringParameters = (MonitoringParameters)super.clone();
        monitoringParameters.clientHandle = StructureUtils.clone(this.clientHandle);
        monitoringParameters.samplingInterval = StructureUtils.clone(this.samplingInterval);
        monitoringParameters.filter = StructureUtils.clone(this.filter);
        monitoringParameters.queueSize = StructureUtils.clone(this.queueSize);
        monitoringParameters.discardOldest = StructureUtils.clone(this.discardOldest);
        return monitoringParameters;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MonitoringParameters monitoringParameters = (MonitoringParameters)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getClientHandle(), monitoringParameters.getClientHandle())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getSamplingInterval(), monitoringParameters.getSamplingInterval())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getFilter(), monitoringParameters.getFilter())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getQueueSize(), monitoringParameters.getQueueSize())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getDiscardOldest(), monitoringParameters.getDiscardOldest());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getClientHandle(), this.getSamplingInterval(), this.getFilter(), this.getQueueSize(), this.getDiscardOldest());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.ClientHandle.getSpecification().equals(fieldSpecification)) {
            return this.getClientHandle();
        }
        if (Fields.SamplingInterval.getSpecification().equals(fieldSpecification)) {
            return this.getSamplingInterval();
        }
        if (Fields.Filter.getSpecification().equals(fieldSpecification)) {
            return this.getFilter();
        }
        if (Fields.QueueSize.getSpecification().equals(fieldSpecification)) {
            return this.getQueueSize();
        }
        if (Fields.DiscardOldest.getSpecification().equals(fieldSpecification)) {
            return this.getDiscardOldest();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.ClientHandle.getSpecification().equals(fieldSpecification)) {
            this.setClientHandle((UnsignedInteger)object);
            return;
        }
        if (Fields.SamplingInterval.getSpecification().equals(fieldSpecification)) {
            this.setSamplingInterval((Double)object);
            return;
        }
        if (Fields.Filter.getSpecification().equals(fieldSpecification)) {
            this.setFilter((ExtensionObject)object);
            return;
        }
        if (Fields.QueueSize.getSpecification().equals(fieldSpecification)) {
            this.setQueueSize((UnsignedInteger)object);
            return;
        }
        if (Fields.DiscardOldest.getSpecification().equals(fieldSpecification)) {
            this.setDiscardOldest((Boolean)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = MonitoringParameters.builder();
        builder.setClientHandle(this.getClientHandle());
        builder.setSamplingInterval(this.getSamplingInterval());
        builder.setFilter(this.getFilter());
        builder.setQueueSize(this.getQueueSize());
        builder.setDiscardOldest(this.getDiscardOldest());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.ClientHandle.getSpecification());
        builder.addField(Fields.SamplingInterval.getSpecification());
        builder.addField(Fields.Filter.getSpecification());
        builder.addField(Fields.QueueSize.getSpecification());
        builder.addField(Fields.DiscardOldest.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("MonitoringParameters");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.MonitoringParametersSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return MonitoringParameters.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private UnsignedInteger clientHandle;
        private Double samplingInterval;
        private ExtensionObject filter;
        private UnsignedInteger queueSize;
        private Boolean discardOldest;

        protected Builder() {
        }

        public Builder setClientHandle(UnsignedInteger unsignedInteger) {
            this.clientHandle = unsignedInteger;
            return this;
        }

        public Builder setSamplingInterval(Double d2) {
            this.samplingInterval = d2;
            return this;
        }

        public Builder setFilter(ExtensionObject extensionObject) {
            this.filter = extensionObject;
            return this;
        }

        public Builder setQueueSize(UnsignedInteger unsignedInteger) {
            this.queueSize = unsignedInteger;
            return this;
        }

        public Builder setDiscardOldest(Boolean bl) {
            this.discardOldest = bl;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.ClientHandle.getSpecification().equals(fieldSpecification)) {
                this.setClientHandle((UnsignedInteger)object);
                return this;
            }
            if (Fields.SamplingInterval.getSpecification().equals(fieldSpecification)) {
                this.setSamplingInterval((Double)object);
                return this;
            }
            if (Fields.Filter.getSpecification().equals(fieldSpecification)) {
                this.setFilter((ExtensionObject)object);
                return this;
            }
            if (Fields.QueueSize.getSpecification().equals(fieldSpecification)) {
                this.setQueueSize((UnsignedInteger)object);
                return this;
            }
            if (Fields.DiscardOldest.getSpecification().equals(fieldSpecification)) {
                this.setDiscardOldest((Boolean)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public MonitoringParameters build() {
            return new MonitoringParameters(this.clientHandle, this.samplingInterval, this.filter, this.queueSize, this.discardOldest);
        }
    }

    public static enum Fields {
        ClientHandle("ClientHandle", UnsignedInteger.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=288")), -1),
        SamplingInterval("SamplingInterval", Double.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=290")), -1),
        Filter("Filter", Structure.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=22")), -1),
        QueueSize("QueueSize", UnsignedInteger.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=289")), -1),
        DiscardOldest("DiscardOldest", Boolean.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=1")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

