/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=758")
public class MonitoredItemModifyResult
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.MonitoredItemModifyResult_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.MonitoredItemModifyResult_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.MonitoredItemModifyResult_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.MonitoredItemModifyResult;
    public static final StructureSpecification SPECIFICATION;
    private StatusCode statusCode;
    private Double revisedSamplingInterval;
    private UnsignedInteger revisedQueueSize;
    private ExtensionObject filterResult;

    public MonitoredItemModifyResult() {
    }

    public MonitoredItemModifyResult(StatusCode statusCode, Double d2, UnsignedInteger unsignedInteger, ExtensionObject extensionObject) {
        this.statusCode = statusCode;
        this.revisedSamplingInterval = d2;
        this.revisedQueueSize = unsignedInteger;
        this.filterResult = extensionObject;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(StatusCode statusCode) {
        this.statusCode = statusCode;
    }

    public Double getRevisedSamplingInterval() {
        return this.revisedSamplingInterval;
    }

    public void setRevisedSamplingInterval(Double d2) {
        this.revisedSamplingInterval = d2;
    }

    public UnsignedInteger getRevisedQueueSize() {
        return this.revisedQueueSize;
    }

    public void setRevisedQueueSize(UnsignedInteger unsignedInteger) {
        this.revisedQueueSize = unsignedInteger;
    }

    public ExtensionObject getFilterResult() {
        return this.filterResult;
    }

    public void setFilterResult(ExtensionObject extensionObject) {
        this.filterResult = extensionObject;
    }

    @Override
    public MonitoredItemModifyResult clone() {
        MonitoredItemModifyResult monitoredItemModifyResult = (MonitoredItemModifyResult)super.clone();
        monitoredItemModifyResult.statusCode = StructureUtils.clone(this.statusCode);
        monitoredItemModifyResult.revisedSamplingInterval = StructureUtils.clone(this.revisedSamplingInterval);
        monitoredItemModifyResult.revisedQueueSize = StructureUtils.clone(this.revisedQueueSize);
        monitoredItemModifyResult.filterResult = StructureUtils.clone(this.filterResult);
        return monitoredItemModifyResult;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MonitoredItemModifyResult monitoredItemModifyResult = (MonitoredItemModifyResult)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getStatusCode(), monitoredItemModifyResult.getStatusCode())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getRevisedSamplingInterval(), monitoredItemModifyResult.getRevisedSamplingInterval())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getRevisedQueueSize(), monitoredItemModifyResult.getRevisedQueueSize())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getFilterResult(), monitoredItemModifyResult.getFilterResult());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getStatusCode(), this.getRevisedSamplingInterval(), this.getRevisedQueueSize(), this.getFilterResult());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.StatusCode.getSpecification().equals(fieldSpecification)) {
            return this.getStatusCode();
        }
        if (Fields.RevisedSamplingInterval.getSpecification().equals(fieldSpecification)) {
            return this.getRevisedSamplingInterval();
        }
        if (Fields.RevisedQueueSize.getSpecification().equals(fieldSpecification)) {
            return this.getRevisedQueueSize();
        }
        if (Fields.FilterResult.getSpecification().equals(fieldSpecification)) {
            return this.getFilterResult();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.StatusCode.getSpecification().equals(fieldSpecification)) {
            this.setStatusCode((StatusCode)object);
            return;
        }
        if (Fields.RevisedSamplingInterval.getSpecification().equals(fieldSpecification)) {
            this.setRevisedSamplingInterval((Double)object);
            return;
        }
        if (Fields.RevisedQueueSize.getSpecification().equals(fieldSpecification)) {
            this.setRevisedQueueSize((UnsignedInteger)object);
            return;
        }
        if (Fields.FilterResult.getSpecification().equals(fieldSpecification)) {
            this.setFilterResult((ExtensionObject)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = MonitoredItemModifyResult.builder();
        builder.setStatusCode(this.getStatusCode());
        builder.setRevisedSamplingInterval(this.getRevisedSamplingInterval());
        builder.setRevisedQueueSize(this.getRevisedQueueSize());
        builder.setFilterResult(this.getFilterResult());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.StatusCode.getSpecification());
        builder.addField(Fields.RevisedSamplingInterval.getSpecification());
        builder.addField(Fields.RevisedQueueSize.getSpecification());
        builder.addField(Fields.FilterResult.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("MonitoredItemModifyResult");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.MonitoredItemModifyResultSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return MonitoredItemModifyResult.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private StatusCode statusCode;
        private Double revisedSamplingInterval;
        private UnsignedInteger revisedQueueSize;
        private ExtensionObject filterResult;

        protected Builder() {
        }

        public Builder setStatusCode(StatusCode statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder setRevisedSamplingInterval(Double d2) {
            this.revisedSamplingInterval = d2;
            return this;
        }

        public Builder setRevisedQueueSize(UnsignedInteger unsignedInteger) {
            this.revisedQueueSize = unsignedInteger;
            return this;
        }

        public Builder setFilterResult(ExtensionObject extensionObject) {
            this.filterResult = extensionObject;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.StatusCode.getSpecification().equals(fieldSpecification)) {
                this.setStatusCode((StatusCode)object);
                return this;
            }
            if (Fields.RevisedSamplingInterval.getSpecification().equals(fieldSpecification)) {
                this.setRevisedSamplingInterval((Double)object);
                return this;
            }
            if (Fields.RevisedQueueSize.getSpecification().equals(fieldSpecification)) {
                this.setRevisedQueueSize((UnsignedInteger)object);
                return this;
            }
            if (Fields.FilterResult.getSpecification().equals(fieldSpecification)) {
                this.setFilterResult((ExtensionObject)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public MonitoredItemModifyResult build() {
            return new MonitoredItemModifyResult(this.statusCode, this.revisedSamplingInterval, this.revisedQueueSize, this.filterResult);
        }
    }

    public static enum Fields {
        StatusCode("StatusCode", StatusCode.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=19")), -1),
        RevisedSamplingInterval("RevisedSamplingInterval", Double.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=290")), -1),
        RevisedQueueSize("RevisedQueueSize", UnsignedInteger.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=289")), -1),
        FilterResult("FilterResult", Structure.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=22")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

