/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.MonitoringMode;
import com.prosysopc.ua.stack.core.MonitoringParameters;
import com.prosysopc.ua.stack.core.ReadValueId;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=743")
public class MonitoredItemCreateRequest
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.MonitoredItemCreateRequest_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.MonitoredItemCreateRequest_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.MonitoredItemCreateRequest_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.MonitoredItemCreateRequest;
    public static final StructureSpecification SPECIFICATION;
    private ReadValueId itemToMonitor;
    private MonitoringMode monitoringMode;
    private MonitoringParameters requestedParameters;

    public MonitoredItemCreateRequest() {
    }

    public MonitoredItemCreateRequest(ReadValueId readValueId, MonitoringMode monitoringMode, MonitoringParameters monitoringParameters) {
        this.itemToMonitor = readValueId;
        this.monitoringMode = monitoringMode;
        this.requestedParameters = monitoringParameters;
    }

    public ReadValueId getItemToMonitor() {
        return this.itemToMonitor;
    }

    public void setItemToMonitor(ReadValueId readValueId) {
        this.itemToMonitor = readValueId;
    }

    public MonitoringMode getMonitoringMode() {
        return this.monitoringMode;
    }

    public void setMonitoringMode(MonitoringMode monitoringMode) {
        this.monitoringMode = monitoringMode;
    }

    public MonitoringParameters getRequestedParameters() {
        return this.requestedParameters;
    }

    public void setRequestedParameters(MonitoringParameters monitoringParameters) {
        this.requestedParameters = monitoringParameters;
    }

    @Override
    public MonitoredItemCreateRequest clone() {
        MonitoredItemCreateRequest monitoredItemCreateRequest = (MonitoredItemCreateRequest)super.clone();
        monitoredItemCreateRequest.itemToMonitor = StructureUtils.clone(this.itemToMonitor);
        monitoredItemCreateRequest.monitoringMode = StructureUtils.clone(this.monitoringMode);
        monitoredItemCreateRequest.requestedParameters = StructureUtils.clone(this.requestedParameters);
        return monitoredItemCreateRequest;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MonitoredItemCreateRequest monitoredItemCreateRequest = (MonitoredItemCreateRequest)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getItemToMonitor(), monitoredItemCreateRequest.getItemToMonitor())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getMonitoringMode(), monitoredItemCreateRequest.getMonitoringMode())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getRequestedParameters(), monitoredItemCreateRequest.getRequestedParameters());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getItemToMonitor(), this.getMonitoringMode(), this.getRequestedParameters());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.ItemToMonitor.getSpecification().equals(fieldSpecification)) {
            return this.getItemToMonitor();
        }
        if (Fields.MonitoringMode.getSpecification().equals(fieldSpecification)) {
            return this.getMonitoringMode();
        }
        if (Fields.RequestedParameters.getSpecification().equals(fieldSpecification)) {
            return this.getRequestedParameters();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.ItemToMonitor.getSpecification().equals(fieldSpecification)) {
            this.setItemToMonitor((ReadValueId)object);
            return;
        }
        if (Fields.MonitoringMode.getSpecification().equals(fieldSpecification)) {
            this.setMonitoringMode((MonitoringMode)object);
            return;
        }
        if (Fields.RequestedParameters.getSpecification().equals(fieldSpecification)) {
            this.setRequestedParameters((MonitoringParameters)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = MonitoredItemCreateRequest.builder();
        builder.setItemToMonitor(this.getItemToMonitor());
        builder.setMonitoringMode(this.getMonitoringMode());
        builder.setRequestedParameters(this.getRequestedParameters());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.ItemToMonitor.getSpecification());
        builder.addField(Fields.MonitoringMode.getSpecification());
        builder.addField(Fields.RequestedParameters.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("MonitoredItemCreateRequest");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.MonitoredItemCreateRequestSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return MonitoredItemCreateRequest.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private ReadValueId itemToMonitor;
        private MonitoringMode monitoringMode;
        private MonitoringParameters requestedParameters;

        protected Builder() {
        }

        public Builder setItemToMonitor(ReadValueId readValueId) {
            this.itemToMonitor = readValueId;
            return this;
        }

        public Builder setMonitoringMode(MonitoringMode monitoringMode) {
            this.monitoringMode = monitoringMode;
            return this;
        }

        public Builder setRequestedParameters(MonitoringParameters monitoringParameters) {
            this.requestedParameters = monitoringParameters;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.ItemToMonitor.getSpecification().equals(fieldSpecification)) {
                this.setItemToMonitor((ReadValueId)object);
                return this;
            }
            if (Fields.MonitoringMode.getSpecification().equals(fieldSpecification)) {
                this.setMonitoringMode((MonitoringMode)object);
                return this;
            }
            if (Fields.RequestedParameters.getSpecification().equals(fieldSpecification)) {
                this.setRequestedParameters((MonitoringParameters)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public MonitoredItemCreateRequest build() {
            return new MonitoredItemCreateRequest(this.itemToMonitor, this.monitoringMode, this.requestedParameters);
        }
    }

    public static enum Fields {
        ItemToMonitor("ItemToMonitor", ReadValueId.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=626")), -1),
        MonitoringMode("MonitoringMode", MonitoringMode.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=716")), -1),
        RequestedParameters("RequestedParameters", MonitoringParameters.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=740")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

