/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.HistoryUpdateType;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=11216")
public class ModificationInfo
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.ModificationInfo_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.ModificationInfo_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.ModificationInfo_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.ModificationInfo;
    public static final StructureSpecification SPECIFICATION;
    private DateTime modificationTime;
    private HistoryUpdateType updateType;
    private String userName;

    public ModificationInfo() {
    }

    public ModificationInfo(DateTime dateTime, HistoryUpdateType historyUpdateType, String string) {
        this.modificationTime = dateTime;
        this.updateType = historyUpdateType;
        this.userName = string;
    }

    public DateTime getModificationTime() {
        return this.modificationTime;
    }

    public void setModificationTime(DateTime dateTime) {
        this.modificationTime = dateTime;
    }

    public HistoryUpdateType getUpdateType() {
        return this.updateType;
    }

    public void setUpdateType(HistoryUpdateType historyUpdateType) {
        this.updateType = historyUpdateType;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    @Override
    public ModificationInfo clone() {
        ModificationInfo modificationInfo = (ModificationInfo)super.clone();
        modificationInfo.modificationTime = StructureUtils.clone(this.modificationTime);
        modificationInfo.updateType = StructureUtils.clone(this.updateType);
        modificationInfo.userName = StructureUtils.clone(this.userName);
        return modificationInfo;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ModificationInfo modificationInfo = (ModificationInfo)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getModificationTime(), modificationInfo.getModificationTime())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getUpdateType(), modificationInfo.getUpdateType())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getUserName(), modificationInfo.getUserName());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getModificationTime(), this.getUpdateType(), this.getUserName());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.ModificationTime.getSpecification().equals(fieldSpecification)) {
            return this.getModificationTime();
        }
        if (Fields.UpdateType.getSpecification().equals(fieldSpecification)) {
            return this.getUpdateType();
        }
        if (Fields.UserName.getSpecification().equals(fieldSpecification)) {
            return this.getUserName();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.ModificationTime.getSpecification().equals(fieldSpecification)) {
            this.setModificationTime((DateTime)object);
            return;
        }
        if (Fields.UpdateType.getSpecification().equals(fieldSpecification)) {
            this.setUpdateType((HistoryUpdateType)object);
            return;
        }
        if (Fields.UserName.getSpecification().equals(fieldSpecification)) {
            this.setUserName((String)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = ModificationInfo.builder();
        builder.setModificationTime(this.getModificationTime());
        builder.setUpdateType(this.getUpdateType());
        builder.setUserName(this.getUserName());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.ModificationTime.getSpecification());
        builder.addField(Fields.UpdateType.getSpecification());
        builder.addField(Fields.UserName.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("ModificationInfo");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.ModificationInfoSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return ModificationInfo.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private DateTime modificationTime;
        private HistoryUpdateType updateType;
        private String userName;

        protected Builder() {
        }

        public Builder setModificationTime(DateTime dateTime) {
            this.modificationTime = dateTime;
            return this;
        }

        public Builder setUpdateType(HistoryUpdateType historyUpdateType) {
            this.updateType = historyUpdateType;
            return this;
        }

        public Builder setUserName(String string) {
            this.userName = string;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.ModificationTime.getSpecification().equals(fieldSpecification)) {
                this.setModificationTime((DateTime)object);
                return this;
            }
            if (Fields.UpdateType.getSpecification().equals(fieldSpecification)) {
                this.setUpdateType((HistoryUpdateType)object);
                return this;
            }
            if (Fields.UserName.getSpecification().equals(fieldSpecification)) {
                this.setUserName((String)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public ModificationInfo build() {
            return new ModificationInfo(this.modificationTime, this.updateType, this.userName);
        }
    }

    public static enum Fields {
        ModificationTime("ModificationTime", DateTime.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=294")), -1),
        UpdateType("UpdateType", HistoryUpdateType.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=11234")), -1),
        UserName("UserName", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

