/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=14533")
public class KeyValuePair
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.KeyValuePair_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.KeyValuePair_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.KeyValuePair_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.KeyValuePair;
    public static final StructureSpecification SPECIFICATION;
    private QualifiedName key;
    private Object value;

    public KeyValuePair() {
    }

    public KeyValuePair(QualifiedName qualifiedName, Object object) {
        this.key = qualifiedName;
        this.value = object;
    }

    public QualifiedName getKey() {
        return this.key;
    }

    public void setKey(QualifiedName qualifiedName) {
        this.key = qualifiedName;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        this.value = object;
    }

    @Override
    public KeyValuePair clone() {
        KeyValuePair keyValuePair = (KeyValuePair)super.clone();
        keyValuePair.key = StructureUtils.clone(this.key);
        keyValuePair.value = StructureUtils.clone(this.value);
        return keyValuePair;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        KeyValuePair keyValuePair = (KeyValuePair)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getKey(), keyValuePair.getKey())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getValue(), keyValuePair.getValue());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getKey(), this.getValue());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.Key.getSpecification().equals(fieldSpecification)) {
            return this.getKey();
        }
        if (Fields.Value.getSpecification().equals(fieldSpecification)) {
            return this.getValue();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.Key.getSpecification().equals(fieldSpecification)) {
            this.setKey((QualifiedName)object);
            return;
        }
        if (Fields.Value.getSpecification().equals(fieldSpecification)) {
            this.setValue(object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = KeyValuePair.builder();
        builder.setKey(this.getKey());
        builder.setValue(this.getValue());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.Key.getSpecification());
        builder.addField(Fields.Value.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("KeyValuePair");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.KeyValuePairSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return KeyValuePair.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private QualifiedName key;
        private Object value;

        protected Builder() {
        }

        public Builder setKey(QualifiedName qualifiedName) {
            this.key = qualifiedName;
            return this;
        }

        public Builder setValue(Object object) {
            this.value = object;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.Key.getSpecification().equals(fieldSpecification)) {
                this.setKey((QualifiedName)object);
                return this;
            }
            if (Fields.Value.getSpecification().equals(fieldSpecification)) {
                this.setValue(object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public KeyValuePair build() {
            return new KeyValuePair(this.key, this.value);
        }
    }

    public static enum Fields {
        Key("Key", QualifiedName.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=20")), -1),
        Value("Value", Object.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=24")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

