/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.HistoryUpdateResponse;
import com.prosysopc.ua.stack.core.RequestHeader;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=698")
public class HistoryUpdateRequest
extends AbstractStructure
implements ServiceRequest<HistoryUpdateResponse> {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.HistoryUpdateRequest_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.HistoryUpdateRequest_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.HistoryUpdateRequest_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.HistoryUpdateRequest;
    public static final StructureSpecification SPECIFICATION;
    private RequestHeader requestHeader;
    private ExtensionObject[] historyUpdateDetails;

    public HistoryUpdateRequest() {
    }

    public HistoryUpdateRequest(RequestHeader requestHeader, ExtensionObject[] extensionObjectArray) {
        this.requestHeader = requestHeader;
        this.historyUpdateDetails = extensionObjectArray;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    @Override
    public void setRequestHeader(RequestHeader requestHeader) {
        this.requestHeader = requestHeader;
    }

    public ExtensionObject[] getHistoryUpdateDetails() {
        return this.historyUpdateDetails;
    }

    public void setHistoryUpdateDetails(ExtensionObject[] extensionObjectArray) {
        this.historyUpdateDetails = extensionObjectArray;
    }

    @Override
    public HistoryUpdateRequest clone() {
        HistoryUpdateRequest historyUpdateRequest = (HistoryUpdateRequest)super.clone();
        historyUpdateRequest.requestHeader = StructureUtils.clone(this.requestHeader);
        historyUpdateRequest.historyUpdateDetails = StructureUtils.clone(this.historyUpdateDetails);
        return historyUpdateRequest;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        HistoryUpdateRequest historyUpdateRequest = (HistoryUpdateRequest)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getRequestHeader(), historyUpdateRequest.getRequestHeader())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getHistoryUpdateDetails(), historyUpdateRequest.getHistoryUpdateDetails());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getRequestHeader(), this.getHistoryUpdateDetails());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
            return this.getRequestHeader();
        }
        if (Fields.HistoryUpdateDetails.getSpecification().equals(fieldSpecification)) {
            return this.getHistoryUpdateDetails();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
            this.setRequestHeader((RequestHeader)object);
            return;
        }
        if (Fields.HistoryUpdateDetails.getSpecification().equals(fieldSpecification)) {
            this.setHistoryUpdateDetails((ExtensionObject[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = HistoryUpdateRequest.builder();
        builder.setRequestHeader(this.getRequestHeader());
        builder.setHistoryUpdateDetails(this.getHistoryUpdateDetails());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.RequestHeader.getSpecification());
        builder.addField(Fields.HistoryUpdateDetails.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("HistoryUpdateRequest");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.HistoryUpdateRequestSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return HistoryUpdateRequest.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private RequestHeader requestHeader;
        private ExtensionObject[] historyUpdateDetails;

        protected Builder() {
        }

        public Builder setRequestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return this;
        }

        public Builder setHistoryUpdateDetails(ExtensionObject[] extensionObjectArray) {
            this.historyUpdateDetails = extensionObjectArray;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
                this.setRequestHeader((RequestHeader)object);
                return this;
            }
            if (Fields.HistoryUpdateDetails.getSpecification().equals(fieldSpecification)) {
                this.setHistoryUpdateDetails((ExtensionObject[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public HistoryUpdateRequest build() {
            return new HistoryUpdateRequest(this.requestHeader, this.historyUpdateDetails);
        }
    }

    public static enum Fields {
        RequestHeader("RequestHeader", RequestHeader.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=389")), -1),
        HistoryUpdateDetails("HistoryUpdateDetails", Structure[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=22")), 1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

