/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.HistoryReadResponse;
import com.prosysopc.ua.stack.core.HistoryReadValueId;
import com.prosysopc.ua.stack.core.RequestHeader;
import com.prosysopc.ua.stack.core.TimestampsToReturn;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=662")
public class HistoryReadRequest
extends AbstractStructure
implements ServiceRequest<HistoryReadResponse> {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.HistoryReadRequest_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.HistoryReadRequest_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.HistoryReadRequest_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.HistoryReadRequest;
    public static final StructureSpecification SPECIFICATION;
    private RequestHeader requestHeader;
    private ExtensionObject historyReadDetails;
    private TimestampsToReturn timestampsToReturn;
    private Boolean releaseContinuationPoints;
    private HistoryReadValueId[] nodesToRead;

    public HistoryReadRequest() {
    }

    public HistoryReadRequest(RequestHeader requestHeader, ExtensionObject extensionObject, TimestampsToReturn timestampsToReturn, Boolean bl, HistoryReadValueId[] historyReadValueIdArray) {
        this.requestHeader = requestHeader;
        this.historyReadDetails = extensionObject;
        this.timestampsToReturn = timestampsToReturn;
        this.releaseContinuationPoints = bl;
        this.nodesToRead = historyReadValueIdArray;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    @Override
    public void setRequestHeader(RequestHeader requestHeader) {
        this.requestHeader = requestHeader;
    }

    public ExtensionObject getHistoryReadDetails() {
        return this.historyReadDetails;
    }

    public void setHistoryReadDetails(ExtensionObject extensionObject) {
        this.historyReadDetails = extensionObject;
    }

    public TimestampsToReturn getTimestampsToReturn() {
        return this.timestampsToReturn;
    }

    public void setTimestampsToReturn(TimestampsToReturn timestampsToReturn) {
        this.timestampsToReturn = timestampsToReturn;
    }

    public Boolean getReleaseContinuationPoints() {
        return this.releaseContinuationPoints;
    }

    public void setReleaseContinuationPoints(Boolean bl) {
        this.releaseContinuationPoints = bl;
    }

    public HistoryReadValueId[] getNodesToRead() {
        return this.nodesToRead;
    }

    public void setNodesToRead(HistoryReadValueId[] historyReadValueIdArray) {
        this.nodesToRead = historyReadValueIdArray;
    }

    @Override
    public HistoryReadRequest clone() {
        HistoryReadRequest historyReadRequest = (HistoryReadRequest)super.clone();
        historyReadRequest.requestHeader = StructureUtils.clone(this.requestHeader);
        historyReadRequest.historyReadDetails = StructureUtils.clone(this.historyReadDetails);
        historyReadRequest.timestampsToReturn = StructureUtils.clone(this.timestampsToReturn);
        historyReadRequest.releaseContinuationPoints = StructureUtils.clone(this.releaseContinuationPoints);
        historyReadRequest.nodesToRead = StructureUtils.clone(this.nodesToRead);
        return historyReadRequest;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        HistoryReadRequest historyReadRequest = (HistoryReadRequest)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getRequestHeader(), historyReadRequest.getRequestHeader())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getHistoryReadDetails(), historyReadRequest.getHistoryReadDetails())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getTimestampsToReturn(), historyReadRequest.getTimestampsToReturn())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getReleaseContinuationPoints(), historyReadRequest.getReleaseContinuationPoints())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getNodesToRead(), historyReadRequest.getNodesToRead());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getRequestHeader(), this.getHistoryReadDetails(), this.getTimestampsToReturn(), this.getReleaseContinuationPoints(), this.getNodesToRead());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
            return this.getRequestHeader();
        }
        if (Fields.HistoryReadDetails.getSpecification().equals(fieldSpecification)) {
            return this.getHistoryReadDetails();
        }
        if (Fields.TimestampsToReturn.getSpecification().equals(fieldSpecification)) {
            return this.getTimestampsToReturn();
        }
        if (Fields.ReleaseContinuationPoints.getSpecification().equals(fieldSpecification)) {
            return this.getReleaseContinuationPoints();
        }
        if (Fields.NodesToRead.getSpecification().equals(fieldSpecification)) {
            return this.getNodesToRead();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
            this.setRequestHeader((RequestHeader)object);
            return;
        }
        if (Fields.HistoryReadDetails.getSpecification().equals(fieldSpecification)) {
            this.setHistoryReadDetails((ExtensionObject)object);
            return;
        }
        if (Fields.TimestampsToReturn.getSpecification().equals(fieldSpecification)) {
            this.setTimestampsToReturn((TimestampsToReturn)object);
            return;
        }
        if (Fields.ReleaseContinuationPoints.getSpecification().equals(fieldSpecification)) {
            this.setReleaseContinuationPoints((Boolean)object);
            return;
        }
        if (Fields.NodesToRead.getSpecification().equals(fieldSpecification)) {
            this.setNodesToRead((HistoryReadValueId[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = HistoryReadRequest.builder();
        builder.setRequestHeader(this.getRequestHeader());
        builder.setHistoryReadDetails(this.getHistoryReadDetails());
        builder.setTimestampsToReturn(this.getTimestampsToReturn());
        builder.setReleaseContinuationPoints(this.getReleaseContinuationPoints());
        builder.setNodesToRead(this.getNodesToRead());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.RequestHeader.getSpecification());
        builder.addField(Fields.HistoryReadDetails.getSpecification());
        builder.addField(Fields.TimestampsToReturn.getSpecification());
        builder.addField(Fields.ReleaseContinuationPoints.getSpecification());
        builder.addField(Fields.NodesToRead.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("HistoryReadRequest");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.HistoryReadRequestSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return HistoryReadRequest.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private RequestHeader requestHeader;
        private ExtensionObject historyReadDetails;
        private TimestampsToReturn timestampsToReturn;
        private Boolean releaseContinuationPoints;
        private HistoryReadValueId[] nodesToRead;

        protected Builder() {
        }

        public Builder setRequestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return this;
        }

        public Builder setHistoryReadDetails(ExtensionObject extensionObject) {
            this.historyReadDetails = extensionObject;
            return this;
        }

        public Builder setTimestampsToReturn(TimestampsToReturn timestampsToReturn) {
            this.timestampsToReturn = timestampsToReturn;
            return this;
        }

        public Builder setReleaseContinuationPoints(Boolean bl) {
            this.releaseContinuationPoints = bl;
            return this;
        }

        public Builder setNodesToRead(HistoryReadValueId[] historyReadValueIdArray) {
            this.nodesToRead = historyReadValueIdArray;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
                this.setRequestHeader((RequestHeader)object);
                return this;
            }
            if (Fields.HistoryReadDetails.getSpecification().equals(fieldSpecification)) {
                this.setHistoryReadDetails((ExtensionObject)object);
                return this;
            }
            if (Fields.TimestampsToReturn.getSpecification().equals(fieldSpecification)) {
                this.setTimestampsToReturn((TimestampsToReturn)object);
                return this;
            }
            if (Fields.ReleaseContinuationPoints.getSpecification().equals(fieldSpecification)) {
                this.setReleaseContinuationPoints((Boolean)object);
                return this;
            }
            if (Fields.NodesToRead.getSpecification().equals(fieldSpecification)) {
                this.setNodesToRead((HistoryReadValueId[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public HistoryReadRequest build() {
            return new HistoryReadRequest(this.requestHeader, this.historyReadDetails, this.timestampsToReturn, this.releaseContinuationPoints, this.nodesToRead);
        }
    }

    public static enum Fields {
        RequestHeader("RequestHeader", RequestHeader.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=389")), -1),
        HistoryReadDetails("HistoryReadDetails", Structure.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=22")), -1),
        TimestampsToReturn("TimestampsToReturn", TimestampsToReturn.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=625")), -1),
        ReleaseContinuationPoints("ReleaseContinuationPoints", Boolean.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=1")), -1),
        NodesToRead("NodesToRead", HistoryReadValueId[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=635")), 1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

