/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.ContentFilterResult;
import com.prosysopc.ua.stack.core.MonitoringFilterResult;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=734")
public class EventFilterResult
extends MonitoringFilterResult {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.EventFilterResult_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.EventFilterResult_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.EventFilterResult_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.EventFilterResult;
    public static final StructureSpecification SPECIFICATION;
    private StatusCode[] selectClauseResults;
    private DiagnosticInfo[] selectClauseDiagnosticInfos;
    private ContentFilterResult whereClauseResult;

    public EventFilterResult() {
    }

    public EventFilterResult(StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray, ContentFilterResult contentFilterResult) {
        this.selectClauseResults = statusCodeArray;
        this.selectClauseDiagnosticInfos = diagnosticInfoArray;
        this.whereClauseResult = contentFilterResult;
    }

    public StatusCode[] getSelectClauseResults() {
        return this.selectClauseResults;
    }

    public void setSelectClauseResults(StatusCode[] statusCodeArray) {
        this.selectClauseResults = statusCodeArray;
    }

    public DiagnosticInfo[] getSelectClauseDiagnosticInfos() {
        return this.selectClauseDiagnosticInfos;
    }

    public void setSelectClauseDiagnosticInfos(DiagnosticInfo[] diagnosticInfoArray) {
        this.selectClauseDiagnosticInfos = diagnosticInfoArray;
    }

    public ContentFilterResult getWhereClauseResult() {
        return this.whereClauseResult;
    }

    public void setWhereClauseResult(ContentFilterResult contentFilterResult) {
        this.whereClauseResult = contentFilterResult;
    }

    @Override
    public EventFilterResult clone() {
        EventFilterResult eventFilterResult = (EventFilterResult)super.clone();
        eventFilterResult.selectClauseResults = StructureUtils.clone(this.selectClauseResults);
        eventFilterResult.selectClauseDiagnosticInfos = StructureUtils.clone(this.selectClauseDiagnosticInfos);
        eventFilterResult.whereClauseResult = StructureUtils.clone(this.whereClauseResult);
        return eventFilterResult;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EventFilterResult eventFilterResult = (EventFilterResult)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getSelectClauseResults(), eventFilterResult.getSelectClauseResults())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getSelectClauseDiagnosticInfos(), eventFilterResult.getSelectClauseDiagnosticInfos())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getWhereClauseResult(), eventFilterResult.getWhereClauseResult());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getSelectClauseResults(), this.getSelectClauseDiagnosticInfos(), this.getWhereClauseResult());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.SelectClauseResults.getSpecification().equals(fieldSpecification)) {
            return this.getSelectClauseResults();
        }
        if (Fields.SelectClauseDiagnosticInfos.getSpecification().equals(fieldSpecification)) {
            return this.getSelectClauseDiagnosticInfos();
        }
        if (Fields.WhereClauseResult.getSpecification().equals(fieldSpecification)) {
            return this.getWhereClauseResult();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.SelectClauseResults.getSpecification().equals(fieldSpecification)) {
            this.setSelectClauseResults((StatusCode[])object);
            return;
        }
        if (Fields.SelectClauseDiagnosticInfos.getSpecification().equals(fieldSpecification)) {
            this.setSelectClauseDiagnosticInfos((DiagnosticInfo[])object);
            return;
        }
        if (Fields.WhereClauseResult.getSpecification().equals(fieldSpecification)) {
            this.setWhereClauseResult((ContentFilterResult)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = EventFilterResult.builder();
        builder.setSelectClauseResults(this.getSelectClauseResults());
        builder.setSelectClauseDiagnosticInfos(this.getSelectClauseDiagnosticInfos());
        builder.setWhereClauseResult(this.getWhereClauseResult());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.SelectClauseResults.getSpecification());
        builder.addField(Fields.SelectClauseDiagnosticInfos.getSpecification());
        builder.addField(Fields.WhereClauseResult.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("EventFilterResult");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.EventFilterResultSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return EventFilterResult.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends MonitoringFilterResult.Builder {
        private StatusCode[] selectClauseResults;
        private DiagnosticInfo[] selectClauseDiagnosticInfos;
        private ContentFilterResult whereClauseResult;

        protected Builder() {
        }

        public Builder setSelectClauseResults(StatusCode[] statusCodeArray) {
            this.selectClauseResults = statusCodeArray;
            return this;
        }

        public Builder setSelectClauseDiagnosticInfos(DiagnosticInfo[] diagnosticInfoArray) {
            this.selectClauseDiagnosticInfos = diagnosticInfoArray;
            return this;
        }

        public Builder setWhereClauseResult(ContentFilterResult contentFilterResult) {
            this.whereClauseResult = contentFilterResult;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.SelectClauseResults.getSpecification().equals(fieldSpecification)) {
                this.setSelectClauseResults((StatusCode[])object);
                return this;
            }
            if (Fields.SelectClauseDiagnosticInfos.getSpecification().equals(fieldSpecification)) {
                this.setSelectClauseDiagnosticInfos((DiagnosticInfo[])object);
                return this;
            }
            if (Fields.WhereClauseResult.getSpecification().equals(fieldSpecification)) {
                this.setWhereClauseResult((ContentFilterResult)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public EventFilterResult build() {
            return new EventFilterResult(this.selectClauseResults, this.selectClauseDiagnosticInfos, this.whereClauseResult);
        }
    }

    public static enum Fields {
        SelectClauseResults("SelectClauseResults", StatusCode[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=19")), 1),
        SelectClauseDiagnosticInfos("SelectClauseDiagnosticInfos", DiagnosticInfo[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=25")), 1),
        WhereClauseResult("WhereClauseResult", ContentFilterResult.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=607")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

