/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=917")
public class EventFieldList
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.EventFieldList_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.EventFieldList_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.EventFieldList_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.EventFieldList;
    public static final StructureSpecification SPECIFICATION;
    private UnsignedInteger clientHandle;
    private Object[] eventFields;

    public EventFieldList() {
    }

    public EventFieldList(UnsignedInteger unsignedInteger, Object[] objectArray) {
        this.clientHandle = unsignedInteger;
        this.eventFields = objectArray;
    }

    public UnsignedInteger getClientHandle() {
        return this.clientHandle;
    }

    public void setClientHandle(UnsignedInteger unsignedInteger) {
        this.clientHandle = unsignedInteger;
    }

    public Object[] getEventFields() {
        return this.eventFields;
    }

    public void setEventFields(Object[] objectArray) {
        this.eventFields = objectArray;
    }

    @Override
    public EventFieldList clone() {
        EventFieldList eventFieldList = (EventFieldList)super.clone();
        eventFieldList.clientHandle = StructureUtils.clone(this.clientHandle);
        eventFieldList.eventFields = StructureUtils.clone(this.eventFields);
        return eventFieldList;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EventFieldList eventFieldList = (EventFieldList)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getClientHandle(), eventFieldList.getClientHandle())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getEventFields(), eventFieldList.getEventFields());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getClientHandle(), this.getEventFields());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.ClientHandle.getSpecification().equals(fieldSpecification)) {
            return this.getClientHandle();
        }
        if (Fields.EventFields.getSpecification().equals(fieldSpecification)) {
            return this.getEventFields();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.ClientHandle.getSpecification().equals(fieldSpecification)) {
            this.setClientHandle((UnsignedInteger)object);
            return;
        }
        if (Fields.EventFields.getSpecification().equals(fieldSpecification)) {
            this.setEventFields((Object[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = EventFieldList.builder();
        builder.setClientHandle(this.getClientHandle());
        builder.setEventFields(this.getEventFields());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.ClientHandle.getSpecification());
        builder.addField(Fields.EventFields.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("EventFieldList");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.EventFieldListSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return EventFieldList.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private UnsignedInteger clientHandle;
        private Object[] eventFields;

        protected Builder() {
        }

        public Builder setClientHandle(UnsignedInteger unsignedInteger) {
            this.clientHandle = unsignedInteger;
            return this;
        }

        public Builder setEventFields(Object[] objectArray) {
            this.eventFields = objectArray;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.ClientHandle.getSpecification().equals(fieldSpecification)) {
                this.setClientHandle((UnsignedInteger)object);
                return this;
            }
            if (Fields.EventFields.getSpecification().equals(fieldSpecification)) {
                this.setEventFields((Object[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public EventFieldList build() {
            return new EventFieldList(this.clientHandle, this.eventFields);
        }
    }

    public static enum Fields {
        ClientHandle("ClientHandle", UnsignedInteger.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=288")), -1),
        EventFields("EventFields", Object[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=24")), 1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

