/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=7594")
public class EnumValueType
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.EnumValueType_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.EnumValueType_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.EnumValueType_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.EnumValueType;
    public static final StructureSpecification SPECIFICATION;
    private Long value;
    private LocalizedText displayName;
    private LocalizedText description;

    public EnumValueType() {
    }

    public EnumValueType(Long l2, LocalizedText localizedText, LocalizedText localizedText2) {
        this.value = l2;
        this.displayName = localizedText;
        this.description = localizedText2;
    }

    public Long getValue() {
        return this.value;
    }

    public void setValue(Long l2) {
        this.value = l2;
    }

    public LocalizedText getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(LocalizedText localizedText) {
        this.displayName = localizedText;
    }

    public LocalizedText getDescription() {
        return this.description;
    }

    public void setDescription(LocalizedText localizedText) {
        this.description = localizedText;
    }

    @Override
    public EnumValueType clone() {
        EnumValueType enumValueType = (EnumValueType)super.clone();
        enumValueType.value = StructureUtils.clone(this.value);
        enumValueType.displayName = StructureUtils.clone(this.displayName);
        enumValueType.description = StructureUtils.clone(this.description);
        return enumValueType;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EnumValueType enumValueType = (EnumValueType)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getValue(), enumValueType.getValue())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getDisplayName(), enumValueType.getDisplayName())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getDescription(), enumValueType.getDescription());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getValue(), this.getDisplayName(), this.getDescription());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.Value.getSpecification().equals(fieldSpecification)) {
            return this.getValue();
        }
        if (Fields.DisplayName.getSpecification().equals(fieldSpecification)) {
            return this.getDisplayName();
        }
        if (Fields.Description.getSpecification().equals(fieldSpecification)) {
            return this.getDescription();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.Value.getSpecification().equals(fieldSpecification)) {
            this.setValue((Long)object);
            return;
        }
        if (Fields.DisplayName.getSpecification().equals(fieldSpecification)) {
            this.setDisplayName((LocalizedText)object);
            return;
        }
        if (Fields.Description.getSpecification().equals(fieldSpecification)) {
            this.setDescription((LocalizedText)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = EnumValueType.builder();
        builder.setValue(this.getValue());
        builder.setDisplayName(this.getDisplayName());
        builder.setDescription(this.getDescription());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.Value.getSpecification());
        builder.addField(Fields.DisplayName.getSpecification());
        builder.addField(Fields.Description.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("EnumValueType");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.EnumValueTypeSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return EnumValueType.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private Long value;
        private LocalizedText displayName;
        private LocalizedText description;

        protected Builder() {
        }

        public Builder setValue(Long l2) {
            this.value = l2;
            return this;
        }

        public Builder setDisplayName(LocalizedText localizedText) {
            this.displayName = localizedText;
            return this;
        }

        public Builder setDescription(LocalizedText localizedText) {
            this.description = localizedText;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.Value.getSpecification().equals(fieldSpecification)) {
                this.setValue((Long)object);
                return this;
            }
            if (Fields.DisplayName.getSpecification().equals(fieldSpecification)) {
                this.setDisplayName((LocalizedText)object);
                return this;
            }
            if (Fields.Description.getSpecification().equals(fieldSpecification)) {
                this.setDescription((LocalizedText)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public EnumValueType build() {
            return new EnumValueType(this.value, this.displayName, this.description);
        }
    }

    public static enum Fields {
        Value("Value", Long.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=8")), -1),
        DisplayName("DisplayName", LocalizedText.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=21")), -1),
        Description("Description", LocalizedText.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=21")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

