/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.EnumValueType;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=102")
public class EnumField
extends EnumValueType {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.EnumField_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.EnumField_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.EnumField_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.EnumField;
    public static final StructureSpecification SPECIFICATION;
    private String name;

    public EnumField() {
    }

    public EnumField(String string) {
        this.name = string;
    }

    public EnumField(Long l2, LocalizedText localizedText, LocalizedText localizedText2, String string) {
        super(l2, localizedText, localizedText2);
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public EnumField clone() {
        EnumField enumField = (EnumField)super.clone();
        enumField.name = StructureUtils.clone(this.name);
        return enumField;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EnumField enumField = (EnumField)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getValue(), enumField.getValue())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getDisplayName(), enumField.getDisplayName())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getDescription(), enumField.getDescription())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getName(), enumField.getName());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getValue(), this.getDisplayName(), this.getDescription(), this.getName());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.Value.getSpecification().equals(fieldSpecification)) {
            return this.getValue();
        }
        if (Fields.DisplayName.getSpecification().equals(fieldSpecification)) {
            return this.getDisplayName();
        }
        if (Fields.Description.getSpecification().equals(fieldSpecification)) {
            return this.getDescription();
        }
        if (Fields.Name.getSpecification().equals(fieldSpecification)) {
            return this.getName();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.Value.getSpecification().equals(fieldSpecification)) {
            this.setValue((Long)object);
            return;
        }
        if (Fields.DisplayName.getSpecification().equals(fieldSpecification)) {
            this.setDisplayName((LocalizedText)object);
            return;
        }
        if (Fields.Description.getSpecification().equals(fieldSpecification)) {
            this.setDescription((LocalizedText)object);
            return;
        }
        if (Fields.Name.getSpecification().equals(fieldSpecification)) {
            this.setName((String)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = EnumField.builder();
        builder.setValue(this.getValue());
        builder.setDisplayName(this.getDisplayName());
        builder.setDescription(this.getDescription());
        builder.setName(this.getName());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.Value.getSpecification());
        builder.addField(Fields.DisplayName.getSpecification());
        builder.addField(Fields.Description.getSpecification());
        builder.addField(Fields.Name.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("EnumField");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.EnumFieldSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return EnumField.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends EnumValueType.Builder {
        private Long value;
        private LocalizedText displayName;
        private LocalizedText description;
        private String name;

        protected Builder() {
        }

        @Override
        public Builder setValue(Long l2) {
            this.value = l2;
            return this;
        }

        @Override
        public Builder setDisplayName(LocalizedText localizedText) {
            this.displayName = localizedText;
            return this;
        }

        @Override
        public Builder setDescription(LocalizedText localizedText) {
            this.description = localizedText;
            return this;
        }

        public Builder setName(String string) {
            this.name = string;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.Value.getSpecification().equals(fieldSpecification)) {
                this.setValue((Long)object);
                return this;
            }
            if (Fields.DisplayName.getSpecification().equals(fieldSpecification)) {
                this.setDisplayName((LocalizedText)object);
                return this;
            }
            if (Fields.Description.getSpecification().equals(fieldSpecification)) {
                this.setDescription((LocalizedText)object);
                return this;
            }
            if (Fields.Name.getSpecification().equals(fieldSpecification)) {
                this.setName((String)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public EnumField build() {
            return new EnumField(this.value, this.displayName, this.description, this.name);
        }
    }

    public static enum Fields {
        Value("Value", Long.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=8")), -1),
        DisplayName("DisplayName", LocalizedText.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=21")), -1),
        Description("Description", LocalizedText.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=21")), -1),
        Name("Name", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

