/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.core.ApplicationDescription;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.core.UserTokenPolicy;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=312")
public class EndpointDescription
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.EndpointDescription_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.EndpointDescription_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.EndpointDescription_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.EndpointDescription;
    public static final StructureSpecification SPECIFICATION;
    private String endpointUrl;
    private ApplicationDescription server;
    private ByteString serverCertificate;
    private MessageSecurityMode securityMode;
    private String securityPolicyUri;
    private UserTokenPolicy[] userIdentityTokens;
    private String transportProfileUri;
    private UnsignedByte securityLevel;

    public EndpointDescription() {
    }

    public EndpointDescription(String string, ApplicationDescription applicationDescription, ByteString byteString, MessageSecurityMode messageSecurityMode, String string2, UserTokenPolicy[] userTokenPolicyArray, String string3, UnsignedByte unsignedByte) {
        this.endpointUrl = string;
        this.server = applicationDescription;
        this.serverCertificate = byteString;
        this.securityMode = messageSecurityMode;
        this.securityPolicyUri = string2;
        this.userIdentityTokens = userTokenPolicyArray;
        this.transportProfileUri = string3;
        this.securityLevel = unsignedByte;
    }

    public String getEndpointUrl() {
        return this.endpointUrl;
    }

    public void setEndpointUrl(String string) {
        this.endpointUrl = string;
    }

    public ApplicationDescription getServer() {
        return this.server;
    }

    public void setServer(ApplicationDescription applicationDescription) {
        this.server = applicationDescription;
    }

    public ByteString getServerCertificate() {
        return this.serverCertificate;
    }

    public void setServerCertificate(ByteString byteString) {
        this.serverCertificate = byteString;
    }

    public MessageSecurityMode getSecurityMode() {
        return this.securityMode;
    }

    public void setSecurityMode(MessageSecurityMode messageSecurityMode) {
        this.securityMode = messageSecurityMode;
    }

    public String getSecurityPolicyUri() {
        return this.securityPolicyUri;
    }

    public void setSecurityPolicyUri(String string) {
        this.securityPolicyUri = string;
    }

    public UserTokenPolicy[] getUserIdentityTokens() {
        return this.userIdentityTokens;
    }

    public void setUserIdentityTokens(UserTokenPolicy[] userTokenPolicyArray) {
        this.userIdentityTokens = userTokenPolicyArray;
    }

    public String getTransportProfileUri() {
        return this.transportProfileUri;
    }

    public void setTransportProfileUri(String string) {
        this.transportProfileUri = string;
    }

    public UnsignedByte getSecurityLevel() {
        return this.securityLevel;
    }

    public void setSecurityLevel(UnsignedByte unsignedByte) {
        this.securityLevel = unsignedByte;
    }

    @Override
    public EndpointDescription clone() {
        EndpointDescription endpointDescription = (EndpointDescription)super.clone();
        endpointDescription.endpointUrl = StructureUtils.clone(this.endpointUrl);
        endpointDescription.server = StructureUtils.clone(this.server);
        endpointDescription.serverCertificate = StructureUtils.clone(this.serverCertificate);
        endpointDescription.securityMode = StructureUtils.clone(this.securityMode);
        endpointDescription.securityPolicyUri = StructureUtils.clone(this.securityPolicyUri);
        endpointDescription.userIdentityTokens = StructureUtils.clone(this.userIdentityTokens);
        endpointDescription.transportProfileUri = StructureUtils.clone(this.transportProfileUri);
        endpointDescription.securityLevel = StructureUtils.clone(this.securityLevel);
        return endpointDescription;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EndpointDescription endpointDescription = (EndpointDescription)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getEndpointUrl(), endpointDescription.getEndpointUrl())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getServer(), endpointDescription.getServer())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getServerCertificate(), endpointDescription.getServerCertificate())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getSecurityMode(), endpointDescription.getSecurityMode())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getSecurityPolicyUri(), endpointDescription.getSecurityPolicyUri())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getUserIdentityTokens(), endpointDescription.getUserIdentityTokens())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getTransportProfileUri(), endpointDescription.getTransportProfileUri())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getSecurityLevel(), endpointDescription.getSecurityLevel());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getEndpointUrl(), this.getServer(), this.getServerCertificate(), this.getSecurityMode(), this.getSecurityPolicyUri(), this.getUserIdentityTokens(), this.getTransportProfileUri(), this.getSecurityLevel());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.EndpointUrl.getSpecification().equals(fieldSpecification)) {
            return this.getEndpointUrl();
        }
        if (Fields.Server.getSpecification().equals(fieldSpecification)) {
            return this.getServer();
        }
        if (Fields.ServerCertificate.getSpecification().equals(fieldSpecification)) {
            return this.getServerCertificate();
        }
        if (Fields.SecurityMode.getSpecification().equals(fieldSpecification)) {
            return this.getSecurityMode();
        }
        if (Fields.SecurityPolicyUri.getSpecification().equals(fieldSpecification)) {
            return this.getSecurityPolicyUri();
        }
        if (Fields.UserIdentityTokens.getSpecification().equals(fieldSpecification)) {
            return this.getUserIdentityTokens();
        }
        if (Fields.TransportProfileUri.getSpecification().equals(fieldSpecification)) {
            return this.getTransportProfileUri();
        }
        if (Fields.SecurityLevel.getSpecification().equals(fieldSpecification)) {
            return this.getSecurityLevel();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.EndpointUrl.getSpecification().equals(fieldSpecification)) {
            this.setEndpointUrl((String)object);
            return;
        }
        if (Fields.Server.getSpecification().equals(fieldSpecification)) {
            this.setServer((ApplicationDescription)object);
            return;
        }
        if (Fields.ServerCertificate.getSpecification().equals(fieldSpecification)) {
            this.setServerCertificate((ByteString)object);
            return;
        }
        if (Fields.SecurityMode.getSpecification().equals(fieldSpecification)) {
            this.setSecurityMode((MessageSecurityMode)object);
            return;
        }
        if (Fields.SecurityPolicyUri.getSpecification().equals(fieldSpecification)) {
            this.setSecurityPolicyUri((String)object);
            return;
        }
        if (Fields.UserIdentityTokens.getSpecification().equals(fieldSpecification)) {
            this.setUserIdentityTokens((UserTokenPolicy[])object);
            return;
        }
        if (Fields.TransportProfileUri.getSpecification().equals(fieldSpecification)) {
            this.setTransportProfileUri((String)object);
            return;
        }
        if (Fields.SecurityLevel.getSpecification().equals(fieldSpecification)) {
            this.setSecurityLevel((UnsignedByte)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = EndpointDescription.builder();
        builder.setEndpointUrl(this.getEndpointUrl());
        builder.setServer(this.getServer());
        builder.setServerCertificate(this.getServerCertificate());
        builder.setSecurityMode(this.getSecurityMode());
        builder.setSecurityPolicyUri(this.getSecurityPolicyUri());
        builder.setUserIdentityTokens(this.getUserIdentityTokens());
        builder.setTransportProfileUri(this.getTransportProfileUri());
        builder.setSecurityLevel(this.getSecurityLevel());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.EndpointUrl.getSpecification());
        builder.addField(Fields.Server.getSpecification());
        builder.addField(Fields.ServerCertificate.getSpecification());
        builder.addField(Fields.SecurityMode.getSpecification());
        builder.addField(Fields.SecurityPolicyUri.getSpecification());
        builder.addField(Fields.UserIdentityTokens.getSpecification());
        builder.addField(Fields.TransportProfileUri.getSpecification());
        builder.addField(Fields.SecurityLevel.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("EndpointDescription");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.EndpointDescriptionSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return EndpointDescription.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private String endpointUrl;
        private ApplicationDescription server;
        private ByteString serverCertificate;
        private MessageSecurityMode securityMode;
        private String securityPolicyUri;
        private UserTokenPolicy[] userIdentityTokens;
        private String transportProfileUri;
        private UnsignedByte securityLevel;

        protected Builder() {
        }

        public Builder setEndpointUrl(String string) {
            this.endpointUrl = string;
            return this;
        }

        public Builder setServer(ApplicationDescription applicationDescription) {
            this.server = applicationDescription;
            return this;
        }

        public Builder setServerCertificate(ByteString byteString) {
            this.serverCertificate = byteString;
            return this;
        }

        public Builder setSecurityMode(MessageSecurityMode messageSecurityMode) {
            this.securityMode = messageSecurityMode;
            return this;
        }

        public Builder setSecurityPolicyUri(String string) {
            this.securityPolicyUri = string;
            return this;
        }

        public Builder setUserIdentityTokens(UserTokenPolicy[] userTokenPolicyArray) {
            this.userIdentityTokens = userTokenPolicyArray;
            return this;
        }

        public Builder setTransportProfileUri(String string) {
            this.transportProfileUri = string;
            return this;
        }

        public Builder setSecurityLevel(UnsignedByte unsignedByte) {
            this.securityLevel = unsignedByte;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.EndpointUrl.getSpecification().equals(fieldSpecification)) {
                this.setEndpointUrl((String)object);
                return this;
            }
            if (Fields.Server.getSpecification().equals(fieldSpecification)) {
                this.setServer((ApplicationDescription)object);
                return this;
            }
            if (Fields.ServerCertificate.getSpecification().equals(fieldSpecification)) {
                this.setServerCertificate((ByteString)object);
                return this;
            }
            if (Fields.SecurityMode.getSpecification().equals(fieldSpecification)) {
                this.setSecurityMode((MessageSecurityMode)object);
                return this;
            }
            if (Fields.SecurityPolicyUri.getSpecification().equals(fieldSpecification)) {
                this.setSecurityPolicyUri((String)object);
                return this;
            }
            if (Fields.UserIdentityTokens.getSpecification().equals(fieldSpecification)) {
                this.setUserIdentityTokens((UserTokenPolicy[])object);
                return this;
            }
            if (Fields.TransportProfileUri.getSpecification().equals(fieldSpecification)) {
                this.setTransportProfileUri((String)object);
                return this;
            }
            if (Fields.SecurityLevel.getSpecification().equals(fieldSpecification)) {
                this.setSecurityLevel((UnsignedByte)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public EndpointDescription build() {
            return new EndpointDescription(this.endpointUrl, this.server, this.serverCertificate, this.securityMode, this.securityPolicyUri, this.userIdentityTokens, this.transportProfileUri, this.securityLevel);
        }
    }

    public static enum Fields {
        EndpointUrl("EndpointUrl", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), -1),
        Server("Server", ApplicationDescription.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=308")), -1),
        ServerCertificate("ServerCertificate", ByteString.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=311")), -1),
        SecurityMode("SecurityMode", MessageSecurityMode.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=302")), -1),
        SecurityPolicyUri("SecurityPolicyUri", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), -1),
        UserIdentityTokens("UserIdentityTokens", UserTokenPolicy[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=304")), 1),
        TransportProfileUri("TransportProfileUri", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), -1),
        SecurityLevel("SecurityLevel", UnsignedByte.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=3")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

