/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=887")
public class EUInformation
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.EUInformation_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.EUInformation_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.EUInformation_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.EUInformation;
    public static final StructureSpecification SPECIFICATION;
    private String namespaceUri;
    private Integer unitId;
    private LocalizedText displayName;
    private LocalizedText description;

    public EUInformation() {
    }

    public EUInformation(String string, Integer n2, LocalizedText localizedText, LocalizedText localizedText2) {
        this.namespaceUri = string;
        this.unitId = n2;
        this.displayName = localizedText;
        this.description = localizedText2;
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public void setNamespaceUri(String string) {
        this.namespaceUri = string;
    }

    public Integer getUnitId() {
        return this.unitId;
    }

    public void setUnitId(Integer n2) {
        this.unitId = n2;
    }

    public LocalizedText getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(LocalizedText localizedText) {
        this.displayName = localizedText;
    }

    public LocalizedText getDescription() {
        return this.description;
    }

    public void setDescription(LocalizedText localizedText) {
        this.description = localizedText;
    }

    @Override
    public EUInformation clone() {
        EUInformation eUInformation = (EUInformation)super.clone();
        eUInformation.namespaceUri = StructureUtils.clone(this.namespaceUri);
        eUInformation.unitId = StructureUtils.clone(this.unitId);
        eUInformation.displayName = StructureUtils.clone(this.displayName);
        eUInformation.description = StructureUtils.clone(this.description);
        return eUInformation;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EUInformation eUInformation = (EUInformation)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getNamespaceUri(), eUInformation.getNamespaceUri())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getUnitId(), eUInformation.getUnitId())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getDisplayName(), eUInformation.getDisplayName())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getDescription(), eUInformation.getDescription());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getNamespaceUri(), this.getUnitId(), this.getDisplayName(), this.getDescription());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.NamespaceUri.getSpecification().equals(fieldSpecification)) {
            return this.getNamespaceUri();
        }
        if (Fields.UnitId.getSpecification().equals(fieldSpecification)) {
            return this.getUnitId();
        }
        if (Fields.DisplayName.getSpecification().equals(fieldSpecification)) {
            return this.getDisplayName();
        }
        if (Fields.Description.getSpecification().equals(fieldSpecification)) {
            return this.getDescription();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.NamespaceUri.getSpecification().equals(fieldSpecification)) {
            this.setNamespaceUri((String)object);
            return;
        }
        if (Fields.UnitId.getSpecification().equals(fieldSpecification)) {
            this.setUnitId((Integer)object);
            return;
        }
        if (Fields.DisplayName.getSpecification().equals(fieldSpecification)) {
            this.setDisplayName((LocalizedText)object);
            return;
        }
        if (Fields.Description.getSpecification().equals(fieldSpecification)) {
            this.setDescription((LocalizedText)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = EUInformation.builder();
        builder.setNamespaceUri(this.getNamespaceUri());
        builder.setUnitId(this.getUnitId());
        builder.setDisplayName(this.getDisplayName());
        builder.setDescription(this.getDescription());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.NamespaceUri.getSpecification());
        builder.addField(Fields.UnitId.getSpecification());
        builder.addField(Fields.DisplayName.getSpecification());
        builder.addField(Fields.Description.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("EUInformation");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.EUInformationSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return EUInformation.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private String namespaceUri;
        private Integer unitId;
        private LocalizedText displayName;
        private LocalizedText description;

        protected Builder() {
        }

        public Builder setNamespaceUri(String string) {
            this.namespaceUri = string;
            return this;
        }

        public Builder setUnitId(Integer n2) {
            this.unitId = n2;
            return this;
        }

        public Builder setDisplayName(LocalizedText localizedText) {
            this.displayName = localizedText;
            return this;
        }

        public Builder setDescription(LocalizedText localizedText) {
            this.description = localizedText;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.NamespaceUri.getSpecification().equals(fieldSpecification)) {
                this.setNamespaceUri((String)object);
                return this;
            }
            if (Fields.UnitId.getSpecification().equals(fieldSpecification)) {
                this.setUnitId((Integer)object);
                return this;
            }
            if (Fields.DisplayName.getSpecification().equals(fieldSpecification)) {
                this.setDisplayName((LocalizedText)object);
                return this;
            }
            if (Fields.Description.getSpecification().equals(fieldSpecification)) {
                this.setDescription((LocalizedText)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public EUInformation build() {
            return new EUInformation(this.namespaceUri, this.unitId, this.displayName, this.description);
        }
    }

    public static enum Fields {
        NamespaceUri("NamespaceUri", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), -1),
        UnitId("UnitId", Integer.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=6")), -1),
        DisplayName("DisplayName", LocalizedText.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=21")), -1),
        Description("Description", LocalizedText.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=21")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

