/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=12172")
public class DoubleComplexNumberType
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.DoubleComplexNumberType_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.DoubleComplexNumberType_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.DoubleComplexNumberType_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.DoubleComplexNumberType;
    public static final StructureSpecification SPECIFICATION;
    private Double real;
    private Double imaginary;

    public DoubleComplexNumberType() {
    }

    public DoubleComplexNumberType(Double d2, Double d3) {
        this.real = d2;
        this.imaginary = d3;
    }

    public Double getReal() {
        return this.real;
    }

    public void setReal(Double d2) {
        this.real = d2;
    }

    public Double getImaginary() {
        return this.imaginary;
    }

    public void setImaginary(Double d2) {
        this.imaginary = d2;
    }

    @Override
    public DoubleComplexNumberType clone() {
        DoubleComplexNumberType doubleComplexNumberType = (DoubleComplexNumberType)super.clone();
        doubleComplexNumberType.real = StructureUtils.clone(this.real);
        doubleComplexNumberType.imaginary = StructureUtils.clone(this.imaginary);
        return doubleComplexNumberType;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DoubleComplexNumberType doubleComplexNumberType = (DoubleComplexNumberType)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getReal(), doubleComplexNumberType.getReal())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getImaginary(), doubleComplexNumberType.getImaginary());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getReal(), this.getImaginary());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.Real.getSpecification().equals(fieldSpecification)) {
            return this.getReal();
        }
        if (Fields.Imaginary.getSpecification().equals(fieldSpecification)) {
            return this.getImaginary();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.Real.getSpecification().equals(fieldSpecification)) {
            this.setReal((Double)object);
            return;
        }
        if (Fields.Imaginary.getSpecification().equals(fieldSpecification)) {
            this.setImaginary((Double)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = DoubleComplexNumberType.builder();
        builder.setReal(this.getReal());
        builder.setImaginary(this.getImaginary());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.Real.getSpecification());
        builder.addField(Fields.Imaginary.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("DoubleComplexNumberType");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.DoubleComplexNumberTypeSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return DoubleComplexNumberType.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private Double real;
        private Double imaginary;

        protected Builder() {
        }

        public Builder setReal(Double d2) {
            this.real = d2;
            return this;
        }

        public Builder setImaginary(Double d2) {
            this.imaginary = d2;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.Real.getSpecification().equals(fieldSpecification)) {
                this.setReal((Double)object);
                return this;
            }
            if (Fields.Imaginary.getSpecification().equals(fieldSpecification)) {
                this.setImaginary((Double)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public DoubleComplexNumberType build() {
            return new DoubleComplexNumberType(this.real, this.imaginary);
        }
    }

    public static enum Fields {
        Real("Real", Double.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=11")), -1),
        Imaginary("Imaginary", Double.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=11")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

