/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.core.EnumDescription;
import com.prosysopc.ua.stack.core.SimpleTypeDescription;
import com.prosysopc.ua.stack.core.StructureDescription;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=15534")
public abstract class DataTypeSchemaHeader
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId ID = Ids.DataTypeSchemaHeader;
    public static final StructureSpecification SPECIFICATION;
    private String[] namespaces;
    private StructureDescription[] structureDataTypes;
    private EnumDescription[] enumDataTypes;
    private SimpleTypeDescription[] simpleDataTypes;

    public DataTypeSchemaHeader() {
    }

    public DataTypeSchemaHeader(String[] stringArray, StructureDescription[] structureDescriptionArray, EnumDescription[] enumDescriptionArray, SimpleTypeDescription[] simpleTypeDescriptionArray) {
        this.namespaces = stringArray;
        this.structureDataTypes = structureDescriptionArray;
        this.enumDataTypes = enumDescriptionArray;
        this.simpleDataTypes = simpleTypeDescriptionArray;
    }

    public String[] getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(String[] stringArray) {
        this.namespaces = stringArray;
    }

    public StructureDescription[] getStructureDataTypes() {
        return this.structureDataTypes;
    }

    public void setStructureDataTypes(StructureDescription[] structureDescriptionArray) {
        this.structureDataTypes = structureDescriptionArray;
    }

    public EnumDescription[] getEnumDataTypes() {
        return this.enumDataTypes;
    }

    public void setEnumDataTypes(EnumDescription[] enumDescriptionArray) {
        this.enumDataTypes = enumDescriptionArray;
    }

    public SimpleTypeDescription[] getSimpleDataTypes() {
        return this.simpleDataTypes;
    }

    public void setSimpleDataTypes(SimpleTypeDescription[] simpleTypeDescriptionArray) {
        this.simpleDataTypes = simpleTypeDescriptionArray;
    }

    @Override
    public DataTypeSchemaHeader clone() {
        DataTypeSchemaHeader dataTypeSchemaHeader = (DataTypeSchemaHeader)super.clone();
        dataTypeSchemaHeader.namespaces = StructureUtils.clone(this.namespaces);
        dataTypeSchemaHeader.structureDataTypes = StructureUtils.clone(this.structureDataTypes);
        dataTypeSchemaHeader.enumDataTypes = StructureUtils.clone(this.enumDataTypes);
        dataTypeSchemaHeader.simpleDataTypes = StructureUtils.clone(this.simpleDataTypes);
        return dataTypeSchemaHeader;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DataTypeSchemaHeader dataTypeSchemaHeader = (DataTypeSchemaHeader)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getNamespaces(), dataTypeSchemaHeader.getNamespaces())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getStructureDataTypes(), dataTypeSchemaHeader.getStructureDataTypes())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getEnumDataTypes(), dataTypeSchemaHeader.getEnumDataTypes())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getSimpleDataTypes(), dataTypeSchemaHeader.getSimpleDataTypes());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getNamespaces(), this.getStructureDataTypes(), this.getEnumDataTypes(), this.getSimpleDataTypes());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.Namespaces.getSpecification().equals(fieldSpecification)) {
            return this.getNamespaces();
        }
        if (Fields.StructureDataTypes.getSpecification().equals(fieldSpecification)) {
            return this.getStructureDataTypes();
        }
        if (Fields.EnumDataTypes.getSpecification().equals(fieldSpecification)) {
            return this.getEnumDataTypes();
        }
        if (Fields.SimpleDataTypes.getSpecification().equals(fieldSpecification)) {
            return this.getSimpleDataTypes();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.Namespaces.getSpecification().equals(fieldSpecification)) {
            this.setNamespaces((String[])object);
            return;
        }
        if (Fields.StructureDataTypes.getSpecification().equals(fieldSpecification)) {
            this.setStructureDataTypes((StructureDescription[])object);
            return;
        }
        if (Fields.EnumDataTypes.getSpecification().equals(fieldSpecification)) {
            this.setEnumDataTypes((EnumDescription[])object);
            return;
        }
        if (Fields.SimpleDataTypes.getSpecification().equals(fieldSpecification)) {
            this.setSimpleDataTypes((SimpleTypeDescription[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.Namespaces.getSpecification());
        builder.addField(Fields.StructureDataTypes.getSpecification());
        builder.addField(Fields.EnumDataTypes.getSpecification());
        builder.addField(Fields.SimpleDataTypes.getSpecification());
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("DataTypeSchemaHeader");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        SPECIFICATION = builder.build();
    }

    public static abstract class Builder
    extends AbstractStructure.Builder {
        private String[] namespaces;
        private StructureDescription[] structureDataTypes;
        private EnumDescription[] enumDataTypes;
        private SimpleTypeDescription[] simpleDataTypes;

        protected Builder() {
        }

        public Builder setNamespaces(String[] stringArray) {
            this.namespaces = stringArray;
            return this;
        }

        public Builder setStructureDataTypes(StructureDescription[] structureDescriptionArray) {
            this.structureDataTypes = structureDescriptionArray;
            return this;
        }

        public Builder setEnumDataTypes(EnumDescription[] enumDescriptionArray) {
            this.enumDataTypes = enumDescriptionArray;
            return this;
        }

        public Builder setSimpleDataTypes(SimpleTypeDescription[] simpleTypeDescriptionArray) {
            this.simpleDataTypes = simpleTypeDescriptionArray;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.Namespaces.getSpecification().equals(fieldSpecification)) {
                this.setNamespaces((String[])object);
                return this;
            }
            if (Fields.StructureDataTypes.getSpecification().equals(fieldSpecification)) {
                this.setStructureDataTypes((StructureDescription[])object);
                return this;
            }
            if (Fields.EnumDataTypes.getSpecification().equals(fieldSpecification)) {
                this.setEnumDataTypes((EnumDescription[])object);
                return this;
            }
            if (Fields.SimpleDataTypes.getSpecification().equals(fieldSpecification)) {
                this.setSimpleDataTypes((SimpleTypeDescription[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public abstract DataTypeSchemaHeader build();
    }

    public static enum Fields {
        Namespaces("Namespaces", String[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), 1),
        StructureDataTypes("StructureDataTypes", StructureDescription[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=15487")), 1),
        EnumDataTypes("EnumDataTypes", EnumDescription[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=15488")), 1),
        SimpleDataTypes("SimpleDataTypes", SimpleTypeDescription[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=15005")), 1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

