/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.MonitoredItemNotification;
import com.prosysopc.ua.stack.core.NotificationData;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=809")
public class DataChangeNotification
extends NotificationData {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.DataChangeNotification_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.DataChangeNotification_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.DataChangeNotification_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.DataChangeNotification;
    public static final StructureSpecification SPECIFICATION;
    private MonitoredItemNotification[] monitoredItems;
    private DiagnosticInfo[] diagnosticInfos;

    public DataChangeNotification() {
    }

    public DataChangeNotification(MonitoredItemNotification[] monitoredItemNotificationArray, DiagnosticInfo[] diagnosticInfoArray) {
        this.monitoredItems = monitoredItemNotificationArray;
        this.diagnosticInfos = diagnosticInfoArray;
    }

    public MonitoredItemNotification[] getMonitoredItems() {
        return this.monitoredItems;
    }

    public void setMonitoredItems(MonitoredItemNotification[] monitoredItemNotificationArray) {
        this.monitoredItems = monitoredItemNotificationArray;
    }

    public DiagnosticInfo[] getDiagnosticInfos() {
        return this.diagnosticInfos;
    }

    public void setDiagnosticInfos(DiagnosticInfo[] diagnosticInfoArray) {
        this.diagnosticInfos = diagnosticInfoArray;
    }

    @Override
    public DataChangeNotification clone() {
        DataChangeNotification dataChangeNotification = (DataChangeNotification)super.clone();
        dataChangeNotification.monitoredItems = StructureUtils.clone(this.monitoredItems);
        dataChangeNotification.diagnosticInfos = StructureUtils.clone(this.diagnosticInfos);
        return dataChangeNotification;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DataChangeNotification dataChangeNotification = (DataChangeNotification)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getMonitoredItems(), dataChangeNotification.getMonitoredItems())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getDiagnosticInfos(), dataChangeNotification.getDiagnosticInfos());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getMonitoredItems(), this.getDiagnosticInfos());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.MonitoredItems.getSpecification().equals(fieldSpecification)) {
            return this.getMonitoredItems();
        }
        if (Fields.DiagnosticInfos.getSpecification().equals(fieldSpecification)) {
            return this.getDiagnosticInfos();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.MonitoredItems.getSpecification().equals(fieldSpecification)) {
            this.setMonitoredItems((MonitoredItemNotification[])object);
            return;
        }
        if (Fields.DiagnosticInfos.getSpecification().equals(fieldSpecification)) {
            this.setDiagnosticInfos((DiagnosticInfo[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = DataChangeNotification.builder();
        builder.setMonitoredItems(this.getMonitoredItems());
        builder.setDiagnosticInfos(this.getDiagnosticInfos());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.MonitoredItems.getSpecification());
        builder.addField(Fields.DiagnosticInfos.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("DataChangeNotification");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.DataChangeNotificationSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return DataChangeNotification.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends NotificationData.Builder {
        private MonitoredItemNotification[] monitoredItems;
        private DiagnosticInfo[] diagnosticInfos;

        protected Builder() {
        }

        public Builder setMonitoredItems(MonitoredItemNotification[] monitoredItemNotificationArray) {
            this.monitoredItems = monitoredItemNotificationArray;
            return this;
        }

        public Builder setDiagnosticInfos(DiagnosticInfo[] diagnosticInfoArray) {
            this.diagnosticInfos = diagnosticInfoArray;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.MonitoredItems.getSpecification().equals(fieldSpecification)) {
                this.setMonitoredItems((MonitoredItemNotification[])object);
                return this;
            }
            if (Fields.DiagnosticInfos.getSpecification().equals(fieldSpecification)) {
                this.setDiagnosticInfos((DiagnosticInfo[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public DataChangeNotification build() {
            return new DataChangeNotification(this.monitoredItems, this.diagnosticInfos);
        }
    }

    public static enum Fields {
        MonitoredItems("MonitoredItems", MonitoredItemNotification[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=806")), 1),
        DiagnosticInfos("DiagnosticInfos", DiagnosticInfo[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=25")), 1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

