/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=23498")
public class CurrencyUnitType
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.CurrencyUnitType_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.CurrencyUnitType_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.CurrencyUnitType_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.CurrencyUnitType;
    public static final StructureSpecification SPECIFICATION;
    private Short numericCode;
    private Byte exponent;
    private String alphabeticCode;
    private LocalizedText currency;

    public CurrencyUnitType() {
    }

    public CurrencyUnitType(Short s2, Byte by, String string, LocalizedText localizedText) {
        this.numericCode = s2;
        this.exponent = by;
        this.alphabeticCode = string;
        this.currency = localizedText;
    }

    public Short getNumericCode() {
        return this.numericCode;
    }

    public void setNumericCode(Short s2) {
        this.numericCode = s2;
    }

    public Byte getExponent() {
        return this.exponent;
    }

    public void setExponent(Byte by) {
        this.exponent = by;
    }

    public String getAlphabeticCode() {
        return this.alphabeticCode;
    }

    public void setAlphabeticCode(String string) {
        this.alphabeticCode = string;
    }

    public LocalizedText getCurrency() {
        return this.currency;
    }

    public void setCurrency(LocalizedText localizedText) {
        this.currency = localizedText;
    }

    @Override
    public CurrencyUnitType clone() {
        CurrencyUnitType currencyUnitType = (CurrencyUnitType)super.clone();
        currencyUnitType.numericCode = StructureUtils.clone(this.numericCode);
        currencyUnitType.exponent = StructureUtils.clone(this.exponent);
        currencyUnitType.alphabeticCode = StructureUtils.clone(this.alphabeticCode);
        currencyUnitType.currency = StructureUtils.clone(this.currency);
        return currencyUnitType;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CurrencyUnitType currencyUnitType = (CurrencyUnitType)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getNumericCode(), currencyUnitType.getNumericCode())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getExponent(), currencyUnitType.getExponent())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getAlphabeticCode(), currencyUnitType.getAlphabeticCode())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getCurrency(), currencyUnitType.getCurrency());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getNumericCode(), this.getExponent(), this.getAlphabeticCode(), this.getCurrency());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.NumericCode.getSpecification().equals(fieldSpecification)) {
            return this.getNumericCode();
        }
        if (Fields.Exponent.getSpecification().equals(fieldSpecification)) {
            return this.getExponent();
        }
        if (Fields.AlphabeticCode.getSpecification().equals(fieldSpecification)) {
            return this.getAlphabeticCode();
        }
        if (Fields.Currency.getSpecification().equals(fieldSpecification)) {
            return this.getCurrency();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.NumericCode.getSpecification().equals(fieldSpecification)) {
            this.setNumericCode((Short)object);
            return;
        }
        if (Fields.Exponent.getSpecification().equals(fieldSpecification)) {
            this.setExponent((Byte)object);
            return;
        }
        if (Fields.AlphabeticCode.getSpecification().equals(fieldSpecification)) {
            this.setAlphabeticCode((String)object);
            return;
        }
        if (Fields.Currency.getSpecification().equals(fieldSpecification)) {
            this.setCurrency((LocalizedText)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = CurrencyUnitType.builder();
        builder.setNumericCode(this.getNumericCode());
        builder.setExponent(this.getExponent());
        builder.setAlphabeticCode(this.getAlphabeticCode());
        builder.setCurrency(this.getCurrency());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.NumericCode.getSpecification());
        builder.addField(Fields.Exponent.getSpecification());
        builder.addField(Fields.AlphabeticCode.getSpecification());
        builder.addField(Fields.Currency.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("CurrencyUnitType");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.CurrencyUnitTypeSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return CurrencyUnitType.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private Short numericCode;
        private Byte exponent;
        private String alphabeticCode;
        private LocalizedText currency;

        protected Builder() {
        }

        public Builder setNumericCode(Short s2) {
            this.numericCode = s2;
            return this;
        }

        public Builder setExponent(Byte by) {
            this.exponent = by;
            return this;
        }

        public Builder setAlphabeticCode(String string) {
            this.alphabeticCode = string;
            return this;
        }

        public Builder setCurrency(LocalizedText localizedText) {
            this.currency = localizedText;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.NumericCode.getSpecification().equals(fieldSpecification)) {
                this.setNumericCode((Short)object);
                return this;
            }
            if (Fields.Exponent.getSpecification().equals(fieldSpecification)) {
                this.setExponent((Byte)object);
                return this;
            }
            if (Fields.AlphabeticCode.getSpecification().equals(fieldSpecification)) {
                this.setAlphabeticCode((String)object);
                return this;
            }
            if (Fields.Currency.getSpecification().equals(fieldSpecification)) {
                this.setCurrency((LocalizedText)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public CurrencyUnitType build() {
            return new CurrencyUnitType(this.numericCode, this.exponent, this.alphabeticCode, this.currency);
        }
    }

    public static enum Fields {
        NumericCode("NumericCode", Short.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=4")), -1),
        Exponent("Exponent", Byte.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=2")), -1),
        AlphabeticCode("AlphabeticCode", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), -1),
        Currency("Currency", LocalizedText.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=21")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

