/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.CloseSessionResponse;
import com.prosysopc.ua.stack.core.RequestHeader;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=471")
public class CloseSessionRequest
extends AbstractStructure
implements ServiceRequest<CloseSessionResponse> {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.CloseSessionRequest_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.CloseSessionRequest_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.CloseSessionRequest_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.CloseSessionRequest;
    public static final StructureSpecification SPECIFICATION;
    private RequestHeader requestHeader;
    private Boolean deleteSubscriptions;

    public CloseSessionRequest() {
    }

    public CloseSessionRequest(RequestHeader requestHeader, Boolean bl) {
        this.requestHeader = requestHeader;
        this.deleteSubscriptions = bl;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    @Override
    public void setRequestHeader(RequestHeader requestHeader) {
        this.requestHeader = requestHeader;
    }

    public Boolean getDeleteSubscriptions() {
        return this.deleteSubscriptions;
    }

    public void setDeleteSubscriptions(Boolean bl) {
        this.deleteSubscriptions = bl;
    }

    @Override
    public CloseSessionRequest clone() {
        CloseSessionRequest closeSessionRequest = (CloseSessionRequest)super.clone();
        closeSessionRequest.requestHeader = StructureUtils.clone(this.requestHeader);
        closeSessionRequest.deleteSubscriptions = StructureUtils.clone(this.deleteSubscriptions);
        return closeSessionRequest;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CloseSessionRequest closeSessionRequest = (CloseSessionRequest)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getRequestHeader(), closeSessionRequest.getRequestHeader())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getDeleteSubscriptions(), closeSessionRequest.getDeleteSubscriptions());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getRequestHeader(), this.getDeleteSubscriptions());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
            return this.getRequestHeader();
        }
        if (Fields.DeleteSubscriptions.getSpecification().equals(fieldSpecification)) {
            return this.getDeleteSubscriptions();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
            this.setRequestHeader((RequestHeader)object);
            return;
        }
        if (Fields.DeleteSubscriptions.getSpecification().equals(fieldSpecification)) {
            this.setDeleteSubscriptions((Boolean)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = CloseSessionRequest.builder();
        builder.setRequestHeader(this.getRequestHeader());
        builder.setDeleteSubscriptions(this.getDeleteSubscriptions());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.RequestHeader.getSpecification());
        builder.addField(Fields.DeleteSubscriptions.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("CloseSessionRequest");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.CloseSessionRequestSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return CloseSessionRequest.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private RequestHeader requestHeader;
        private Boolean deleteSubscriptions;

        protected Builder() {
        }

        public Builder setRequestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return this;
        }

        public Builder setDeleteSubscriptions(Boolean bl) {
            this.deleteSubscriptions = bl;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
                this.setRequestHeader((RequestHeader)object);
                return this;
            }
            if (Fields.DeleteSubscriptions.getSpecification().equals(fieldSpecification)) {
                this.setDeleteSubscriptions((Boolean)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public CloseSessionRequest build() {
            return new CloseSessionRequest(this.requestHeader, this.deleteSubscriptions);
        }
    }

    public static enum Fields {
        RequestHeader("RequestHeader", RequestHeader.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=389")), -1),
        DeleteSubscriptions("DeleteSubscriptions", Boolean.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=1")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

