/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.CallMethodRequest;
import com.prosysopc.ua.stack.core.CallResponse;
import com.prosysopc.ua.stack.core.RequestHeader;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=710")
public class CallRequest
extends AbstractStructure
implements ServiceRequest<CallResponse> {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.CallRequest_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.CallRequest_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.CallRequest_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.CallRequest;
    public static final StructureSpecification SPECIFICATION;
    private RequestHeader requestHeader;
    private CallMethodRequest[] methodsToCall;

    public CallRequest() {
    }

    public CallRequest(RequestHeader requestHeader, CallMethodRequest[] callMethodRequestArray) {
        this.requestHeader = requestHeader;
        this.methodsToCall = callMethodRequestArray;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    @Override
    public void setRequestHeader(RequestHeader requestHeader) {
        this.requestHeader = requestHeader;
    }

    public CallMethodRequest[] getMethodsToCall() {
        return this.methodsToCall;
    }

    public void setMethodsToCall(CallMethodRequest[] callMethodRequestArray) {
        this.methodsToCall = callMethodRequestArray;
    }

    @Override
    public CallRequest clone() {
        CallRequest callRequest = (CallRequest)super.clone();
        callRequest.requestHeader = StructureUtils.clone(this.requestHeader);
        callRequest.methodsToCall = StructureUtils.clone(this.methodsToCall);
        return callRequest;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CallRequest callRequest = (CallRequest)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getRequestHeader(), callRequest.getRequestHeader())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getMethodsToCall(), callRequest.getMethodsToCall());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getRequestHeader(), this.getMethodsToCall());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
            return this.getRequestHeader();
        }
        if (Fields.MethodsToCall.getSpecification().equals(fieldSpecification)) {
            return this.getMethodsToCall();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
            this.setRequestHeader((RequestHeader)object);
            return;
        }
        if (Fields.MethodsToCall.getSpecification().equals(fieldSpecification)) {
            this.setMethodsToCall((CallMethodRequest[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = CallRequest.builder();
        builder.setRequestHeader(this.getRequestHeader());
        builder.setMethodsToCall(this.getMethodsToCall());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.RequestHeader.getSpecification());
        builder.addField(Fields.MethodsToCall.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("CallRequest");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.CallRequestSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return CallRequest.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private RequestHeader requestHeader;
        private CallMethodRequest[] methodsToCall;

        protected Builder() {
        }

        public Builder setRequestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return this;
        }

        public Builder setMethodsToCall(CallMethodRequest[] callMethodRequestArray) {
            this.methodsToCall = callMethodRequestArray;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
                this.setRequestHeader((RequestHeader)object);
                return this;
            }
            if (Fields.MethodsToCall.getSpecification().equals(fieldSpecification)) {
                this.setMethodsToCall((CallMethodRequest[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public CallRequest build() {
            return new CallRequest(this.requestHeader, this.methodsToCall);
        }
    }

    public static enum Fields {
        RequestHeader("RequestHeader", RequestHeader.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=389")), -1),
        MethodsToCall("MethodsToCall", CallMethodRequest[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=704")), 1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

