/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=707")
public class CallMethodResult
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.CallMethodResult_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.CallMethodResult_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.CallMethodResult_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.CallMethodResult;
    public static final StructureSpecification SPECIFICATION;
    private StatusCode statusCode;
    private StatusCode[] inputArgumentResults;
    private DiagnosticInfo[] inputArgumentDiagnosticInfos;
    private Object[] outputArguments;

    public CallMethodResult() {
    }

    public CallMethodResult(StatusCode statusCode, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray, Object[] objectArray) {
        this.statusCode = statusCode;
        this.inputArgumentResults = statusCodeArray;
        this.inputArgumentDiagnosticInfos = diagnosticInfoArray;
        this.outputArguments = objectArray;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(StatusCode statusCode) {
        this.statusCode = statusCode;
    }

    public StatusCode[] getInputArgumentResults() {
        return this.inputArgumentResults;
    }

    public void setInputArgumentResults(StatusCode[] statusCodeArray) {
        this.inputArgumentResults = statusCodeArray;
    }

    public DiagnosticInfo[] getInputArgumentDiagnosticInfos() {
        return this.inputArgumentDiagnosticInfos;
    }

    public void setInputArgumentDiagnosticInfos(DiagnosticInfo[] diagnosticInfoArray) {
        this.inputArgumentDiagnosticInfos = diagnosticInfoArray;
    }

    public Object[] getOutputArguments() {
        return this.outputArguments;
    }

    public void setOutputArguments(Object[] objectArray) {
        this.outputArguments = objectArray;
    }

    @Override
    public CallMethodResult clone() {
        CallMethodResult callMethodResult = (CallMethodResult)super.clone();
        callMethodResult.statusCode = StructureUtils.clone(this.statusCode);
        callMethodResult.inputArgumentResults = StructureUtils.clone(this.inputArgumentResults);
        callMethodResult.inputArgumentDiagnosticInfos = StructureUtils.clone(this.inputArgumentDiagnosticInfos);
        callMethodResult.outputArguments = StructureUtils.clone(this.outputArguments);
        return callMethodResult;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CallMethodResult callMethodResult = (CallMethodResult)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getStatusCode(), callMethodResult.getStatusCode())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getInputArgumentResults(), callMethodResult.getInputArgumentResults())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getInputArgumentDiagnosticInfos(), callMethodResult.getInputArgumentDiagnosticInfos())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getOutputArguments(), callMethodResult.getOutputArguments());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getStatusCode(), this.getInputArgumentResults(), this.getInputArgumentDiagnosticInfos(), this.getOutputArguments());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.StatusCode.getSpecification().equals(fieldSpecification)) {
            return this.getStatusCode();
        }
        if (Fields.InputArgumentResults.getSpecification().equals(fieldSpecification)) {
            return this.getInputArgumentResults();
        }
        if (Fields.InputArgumentDiagnosticInfos.getSpecification().equals(fieldSpecification)) {
            return this.getInputArgumentDiagnosticInfos();
        }
        if (Fields.OutputArguments.getSpecification().equals(fieldSpecification)) {
            return this.getOutputArguments();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.StatusCode.getSpecification().equals(fieldSpecification)) {
            this.setStatusCode((StatusCode)object);
            return;
        }
        if (Fields.InputArgumentResults.getSpecification().equals(fieldSpecification)) {
            this.setInputArgumentResults((StatusCode[])object);
            return;
        }
        if (Fields.InputArgumentDiagnosticInfos.getSpecification().equals(fieldSpecification)) {
            this.setInputArgumentDiagnosticInfos((DiagnosticInfo[])object);
            return;
        }
        if (Fields.OutputArguments.getSpecification().equals(fieldSpecification)) {
            this.setOutputArguments((Object[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = CallMethodResult.builder();
        builder.setStatusCode(this.getStatusCode());
        builder.setInputArgumentResults(this.getInputArgumentResults());
        builder.setInputArgumentDiagnosticInfos(this.getInputArgumentDiagnosticInfos());
        builder.setOutputArguments(this.getOutputArguments());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.StatusCode.getSpecification());
        builder.addField(Fields.InputArgumentResults.getSpecification());
        builder.addField(Fields.InputArgumentDiagnosticInfos.getSpecification());
        builder.addField(Fields.OutputArguments.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("CallMethodResult");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.CallMethodResultSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return CallMethodResult.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private StatusCode statusCode;
        private StatusCode[] inputArgumentResults;
        private DiagnosticInfo[] inputArgumentDiagnosticInfos;
        private Object[] outputArguments;

        protected Builder() {
        }

        public Builder setStatusCode(StatusCode statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder setInputArgumentResults(StatusCode[] statusCodeArray) {
            this.inputArgumentResults = statusCodeArray;
            return this;
        }

        public Builder setInputArgumentDiagnosticInfos(DiagnosticInfo[] diagnosticInfoArray) {
            this.inputArgumentDiagnosticInfos = diagnosticInfoArray;
            return this;
        }

        public Builder setOutputArguments(Object[] objectArray) {
            this.outputArguments = objectArray;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.StatusCode.getSpecification().equals(fieldSpecification)) {
                this.setStatusCode((StatusCode)object);
                return this;
            }
            if (Fields.InputArgumentResults.getSpecification().equals(fieldSpecification)) {
                this.setInputArgumentResults((StatusCode[])object);
                return this;
            }
            if (Fields.InputArgumentDiagnosticInfos.getSpecification().equals(fieldSpecification)) {
                this.setInputArgumentDiagnosticInfos((DiagnosticInfo[])object);
                return this;
            }
            if (Fields.OutputArguments.getSpecification().equals(fieldSpecification)) {
                this.setOutputArguments((Object[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public CallMethodResult build() {
            return new CallMethodResult(this.statusCode, this.inputArgumentResults, this.inputArgumentDiagnosticInfos, this.outputArguments);
        }
    }

    public static enum Fields {
        StatusCode("StatusCode", StatusCode.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=19")), -1),
        InputArgumentResults("InputArgumentResults", StatusCode[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=19")), 1),
        InputArgumentDiagnosticInfos("InputArgumentDiagnosticInfos", DiagnosticInfo[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=25")), 1),
        OutputArguments("OutputArguments", Object[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=24")), 1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

