/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=704")
public class CallMethodRequest
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.CallMethodRequest_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.CallMethodRequest_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.CallMethodRequest_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.CallMethodRequest;
    public static final StructureSpecification SPECIFICATION;
    private NodeId objectId;
    private NodeId methodId;
    private Object[] inputArguments;

    public CallMethodRequest() {
    }

    public CallMethodRequest(NodeId nodeId, NodeId nodeId2, Object[] objectArray) {
        this.objectId = nodeId;
        this.methodId = nodeId2;
        this.inputArguments = objectArray;
    }

    public NodeId getObjectId() {
        return this.objectId;
    }

    public void setObjectId(NodeId nodeId) {
        this.objectId = nodeId;
    }

    public NodeId getMethodId() {
        return this.methodId;
    }

    public void setMethodId(NodeId nodeId) {
        this.methodId = nodeId;
    }

    public Object[] getInputArguments() {
        return this.inputArguments;
    }

    public void setInputArguments(Object[] objectArray) {
        this.inputArguments = objectArray;
    }

    @Override
    public CallMethodRequest clone() {
        CallMethodRequest callMethodRequest = (CallMethodRequest)super.clone();
        callMethodRequest.objectId = StructureUtils.clone(this.objectId);
        callMethodRequest.methodId = StructureUtils.clone(this.methodId);
        callMethodRequest.inputArguments = StructureUtils.clone(this.inputArguments);
        return callMethodRequest;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CallMethodRequest callMethodRequest = (CallMethodRequest)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getObjectId(), callMethodRequest.getObjectId())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getMethodId(), callMethodRequest.getMethodId())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getInputArguments(), callMethodRequest.getInputArguments());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getObjectId(), this.getMethodId(), this.getInputArguments());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.ObjectId.getSpecification().equals(fieldSpecification)) {
            return this.getObjectId();
        }
        if (Fields.MethodId.getSpecification().equals(fieldSpecification)) {
            return this.getMethodId();
        }
        if (Fields.InputArguments.getSpecification().equals(fieldSpecification)) {
            return this.getInputArguments();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.ObjectId.getSpecification().equals(fieldSpecification)) {
            this.setObjectId((NodeId)object);
            return;
        }
        if (Fields.MethodId.getSpecification().equals(fieldSpecification)) {
            this.setMethodId((NodeId)object);
            return;
        }
        if (Fields.InputArguments.getSpecification().equals(fieldSpecification)) {
            this.setInputArguments((Object[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = CallMethodRequest.builder();
        builder.setObjectId(this.getObjectId());
        builder.setMethodId(this.getMethodId());
        builder.setInputArguments(this.getInputArguments());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.ObjectId.getSpecification());
        builder.addField(Fields.MethodId.getSpecification());
        builder.addField(Fields.InputArguments.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("CallMethodRequest");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.CallMethodRequestSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return CallMethodRequest.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private NodeId objectId;
        private NodeId methodId;
        private Object[] inputArguments;

        protected Builder() {
        }

        public Builder setObjectId(NodeId nodeId) {
            this.objectId = nodeId;
            return this;
        }

        public Builder setMethodId(NodeId nodeId) {
            this.methodId = nodeId;
            return this;
        }

        public Builder setInputArguments(Object[] objectArray) {
            this.inputArguments = objectArray;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.ObjectId.getSpecification().equals(fieldSpecification)) {
                this.setObjectId((NodeId)object);
                return this;
            }
            if (Fields.MethodId.getSpecification().equals(fieldSpecification)) {
                this.setMethodId((NodeId)object);
                return this;
            }
            if (Fields.InputArguments.getSpecification().equals(fieldSpecification)) {
                this.setInputArguments((Object[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public CallMethodRequest build() {
            return new CallMethodRequest(this.objectId, this.methodId, this.inputArguments);
        }
    }

    public static enum Fields {
        ObjectId("ObjectId", NodeId.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=17")), -1),
        MethodId("MethodId", NodeId.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=17")), -1),
        InputArguments("InputArguments", Object[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=24")), 1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

