/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=338")
public class BuildInfo
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.BuildInfo_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.BuildInfo_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.BuildInfo_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.BuildInfo;
    public static final StructureSpecification SPECIFICATION;
    private String productUri;
    private String manufacturerName;
    private String productName;
    private String softwareVersion;
    private String buildNumber;
    private DateTime buildDate;

    public BuildInfo() {
    }

    public BuildInfo(String string, String string2, String string3, String string4, String string5, DateTime dateTime) {
        this.productUri = string;
        this.manufacturerName = string2;
        this.productName = string3;
        this.softwareVersion = string4;
        this.buildNumber = string5;
        this.buildDate = dateTime;
    }

    public String getProductUri() {
        return this.productUri;
    }

    public void setProductUri(String string) {
        this.productUri = string;
    }

    public String getManufacturerName() {
        return this.manufacturerName;
    }

    public void setManufacturerName(String string) {
        this.manufacturerName = string;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String string) {
        this.productName = string;
    }

    public String getSoftwareVersion() {
        return this.softwareVersion;
    }

    public void setSoftwareVersion(String string) {
        this.softwareVersion = string;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public void setBuildNumber(String string) {
        this.buildNumber = string;
    }

    public DateTime getBuildDate() {
        return this.buildDate;
    }

    public void setBuildDate(DateTime dateTime) {
        this.buildDate = dateTime;
    }

    @Override
    public BuildInfo clone() {
        BuildInfo buildInfo = (BuildInfo)super.clone();
        buildInfo.productUri = StructureUtils.clone(this.productUri);
        buildInfo.manufacturerName = StructureUtils.clone(this.manufacturerName);
        buildInfo.productName = StructureUtils.clone(this.productName);
        buildInfo.softwareVersion = StructureUtils.clone(this.softwareVersion);
        buildInfo.buildNumber = StructureUtils.clone(this.buildNumber);
        buildInfo.buildDate = StructureUtils.clone(this.buildDate);
        return buildInfo;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BuildInfo buildInfo = (BuildInfo)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getProductUri(), buildInfo.getProductUri())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getManufacturerName(), buildInfo.getManufacturerName())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getProductName(), buildInfo.getProductName())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getSoftwareVersion(), buildInfo.getSoftwareVersion())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getBuildNumber(), buildInfo.getBuildNumber())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getBuildDate(), buildInfo.getBuildDate());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getProductUri(), this.getManufacturerName(), this.getProductName(), this.getSoftwareVersion(), this.getBuildNumber(), this.getBuildDate());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.ProductUri.getSpecification().equals(fieldSpecification)) {
            return this.getProductUri();
        }
        if (Fields.ManufacturerName.getSpecification().equals(fieldSpecification)) {
            return this.getManufacturerName();
        }
        if (Fields.ProductName.getSpecification().equals(fieldSpecification)) {
            return this.getProductName();
        }
        if (Fields.SoftwareVersion.getSpecification().equals(fieldSpecification)) {
            return this.getSoftwareVersion();
        }
        if (Fields.BuildNumber.getSpecification().equals(fieldSpecification)) {
            return this.getBuildNumber();
        }
        if (Fields.BuildDate.getSpecification().equals(fieldSpecification)) {
            return this.getBuildDate();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.ProductUri.getSpecification().equals(fieldSpecification)) {
            this.setProductUri((String)object);
            return;
        }
        if (Fields.ManufacturerName.getSpecification().equals(fieldSpecification)) {
            this.setManufacturerName((String)object);
            return;
        }
        if (Fields.ProductName.getSpecification().equals(fieldSpecification)) {
            this.setProductName((String)object);
            return;
        }
        if (Fields.SoftwareVersion.getSpecification().equals(fieldSpecification)) {
            this.setSoftwareVersion((String)object);
            return;
        }
        if (Fields.BuildNumber.getSpecification().equals(fieldSpecification)) {
            this.setBuildNumber((String)object);
            return;
        }
        if (Fields.BuildDate.getSpecification().equals(fieldSpecification)) {
            this.setBuildDate((DateTime)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = BuildInfo.builder();
        builder.setProductUri(this.getProductUri());
        builder.setManufacturerName(this.getManufacturerName());
        builder.setProductName(this.getProductName());
        builder.setSoftwareVersion(this.getSoftwareVersion());
        builder.setBuildNumber(this.getBuildNumber());
        builder.setBuildDate(this.getBuildDate());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.ProductUri.getSpecification());
        builder.addField(Fields.ManufacturerName.getSpecification());
        builder.addField(Fields.ProductName.getSpecification());
        builder.addField(Fields.SoftwareVersion.getSpecification());
        builder.addField(Fields.BuildNumber.getSpecification());
        builder.addField(Fields.BuildDate.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("BuildInfo");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.BuildInfoSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return BuildInfo.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private String productUri;
        private String manufacturerName;
        private String productName;
        private String softwareVersion;
        private String buildNumber;
        private DateTime buildDate;

        protected Builder() {
        }

        public Builder setProductUri(String string) {
            this.productUri = string;
            return this;
        }

        public Builder setManufacturerName(String string) {
            this.manufacturerName = string;
            return this;
        }

        public Builder setProductName(String string) {
            this.productName = string;
            return this;
        }

        public Builder setSoftwareVersion(String string) {
            this.softwareVersion = string;
            return this;
        }

        public Builder setBuildNumber(String string) {
            this.buildNumber = string;
            return this;
        }

        public Builder setBuildDate(DateTime dateTime) {
            this.buildDate = dateTime;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.ProductUri.getSpecification().equals(fieldSpecification)) {
                this.setProductUri((String)object);
                return this;
            }
            if (Fields.ManufacturerName.getSpecification().equals(fieldSpecification)) {
                this.setManufacturerName((String)object);
                return this;
            }
            if (Fields.ProductName.getSpecification().equals(fieldSpecification)) {
                this.setProductName((String)object);
                return this;
            }
            if (Fields.SoftwareVersion.getSpecification().equals(fieldSpecification)) {
                this.setSoftwareVersion((String)object);
                return this;
            }
            if (Fields.BuildNumber.getSpecification().equals(fieldSpecification)) {
                this.setBuildNumber((String)object);
                return this;
            }
            if (Fields.BuildDate.getSpecification().equals(fieldSpecification)) {
                this.setBuildDate((DateTime)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public BuildInfo build() {
            return new BuildInfo(this.productUri, this.manufacturerName, this.productName, this.softwareVersion, this.buildNumber, this.buildDate);
        }
    }

    public static enum Fields {
        ProductUri("ProductUri", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), -1),
        ManufacturerName("ManufacturerName", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), -1),
        ProductName("ProductName", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), -1),
        SoftwareVersion("SoftwareVersion", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), -1),
        BuildNumber("BuildNumber", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), -1),
        BuildDate("BuildDate", DateTime.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=294")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

