/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=546")
public class BrowsePathTarget
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.BrowsePathTarget_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.BrowsePathTarget_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.BrowsePathTarget_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.BrowsePathTarget;
    public static final StructureSpecification SPECIFICATION;
    private ExpandedNodeId targetId;
    private UnsignedInteger remainingPathIndex;

    public BrowsePathTarget() {
    }

    public BrowsePathTarget(ExpandedNodeId expandedNodeId, UnsignedInteger unsignedInteger) {
        this.targetId = expandedNodeId;
        this.remainingPathIndex = unsignedInteger;
    }

    public ExpandedNodeId getTargetId() {
        return this.targetId;
    }

    public void setTargetId(ExpandedNodeId expandedNodeId) {
        this.targetId = expandedNodeId;
    }

    public UnsignedInteger getRemainingPathIndex() {
        return this.remainingPathIndex;
    }

    public void setRemainingPathIndex(UnsignedInteger unsignedInteger) {
        this.remainingPathIndex = unsignedInteger;
    }

    @Override
    public BrowsePathTarget clone() {
        BrowsePathTarget browsePathTarget = (BrowsePathTarget)super.clone();
        browsePathTarget.targetId = StructureUtils.clone(this.targetId);
        browsePathTarget.remainingPathIndex = StructureUtils.clone(this.remainingPathIndex);
        return browsePathTarget;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BrowsePathTarget browsePathTarget = (BrowsePathTarget)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getTargetId(), browsePathTarget.getTargetId())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getRemainingPathIndex(), browsePathTarget.getRemainingPathIndex());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getTargetId(), this.getRemainingPathIndex());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.TargetId.getSpecification().equals(fieldSpecification)) {
            return this.getTargetId();
        }
        if (Fields.RemainingPathIndex.getSpecification().equals(fieldSpecification)) {
            return this.getRemainingPathIndex();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.TargetId.getSpecification().equals(fieldSpecification)) {
            this.setTargetId((ExpandedNodeId)object);
            return;
        }
        if (Fields.RemainingPathIndex.getSpecification().equals(fieldSpecification)) {
            this.setRemainingPathIndex((UnsignedInteger)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = BrowsePathTarget.builder();
        builder.setTargetId(this.getTargetId());
        builder.setRemainingPathIndex(this.getRemainingPathIndex());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.TargetId.getSpecification());
        builder.addField(Fields.RemainingPathIndex.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("BrowsePathTarget");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.BrowsePathTargetSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return BrowsePathTarget.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private ExpandedNodeId targetId;
        private UnsignedInteger remainingPathIndex;

        protected Builder() {
        }

        public Builder setTargetId(ExpandedNodeId expandedNodeId) {
            this.targetId = expandedNodeId;
            return this;
        }

        public Builder setRemainingPathIndex(UnsignedInteger unsignedInteger) {
            this.remainingPathIndex = unsignedInteger;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.TargetId.getSpecification().equals(fieldSpecification)) {
                this.setTargetId((ExpandedNodeId)object);
                return this;
            }
            if (Fields.RemainingPathIndex.getSpecification().equals(fieldSpecification)) {
                this.setRemainingPathIndex((UnsignedInteger)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public BrowsePathTarget build() {
            return new BrowsePathTarget(this.targetId, this.remainingPathIndex);
        }
    }

    public static enum Fields {
        TargetId("TargetId", ExpandedNodeId.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=18")), -1),
        RemainingPathIndex("RemainingPathIndex", UnsignedInteger.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=17588")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

