/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.BrowseNextResponse;
import com.prosysopc.ua.stack.core.RequestHeader;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=531")
public class BrowseNextRequest
extends AbstractStructure
implements ServiceRequest<BrowseNextResponse> {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.BrowseNextRequest_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.BrowseNextRequest_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.BrowseNextRequest_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.BrowseNextRequest;
    public static final StructureSpecification SPECIFICATION;
    private RequestHeader requestHeader;
    private Boolean releaseContinuationPoints;
    private ByteString[] continuationPoints;

    public BrowseNextRequest() {
    }

    public BrowseNextRequest(RequestHeader requestHeader, Boolean bl, ByteString[] byteStringArray) {
        this.requestHeader = requestHeader;
        this.releaseContinuationPoints = bl;
        this.continuationPoints = byteStringArray;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    @Override
    public void setRequestHeader(RequestHeader requestHeader) {
        this.requestHeader = requestHeader;
    }

    public Boolean getReleaseContinuationPoints() {
        return this.releaseContinuationPoints;
    }

    public void setReleaseContinuationPoints(Boolean bl) {
        this.releaseContinuationPoints = bl;
    }

    public ByteString[] getContinuationPoints() {
        return this.continuationPoints;
    }

    public void setContinuationPoints(ByteString[] byteStringArray) {
        this.continuationPoints = byteStringArray;
    }

    @Override
    public BrowseNextRequest clone() {
        BrowseNextRequest browseNextRequest = (BrowseNextRequest)super.clone();
        browseNextRequest.requestHeader = StructureUtils.clone(this.requestHeader);
        browseNextRequest.releaseContinuationPoints = StructureUtils.clone(this.releaseContinuationPoints);
        browseNextRequest.continuationPoints = StructureUtils.clone(this.continuationPoints);
        return browseNextRequest;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BrowseNextRequest browseNextRequest = (BrowseNextRequest)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getRequestHeader(), browseNextRequest.getRequestHeader())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getReleaseContinuationPoints(), browseNextRequest.getReleaseContinuationPoints())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getContinuationPoints(), browseNextRequest.getContinuationPoints());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getRequestHeader(), this.getReleaseContinuationPoints(), this.getContinuationPoints());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
            return this.getRequestHeader();
        }
        if (Fields.ReleaseContinuationPoints.getSpecification().equals(fieldSpecification)) {
            return this.getReleaseContinuationPoints();
        }
        if (Fields.ContinuationPoints.getSpecification().equals(fieldSpecification)) {
            return this.getContinuationPoints();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
            this.setRequestHeader((RequestHeader)object);
            return;
        }
        if (Fields.ReleaseContinuationPoints.getSpecification().equals(fieldSpecification)) {
            this.setReleaseContinuationPoints((Boolean)object);
            return;
        }
        if (Fields.ContinuationPoints.getSpecification().equals(fieldSpecification)) {
            this.setContinuationPoints((ByteString[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = BrowseNextRequest.builder();
        builder.setRequestHeader(this.getRequestHeader());
        builder.setReleaseContinuationPoints(this.getReleaseContinuationPoints());
        builder.setContinuationPoints(this.getContinuationPoints());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.RequestHeader.getSpecification());
        builder.addField(Fields.ReleaseContinuationPoints.getSpecification());
        builder.addField(Fields.ContinuationPoints.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("BrowseNextRequest");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.BrowseNextRequestSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return BrowseNextRequest.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private RequestHeader requestHeader;
        private Boolean releaseContinuationPoints;
        private ByteString[] continuationPoints;

        protected Builder() {
        }

        public Builder setRequestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return this;
        }

        public Builder setReleaseContinuationPoints(Boolean bl) {
            this.releaseContinuationPoints = bl;
            return this;
        }

        public Builder setContinuationPoints(ByteString[] byteStringArray) {
            this.continuationPoints = byteStringArray;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
                this.setRequestHeader((RequestHeader)object);
                return this;
            }
            if (Fields.ReleaseContinuationPoints.getSpecification().equals(fieldSpecification)) {
                this.setReleaseContinuationPoints((Boolean)object);
                return this;
            }
            if (Fields.ContinuationPoints.getSpecification().equals(fieldSpecification)) {
                this.setContinuationPoints((ByteString[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public BrowseNextRequest build() {
            return new BrowseNextRequest(this.requestHeader, this.releaseContinuationPoints, this.continuationPoints);
        }
    }

    public static enum Fields {
        RequestHeader("RequestHeader", RequestHeader.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=389")), -1),
        ReleaseContinuationPoints("ReleaseContinuationPoints", Boolean.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=1")), -1),
        ContinuationPoints("ContinuationPoints", ByteString[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=521")), 1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

