/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.ConnectionTransportDataType;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=15007")
public class BrokerConnectionTransportDataType
extends ConnectionTransportDataType {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.BrokerConnectionTransportDataType_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.BrokerConnectionTransportDataType_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.BrokerConnectionTransportDataType_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.BrokerConnectionTransportDataType;
    public static final StructureSpecification SPECIFICATION;
    private String resourceUri;
    private String authenticationProfileUri;

    public BrokerConnectionTransportDataType() {
    }

    public BrokerConnectionTransportDataType(String string, String string2) {
        this.resourceUri = string;
        this.authenticationProfileUri = string2;
    }

    public String getResourceUri() {
        return this.resourceUri;
    }

    public void setResourceUri(String string) {
        this.resourceUri = string;
    }

    public String getAuthenticationProfileUri() {
        return this.authenticationProfileUri;
    }

    public void setAuthenticationProfileUri(String string) {
        this.authenticationProfileUri = string;
    }

    @Override
    public BrokerConnectionTransportDataType clone() {
        BrokerConnectionTransportDataType brokerConnectionTransportDataType = (BrokerConnectionTransportDataType)super.clone();
        brokerConnectionTransportDataType.resourceUri = StructureUtils.clone(this.resourceUri);
        brokerConnectionTransportDataType.authenticationProfileUri = StructureUtils.clone(this.authenticationProfileUri);
        return brokerConnectionTransportDataType;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BrokerConnectionTransportDataType brokerConnectionTransportDataType = (BrokerConnectionTransportDataType)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getResourceUri(), brokerConnectionTransportDataType.getResourceUri())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getAuthenticationProfileUri(), brokerConnectionTransportDataType.getAuthenticationProfileUri());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getResourceUri(), this.getAuthenticationProfileUri());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.ResourceUri.getSpecification().equals(fieldSpecification)) {
            return this.getResourceUri();
        }
        if (Fields.AuthenticationProfileUri.getSpecification().equals(fieldSpecification)) {
            return this.getAuthenticationProfileUri();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.ResourceUri.getSpecification().equals(fieldSpecification)) {
            this.setResourceUri((String)object);
            return;
        }
        if (Fields.AuthenticationProfileUri.getSpecification().equals(fieldSpecification)) {
            this.setAuthenticationProfileUri((String)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = BrokerConnectionTransportDataType.builder();
        builder.setResourceUri(this.getResourceUri());
        builder.setAuthenticationProfileUri(this.getAuthenticationProfileUri());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.ResourceUri.getSpecification());
        builder.addField(Fields.AuthenticationProfileUri.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("BrokerConnectionTransportDataType");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.BrokerConnectionTransportDataTypeSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return BrokerConnectionTransportDataType.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends ConnectionTransportDataType.Builder {
        private String resourceUri;
        private String authenticationProfileUri;

        protected Builder() {
        }

        public Builder setResourceUri(String string) {
            this.resourceUri = string;
            return this;
        }

        public Builder setAuthenticationProfileUri(String string) {
            this.authenticationProfileUri = string;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.ResourceUri.getSpecification().equals(fieldSpecification)) {
                this.setResourceUri((String)object);
                return this;
            }
            if (Fields.AuthenticationProfileUri.getSpecification().equals(fieldSpecification)) {
                this.setAuthenticationProfileUri((String)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public BrokerConnectionTransportDataType build() {
            return new BrokerConnectionTransportDataType(this.resourceUri, this.authenticationProfileUri);
        }
    }

    public static enum Fields {
        ResourceUri("ResourceUri", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), -1),
        AuthenticationProfileUri("AuthenticationProfileUri", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

