/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.AxisScaleEnumeration;
import com.prosysopc.ua.stack.core.EUInformation;
import com.prosysopc.ua.stack.core.Range;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=12079")
public class AxisInformation
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.AxisInformation_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.AxisInformation_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.AxisInformation_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.AxisInformation;
    public static final StructureSpecification SPECIFICATION;
    private EUInformation engineeringUnits;
    private Range eURange;
    private LocalizedText title;
    private AxisScaleEnumeration axisScaleType;
    private Double[] axisSteps;

    public AxisInformation() {
    }

    public AxisInformation(EUInformation eUInformation, Range range, LocalizedText localizedText, AxisScaleEnumeration axisScaleEnumeration, Double[] doubleArray) {
        this.engineeringUnits = eUInformation;
        this.eURange = range;
        this.title = localizedText;
        this.axisScaleType = axisScaleEnumeration;
        this.axisSteps = doubleArray;
    }

    public EUInformation getEngineeringUnits() {
        return this.engineeringUnits;
    }

    public void setEngineeringUnits(EUInformation eUInformation) {
        this.engineeringUnits = eUInformation;
    }

    public Range getEURange() {
        return this.eURange;
    }

    public void setEURange(Range range) {
        this.eURange = range;
    }

    public LocalizedText getTitle() {
        return this.title;
    }

    public void setTitle(LocalizedText localizedText) {
        this.title = localizedText;
    }

    public AxisScaleEnumeration getAxisScaleType() {
        return this.axisScaleType;
    }

    public void setAxisScaleType(AxisScaleEnumeration axisScaleEnumeration) {
        this.axisScaleType = axisScaleEnumeration;
    }

    public Double[] getAxisSteps() {
        return this.axisSteps;
    }

    public void setAxisSteps(Double[] doubleArray) {
        this.axisSteps = doubleArray;
    }

    @Override
    public AxisInformation clone() {
        AxisInformation axisInformation = (AxisInformation)super.clone();
        axisInformation.engineeringUnits = StructureUtils.clone(this.engineeringUnits);
        axisInformation.eURange = StructureUtils.clone(this.eURange);
        axisInformation.title = StructureUtils.clone(this.title);
        axisInformation.axisScaleType = StructureUtils.clone(this.axisScaleType);
        axisInformation.axisSteps = StructureUtils.clone(this.axisSteps);
        return axisInformation;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AxisInformation axisInformation = (AxisInformation)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getEngineeringUnits(), axisInformation.getEngineeringUnits())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getEURange(), axisInformation.getEURange())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getTitle(), axisInformation.getTitle())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getAxisScaleType(), axisInformation.getAxisScaleType())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getAxisSteps(), axisInformation.getAxisSteps());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getEngineeringUnits(), this.getEURange(), this.getTitle(), this.getAxisScaleType(), this.getAxisSteps());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.EngineeringUnits.getSpecification().equals(fieldSpecification)) {
            return this.getEngineeringUnits();
        }
        if (Fields.EURange.getSpecification().equals(fieldSpecification)) {
            return this.getEURange();
        }
        if (Fields.Title.getSpecification().equals(fieldSpecification)) {
            return this.getTitle();
        }
        if (Fields.AxisScaleType.getSpecification().equals(fieldSpecification)) {
            return this.getAxisScaleType();
        }
        if (Fields.AxisSteps.getSpecification().equals(fieldSpecification)) {
            return this.getAxisSteps();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.EngineeringUnits.getSpecification().equals(fieldSpecification)) {
            this.setEngineeringUnits((EUInformation)object);
            return;
        }
        if (Fields.EURange.getSpecification().equals(fieldSpecification)) {
            this.setEURange((Range)object);
            return;
        }
        if (Fields.Title.getSpecification().equals(fieldSpecification)) {
            this.setTitle((LocalizedText)object);
            return;
        }
        if (Fields.AxisScaleType.getSpecification().equals(fieldSpecification)) {
            this.setAxisScaleType((AxisScaleEnumeration)object);
            return;
        }
        if (Fields.AxisSteps.getSpecification().equals(fieldSpecification)) {
            this.setAxisSteps((Double[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = AxisInformation.builder();
        builder.setEngineeringUnits(this.getEngineeringUnits());
        builder.setEURange(this.getEURange());
        builder.setTitle(this.getTitle());
        builder.setAxisScaleType(this.getAxisScaleType());
        builder.setAxisSteps(this.getAxisSteps());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.EngineeringUnits.getSpecification());
        builder.addField(Fields.EURange.getSpecification());
        builder.addField(Fields.Title.getSpecification());
        builder.addField(Fields.AxisScaleType.getSpecification());
        builder.addField(Fields.AxisSteps.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("AxisInformation");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.AxisInformationSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return AxisInformation.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private EUInformation engineeringUnits;
        private Range eURange;
        private LocalizedText title;
        private AxisScaleEnumeration axisScaleType;
        private Double[] axisSteps;

        protected Builder() {
        }

        public Builder setEngineeringUnits(EUInformation eUInformation) {
            this.engineeringUnits = eUInformation;
            return this;
        }

        public Builder setEURange(Range range) {
            this.eURange = range;
            return this;
        }

        public Builder setTitle(LocalizedText localizedText) {
            this.title = localizedText;
            return this;
        }

        public Builder setAxisScaleType(AxisScaleEnumeration axisScaleEnumeration) {
            this.axisScaleType = axisScaleEnumeration;
            return this;
        }

        public Builder setAxisSteps(Double[] doubleArray) {
            this.axisSteps = doubleArray;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.EngineeringUnits.getSpecification().equals(fieldSpecification)) {
                this.setEngineeringUnits((EUInformation)object);
                return this;
            }
            if (Fields.EURange.getSpecification().equals(fieldSpecification)) {
                this.setEURange((Range)object);
                return this;
            }
            if (Fields.Title.getSpecification().equals(fieldSpecification)) {
                this.setTitle((LocalizedText)object);
                return this;
            }
            if (Fields.AxisScaleType.getSpecification().equals(fieldSpecification)) {
                this.setAxisScaleType((AxisScaleEnumeration)object);
                return this;
            }
            if (Fields.AxisSteps.getSpecification().equals(fieldSpecification)) {
                this.setAxisSteps((Double[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public AxisInformation build() {
            return new AxisInformation(this.engineeringUnits, this.eURange, this.title, this.axisScaleType, this.axisSteps);
        }
    }

    public static enum Fields {
        EngineeringUnits("EngineeringUnits", EUInformation.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=887")), -1),
        EURange("EURange", Range.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=884")), -1),
        Title("Title", LocalizedText.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=21")), -1),
        AxisScaleType("AxisScaleType", AxisScaleEnumeration.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12077")), -1),
        AxisSteps("AxisSteps", Double[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=11")), 1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

