/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.ApplicationType;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=308")
public class ApplicationDescription
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.ApplicationDescription_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.ApplicationDescription_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.ApplicationDescription_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.ApplicationDescription;
    public static final StructureSpecification SPECIFICATION;
    private String applicationUri;
    private String productUri;
    private LocalizedText applicationName;
    private ApplicationType applicationType;
    private String gatewayServerUri;
    private String discoveryProfileUri;
    private String[] discoveryUrls;

    public ApplicationDescription() {
    }

    public ApplicationDescription(String string, String string2, LocalizedText localizedText, ApplicationType applicationType, String string3, String string4, String[] stringArray) {
        this.applicationUri = string;
        this.productUri = string2;
        this.applicationName = localizedText;
        this.applicationType = applicationType;
        this.gatewayServerUri = string3;
        this.discoveryProfileUri = string4;
        this.discoveryUrls = stringArray;
    }

    public String getApplicationUri() {
        return this.applicationUri;
    }

    public void setApplicationUri(String string) {
        this.applicationUri = string;
    }

    public String getProductUri() {
        return this.productUri;
    }

    public void setProductUri(String string) {
        this.productUri = string;
    }

    public LocalizedText getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(LocalizedText localizedText) {
        this.applicationName = localizedText;
    }

    public ApplicationType getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(ApplicationType applicationType) {
        this.applicationType = applicationType;
    }

    public String getGatewayServerUri() {
        return this.gatewayServerUri;
    }

    public void setGatewayServerUri(String string) {
        this.gatewayServerUri = string;
    }

    public String getDiscoveryProfileUri() {
        return this.discoveryProfileUri;
    }

    public void setDiscoveryProfileUri(String string) {
        this.discoveryProfileUri = string;
    }

    public String[] getDiscoveryUrls() {
        return this.discoveryUrls;
    }

    public void setDiscoveryUrls(String[] stringArray) {
        this.discoveryUrls = stringArray;
    }

    @Override
    public ApplicationDescription clone() {
        ApplicationDescription applicationDescription = (ApplicationDescription)super.clone();
        applicationDescription.applicationUri = StructureUtils.clone(this.applicationUri);
        applicationDescription.productUri = StructureUtils.clone(this.productUri);
        applicationDescription.applicationName = StructureUtils.clone(this.applicationName);
        applicationDescription.applicationType = StructureUtils.clone(this.applicationType);
        applicationDescription.gatewayServerUri = StructureUtils.clone(this.gatewayServerUri);
        applicationDescription.discoveryProfileUri = StructureUtils.clone(this.discoveryProfileUri);
        applicationDescription.discoveryUrls = StructureUtils.clone(this.discoveryUrls);
        return applicationDescription;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ApplicationDescription applicationDescription = (ApplicationDescription)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getApplicationUri(), applicationDescription.getApplicationUri())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getProductUri(), applicationDescription.getProductUri())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getApplicationName(), applicationDescription.getApplicationName())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getApplicationType(), applicationDescription.getApplicationType())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getGatewayServerUri(), applicationDescription.getGatewayServerUri())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getDiscoveryProfileUri(), applicationDescription.getDiscoveryProfileUri())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getDiscoveryUrls(), applicationDescription.getDiscoveryUrls());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getApplicationUri(), this.getProductUri(), this.getApplicationName(), this.getApplicationType(), this.getGatewayServerUri(), this.getDiscoveryProfileUri(), this.getDiscoveryUrls());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.ApplicationUri.getSpecification().equals(fieldSpecification)) {
            return this.getApplicationUri();
        }
        if (Fields.ProductUri.getSpecification().equals(fieldSpecification)) {
            return this.getProductUri();
        }
        if (Fields.ApplicationName.getSpecification().equals(fieldSpecification)) {
            return this.getApplicationName();
        }
        if (Fields.ApplicationType.getSpecification().equals(fieldSpecification)) {
            return this.getApplicationType();
        }
        if (Fields.GatewayServerUri.getSpecification().equals(fieldSpecification)) {
            return this.getGatewayServerUri();
        }
        if (Fields.DiscoveryProfileUri.getSpecification().equals(fieldSpecification)) {
            return this.getDiscoveryProfileUri();
        }
        if (Fields.DiscoveryUrls.getSpecification().equals(fieldSpecification)) {
            return this.getDiscoveryUrls();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.ApplicationUri.getSpecification().equals(fieldSpecification)) {
            this.setApplicationUri((String)object);
            return;
        }
        if (Fields.ProductUri.getSpecification().equals(fieldSpecification)) {
            this.setProductUri((String)object);
            return;
        }
        if (Fields.ApplicationName.getSpecification().equals(fieldSpecification)) {
            this.setApplicationName((LocalizedText)object);
            return;
        }
        if (Fields.ApplicationType.getSpecification().equals(fieldSpecification)) {
            this.setApplicationType((ApplicationType)object);
            return;
        }
        if (Fields.GatewayServerUri.getSpecification().equals(fieldSpecification)) {
            this.setGatewayServerUri((String)object);
            return;
        }
        if (Fields.DiscoveryProfileUri.getSpecification().equals(fieldSpecification)) {
            this.setDiscoveryProfileUri((String)object);
            return;
        }
        if (Fields.DiscoveryUrls.getSpecification().equals(fieldSpecification)) {
            this.setDiscoveryUrls((String[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = ApplicationDescription.builder();
        builder.setApplicationUri(this.getApplicationUri());
        builder.setProductUri(this.getProductUri());
        builder.setApplicationName(this.getApplicationName());
        builder.setApplicationType(this.getApplicationType());
        builder.setGatewayServerUri(this.getGatewayServerUri());
        builder.setDiscoveryProfileUri(this.getDiscoveryProfileUri());
        builder.setDiscoveryUrls(this.getDiscoveryUrls());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.ApplicationUri.getSpecification());
        builder.addField(Fields.ProductUri.getSpecification());
        builder.addField(Fields.ApplicationName.getSpecification());
        builder.addField(Fields.ApplicationType.getSpecification());
        builder.addField(Fields.GatewayServerUri.getSpecification());
        builder.addField(Fields.DiscoveryProfileUri.getSpecification());
        builder.addField(Fields.DiscoveryUrls.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("ApplicationDescription");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.ApplicationDescriptionSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return ApplicationDescription.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private String applicationUri;
        private String productUri;
        private LocalizedText applicationName;
        private ApplicationType applicationType;
        private String gatewayServerUri;
        private String discoveryProfileUri;
        private String[] discoveryUrls;

        protected Builder() {
        }

        public Builder setApplicationUri(String string) {
            this.applicationUri = string;
            return this;
        }

        public Builder setProductUri(String string) {
            this.productUri = string;
            return this;
        }

        public Builder setApplicationName(LocalizedText localizedText) {
            this.applicationName = localizedText;
            return this;
        }

        public Builder setApplicationType(ApplicationType applicationType) {
            this.applicationType = applicationType;
            return this;
        }

        public Builder setGatewayServerUri(String string) {
            this.gatewayServerUri = string;
            return this;
        }

        public Builder setDiscoveryProfileUri(String string) {
            this.discoveryProfileUri = string;
            return this;
        }

        public Builder setDiscoveryUrls(String[] stringArray) {
            this.discoveryUrls = stringArray;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.ApplicationUri.getSpecification().equals(fieldSpecification)) {
                this.setApplicationUri((String)object);
                return this;
            }
            if (Fields.ProductUri.getSpecification().equals(fieldSpecification)) {
                this.setProductUri((String)object);
                return this;
            }
            if (Fields.ApplicationName.getSpecification().equals(fieldSpecification)) {
                this.setApplicationName((LocalizedText)object);
                return this;
            }
            if (Fields.ApplicationType.getSpecification().equals(fieldSpecification)) {
                this.setApplicationType((ApplicationType)object);
                return this;
            }
            if (Fields.GatewayServerUri.getSpecification().equals(fieldSpecification)) {
                this.setGatewayServerUri((String)object);
                return this;
            }
            if (Fields.DiscoveryProfileUri.getSpecification().equals(fieldSpecification)) {
                this.setDiscoveryProfileUri((String)object);
                return this;
            }
            if (Fields.DiscoveryUrls.getSpecification().equals(fieldSpecification)) {
                this.setDiscoveryUrls((String[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public ApplicationDescription build() {
            return new ApplicationDescription(this.applicationUri, this.productUri, this.applicationName, this.applicationType, this.gatewayServerUri, this.discoveryProfileUri, this.discoveryUrls);
        }
    }

    public static enum Fields {
        ApplicationUri("ApplicationUri", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), -1),
        ProductUri("ProductUri", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), -1),
        ApplicationName("ApplicationName", LocalizedText.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=21")), -1),
        ApplicationType("ApplicationType", ApplicationType.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=307")), -1),
        GatewayServerUri("GatewayServerUri", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), -1),
        DiscoveryProfileUri("DiscoveryProfileUri", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), -1),
        DiscoveryUrls("DiscoveryUrls", String[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), 1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

