/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=891")
public class Annotation
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.Annotation_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.Annotation_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.Annotation_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.Annotation;
    public static final StructureSpecification SPECIFICATION;
    private String message;
    private String userName;
    private DateTime annotationTime;

    public Annotation() {
    }

    public Annotation(String string, String string2, DateTime dateTime) {
        this.message = string;
        this.userName = string2;
        this.annotationTime = dateTime;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public DateTime getAnnotationTime() {
        return this.annotationTime;
    }

    public void setAnnotationTime(DateTime dateTime) {
        this.annotationTime = dateTime;
    }

    @Override
    public Annotation clone() {
        Annotation annotation = (Annotation)super.clone();
        annotation.message = StructureUtils.clone(this.message);
        annotation.userName = StructureUtils.clone(this.userName);
        annotation.annotationTime = StructureUtils.clone(this.annotationTime);
        return annotation;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Annotation annotation = (Annotation)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getMessage(), annotation.getMessage())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getUserName(), annotation.getUserName())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getAnnotationTime(), annotation.getAnnotationTime());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getMessage(), this.getUserName(), this.getAnnotationTime());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.Message.getSpecification().equals(fieldSpecification)) {
            return this.getMessage();
        }
        if (Fields.UserName.getSpecification().equals(fieldSpecification)) {
            return this.getUserName();
        }
        if (Fields.AnnotationTime.getSpecification().equals(fieldSpecification)) {
            return this.getAnnotationTime();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.Message.getSpecification().equals(fieldSpecification)) {
            this.setMessage((String)object);
            return;
        }
        if (Fields.UserName.getSpecification().equals(fieldSpecification)) {
            this.setUserName((String)object);
            return;
        }
        if (Fields.AnnotationTime.getSpecification().equals(fieldSpecification)) {
            this.setAnnotationTime((DateTime)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = Annotation.builder();
        builder.setMessage(this.getMessage());
        builder.setUserName(this.getUserName());
        builder.setAnnotationTime(this.getAnnotationTime());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.Message.getSpecification());
        builder.addField(Fields.UserName.getSpecification());
        builder.addField(Fields.AnnotationTime.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("Annotation");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.AnnotationSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return Annotation.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private String message;
        private String userName;
        private DateTime annotationTime;

        protected Builder() {
        }

        public Builder setMessage(String string) {
            this.message = string;
            return this;
        }

        public Builder setUserName(String string) {
            this.userName = string;
            return this;
        }

        public Builder setAnnotationTime(DateTime dateTime) {
            this.annotationTime = dateTime;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.Message.getSpecification().equals(fieldSpecification)) {
                this.setMessage((String)object);
                return this;
            }
            if (Fields.UserName.getSpecification().equals(fieldSpecification)) {
                this.setUserName((String)object);
                return this;
            }
            if (Fields.AnnotationTime.getSpecification().equals(fieldSpecification)) {
                this.setAnnotationTime((DateTime)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public Annotation build() {
            return new Annotation(this.message, this.userName, this.annotationTime);
        }
    }

    public static enum Fields {
        Message("Message", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), -1),
        UserName("UserName", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), -1),
        AnnotationTime("AnnotationTime", DateTime.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=294")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

