/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.AddNodesItem;
import com.prosysopc.ua.stack.core.AddNodesResponse;
import com.prosysopc.ua.stack.core.RequestHeader;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=486")
public class AddNodesRequest
extends AbstractStructure
implements ServiceRequest<AddNodesResponse> {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.AddNodesRequest_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.AddNodesRequest_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.AddNodesRequest_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.AddNodesRequest;
    public static final StructureSpecification SPECIFICATION;
    private RequestHeader requestHeader;
    private AddNodesItem[] nodesToAdd;

    public AddNodesRequest() {
    }

    public AddNodesRequest(RequestHeader requestHeader, AddNodesItem[] addNodesItemArray) {
        this.requestHeader = requestHeader;
        this.nodesToAdd = addNodesItemArray;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    @Override
    public void setRequestHeader(RequestHeader requestHeader) {
        this.requestHeader = requestHeader;
    }

    public AddNodesItem[] getNodesToAdd() {
        return this.nodesToAdd;
    }

    public void setNodesToAdd(AddNodesItem[] addNodesItemArray) {
        this.nodesToAdd = addNodesItemArray;
    }

    @Override
    public AddNodesRequest clone() {
        AddNodesRequest addNodesRequest = (AddNodesRequest)super.clone();
        addNodesRequest.requestHeader = StructureUtils.clone(this.requestHeader);
        addNodesRequest.nodesToAdd = StructureUtils.clone(this.nodesToAdd);
        return addNodesRequest;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AddNodesRequest addNodesRequest = (AddNodesRequest)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getRequestHeader(), addNodesRequest.getRequestHeader())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getNodesToAdd(), addNodesRequest.getNodesToAdd());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getRequestHeader(), this.getNodesToAdd());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
            return this.getRequestHeader();
        }
        if (Fields.NodesToAdd.getSpecification().equals(fieldSpecification)) {
            return this.getNodesToAdd();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
            this.setRequestHeader((RequestHeader)object);
            return;
        }
        if (Fields.NodesToAdd.getSpecification().equals(fieldSpecification)) {
            this.setNodesToAdd((AddNodesItem[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = AddNodesRequest.builder();
        builder.setRequestHeader(this.getRequestHeader());
        builder.setNodesToAdd(this.getNodesToAdd());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.RequestHeader.getSpecification());
        builder.addField(Fields.NodesToAdd.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("AddNodesRequest");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.AddNodesRequestSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return AddNodesRequest.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private RequestHeader requestHeader;
        private AddNodesItem[] nodesToAdd;

        protected Builder() {
        }

        public Builder setRequestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return this;
        }

        public Builder setNodesToAdd(AddNodesItem[] addNodesItemArray) {
            this.nodesToAdd = addNodesItemArray;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
                this.setRequestHeader((RequestHeader)object);
                return this;
            }
            if (Fields.NodesToAdd.getSpecification().equals(fieldSpecification)) {
                this.setNodesToAdd((AddNodesItem[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public AddNodesRequest build() {
            return new AddNodesRequest(this.requestHeader, this.nodesToAdd);
        }
    }

    public static enum Fields {
        RequestHeader("RequestHeader", RequestHeader.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=389")), -1),
        NodesToAdd("NodesToAdd", AddNodesItem[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=376")), 1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

