/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.common;

import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.ResponseHeader;
import com.prosysopc.ua.stack.core.ServiceFault;
import com.prosysopc.ua.stack.core.StatusCodes;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;

public class ServiceFaultException
extends ServiceResultException {
    private static final long serialVersionUID = 1L;
    ServiceFault pC;
    DiagnosticInfo pD;

    public static ServiceFault createServiceFault(UnsignedInteger unsignedInteger) {
        ResponseHeader responseHeader = new ResponseHeader();
        ServiceFault serviceFault = new ServiceFault(responseHeader);
        responseHeader.setServiceResult(new StatusCode(unsignedInteger));
        responseHeader.setTimestamp(new DateTime());
        return serviceFault;
    }

    public static ServiceFault toServiceFault(Throwable throwable) {
        ResponseHeader responseHeader = new ResponseHeader();
        ServiceFault serviceFault = new ServiceFault(responseHeader);
        responseHeader.setServiceResult(throwable instanceof ServiceResultException ? ((ServiceResultException)throwable).getStatusCode() : new StatusCode(StatusCodes.Bad_InternalError));
        responseHeader.setTimestamp(new DateTime());
        ArrayList<String> arrayList = new ArrayList<String>();
        DiagnosticInfo diagnosticInfo = null;
        while (throwable != null) {
            if (diagnosticInfo == null) {
                diagnosticInfo = new DiagnosticInfo();
                responseHeader.setServiceDiagnostics(diagnosticInfo);
            } else {
                DiagnosticInfo diagnosticInfo2 = diagnosticInfo;
                diagnosticInfo = new DiagnosticInfo();
                diagnosticInfo2.setInnerDiagnosticInfo(diagnosticInfo);
            }
            diagnosticInfo.setStringTable(arrayList);
            diagnosticInfo.setLocalizedTextStr(throwable instanceof ServiceResultException ? throwable.getMessage() : throwable.toString());
            StringWriter stringWriter = new StringWriter(100);
            PrintWriter printWriter = new PrintWriter(stringWriter);
            for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                printWriter.println("\tat " + stackTraceElement);
            }
            diagnosticInfo.setAdditionalInfo(stringWriter.toString());
            diagnosticInfo.setInnerStatusCode(throwable instanceof ServiceResultException ? ((ServiceResultException)throwable).getStatusCode() : new StatusCode(StatusCodes.Bad_InternalError));
            throwable = throwable.getCause();
        }
        responseHeader.setStringTable(arrayList.toArray(new String[arrayList.size()]));
        return serviceFault;
    }

    public ServiceFaultException(ServiceFault serviceFault) {
        super(serviceFault.getResponseHeader() == null ? new StatusCode(StatusCodes.Bad_InternalError) : (serviceFault.getResponseHeader().getServiceDiagnostics() == null ? new StatusCode(StatusCodes.Bad_InternalError) : (serviceFault.getResponseHeader().getServiceDiagnostics().getInnerStatusCode() == null ? new StatusCode(StatusCodes.Bad_InternalError) : serviceFault.getResponseHeader().getServiceDiagnostics().getInnerStatusCode())));
        this.pC = serviceFault;
    }

    public ServiceFaultException(Throwable throwable) {
        super(throwable);
        this.pC = ServiceFaultException.toServiceFault(throwable);
    }

    @Override
    public String getMessage() {
        return this.pC.toString();
    }

    public ServiceFault getServiceFault() {
        return this.pC;
    }

    @Override
    public StatusCode getStatusCode() {
        if (this.pC.getResponseHeader() == null || this.pC.getResponseHeader().getServiceResult() == null) {
            return new StatusCode(StatusCodes.Bad_InternalError);
        }
        return this.pC.getResponseHeader().getServiceResult();
    }

    @Override
    public String toString() {
        return this.pC.toString();
    }
}

