/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.cert;

import com.prosysopc.ua.stack.cert.CertificateStore;
import com.prosysopc.ua.stack.cert.DefaultCertificateStoreListener;
import com.prosysopc.ua.stack.cert.ValidationResult;
import com.prosysopc.ua.stack.transport.security.Cert;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PkiDirectoryCertificateStore
implements CertificateStore {
    private static final Logger logger = LoggerFactory.getLogger(PkiDirectoryCertificateStore.class);
    private static final String po = ".der";
    private static final String pp = "0123456789ABCDEF";
    private final Map<String, Cert> pq = new ConcurrentHashMap<String, Cert>();
    private final Map<String, Cert> pr = new ConcurrentHashMap<String, Cert>();
    private final Set<X509CRL> ps = new CopyOnWriteArraySet<X509CRL>();
    private final Map<Cert, String> pt = new ConcurrentHashMap<Cert, String>();
    private final File pu;
    private final File pv;
    private final File pw;
    private final File px;
    private boolean py = true;
    private final List<DefaultCertificateStoreListener> listeners = new ArrayList<DefaultCertificateStoreListener>();

    public PkiDirectoryCertificateStore() {
        this("PKI/CA", "certs", "rejected", "crl");
    }

    public PkiDirectoryCertificateStore(String string) {
        this(string, "certs", "rejected", "crl");
    }

    public PkiDirectoryCertificateStore(String string, String string2, String string3, String string4) {
        this.pu = new File(string);
        this.px = new File(string, string2);
        this.pw = new File(string, string3);
        this.pv = new File(string, string4);
        this.init();
    }

    @Override
    public void addCertificate(ValidationResult validationResult, Cert cert) {
        if (validationResult == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        if (cert == null) {
            throw new IllegalArgumentException("certificate cannot be null");
        }
        switch (validationResult) {
            case AcceptPermanently: {
                this.addTrustedCertificate(cert);
                break;
            }
            case AcceptOnce: {
                if (!this.py) break;
                this.addRejectedCertificate(cert);
                break;
            }
            case Reject: {
                this.addRejectedCertificate(cert);
                break;
            }
            default: {
                throw new IllegalArgumentException("encountered unknown type parameter: " + (Object)((Object)validationResult));
            }
        }
    }

    public void addListener(DefaultCertificateStoreListener defaultCertificateStoreListener) {
        if (defaultCertificateStoreListener != null && !this.listeners.contains(defaultCertificateStoreListener)) {
            this.listeners.add(defaultCertificateStoreListener);
        }
    }

    public void addRejectedCertificate(Cert cert) {
        this.a(this.pq, this.pw, cert);
        this.b(this.pr, this.px, cert);
        logger.info("Certificate '{}' added to rejected certificates.", (Object)this.e(cert));
        this.c(cert);
    }

    public void addRevocationList(X509CRL x509CRL) {
        this.ps.add(x509CRL);
        this.a(x509CRL);
    }

    public void addTrustedCertificate(Cert cert) {
        logger.debug("addTrustedCertificate");
        this.a(this.pr, this.px, cert);
        this.b(this.pq, this.pw, cert);
        logger.info("Certificate '{}' added to trusted certificates.", (Object)this.e(cert));
        this.d(cert);
    }

    public void clear(boolean bl) {
        if (bl) {
            for (File file : this.px.listFiles()) {
                file.delete();
            }
            for (File file : this.pw.listFiles()) {
                file.delete();
            }
            for (File file : this.pv.listFiles()) {
                file.delete();
            }
        }
        this.pr.clear();
        this.pq.clear();
        this.pt.clear();
    }

    public File getBaseDir() {
        return this.pu;
    }

    public File getFileForCert(Cert cert) {
        if (cert == null) {
            return null;
        }
        if (this.pr.containsKey(this.e(cert))) {
            return this.a(this.px, cert);
        }
        if (this.pq.containsKey(this.e(cert))) {
            return this.a(this.pw, cert);
        }
        return null;
    }

    @Override
    public Set<Cert> getRejectedCerts() {
        this.init();
        HashSet<Cert> hashSet = new HashSet<Cert>();
        for (Map.Entry<String, Cert> entry : this.pq.entrySet()) {
            hashSet.add(entry.getValue());
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public File getRejectedDir() {
        return this.pw;
    }

    public File getRevocationDir() {
        return this.pv;
    }

    @Override
    public Set<X509CRL> getRevocationLists() {
        this.init();
        HashSet<X509CRL> hashSet = new HashSet<X509CRL>();
        for (X509CRL x509CRL : this.ps) {
            hashSet.add(x509CRL);
        }
        return Collections.unmodifiableSet(hashSet);
    }

    @Override
    public Set<Cert> getTrustedCerts() {
        this.init();
        HashSet<Cert> hashSet = new HashSet<Cert>();
        for (Map.Entry<String, Cert> entry : this.pr.entrySet()) {
            hashSet.add(entry.getValue());
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public File getTrustedDir() {
        return this.px;
    }

    public boolean isStoreAcceptOnceCertificates() {
        return this.py;
    }

    public void refresh() {
        this.init();
    }

    public void removeListener(DefaultCertificateStoreListener defaultCertificateStoreListener) {
        if (defaultCertificateStoreListener != null) {
            this.listeners.remove(defaultCertificateStoreListener);
        }
    }

    public void setStoreAcceptOnceCertificates(boolean bl) {
        this.py = bl;
    }

    private void c(Cert cert) {
        for (DefaultCertificateStoreListener defaultCertificateStoreListener : this.listeners) {
            defaultCertificateStoreListener.onRejectedCertificateAdded(cert);
        }
    }

    private void a(X509CRL x509CRL) {
        for (DefaultCertificateStoreListener defaultCertificateStoreListener : this.listeners) {
            defaultCertificateStoreListener.onRevokedListAdded(x509CRL);
        }
    }

    private void d(Cert cert) {
        for (DefaultCertificateStoreListener defaultCertificateStoreListener : this.listeners) {
            defaultCertificateStoreListener.onTrustedCertificateAdded(cert);
        }
    }

    private String e(Cert cert) {
        return this.a(cert.getEncodedThumbprint());
    }

    private File a(File file, Cert cert) {
        String string = this.pt.get(cert);
        if (string != null) {
            return new File(file, string);
        }
        return new File(file, this.e(cert) + po);
    }

    private String a(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(2 * byArray.length);
        for (byte by : byArray) {
            stringBuilder.append(pp.charAt((by & 0xF0) >> 4)).append(pp.charAt(by & 0xF));
        }
        return stringBuilder.toString();
    }

    private synchronized void init() {
        this.a(this.pr, this.px, this.pq);
        this.a(this.pq, this.pw, this.pr);
        this.eA();
    }

    private void a(Map<String, Cert> map, File file, Map<String, Cert> map2) {
        if (!file.exists()) {
            file.mkdirs();
        }
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                try {
                    Cert cert = Cert.load(file2);
                    this.pt.put(cert, file2.getName());
                    this.a(map, file, cert);
                    logger.debug("Initialized cert from file: {}", (Object)file2);
                    if (map2 == null) continue;
                    map2.remove(this.e(cert));
                }
                catch (IOException iOException) {
                    logger.info("File '{}' is not a certificate: {}", (Object)file2, (Object)iOException.getMessage());
                }
                catch (CertificateException certificateException) {
                    logger.info("File '{}' is not a valid certificate: {}", (Object)file2, (Object)certificateException.getMessage());
                }
            }
        }
    }

    private void b(File file) {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            FileInputStream fileInputStream = new FileInputStream(file);
            X509CRL x509CRL = (X509CRL)certificateFactory.generateCRL(fileInputStream);
            this.ps.add(x509CRL);
            logger.info("CRL initialized from " + file + ": " + (x509CRL.getRevokedCertificates() == null ? "no revoked certificates" : x509CRL.getRevokedCertificates().size() + " certificates revoked"));
        }
        catch (Exception exception) {
            logger.warn("Could not read CRL file {: {}", (Object)file, (Object)exception.getMessage());
        }
    }

    private void eA() {
        if (!this.pv.exists()) {
            this.pv.mkdirs();
        }
        if (this.pv.isDirectory()) {
            for (File file : this.pv.listFiles()) {
                if (file.getName().endsWith(".crl")) {
                    this.b(file);
                    continue;
                }
                logger.warn("Revocation folder contains something else than .crl file, found: {}", (Object)file.getAbsolutePath());
            }
        } else {
            logger.warn("revocationDir: {} is not a directory", (Object)this.pv.getAbsolutePath());
        }
    }

    private void a(Map<String, Cert> map, File file, Cert cert) {
        String string = this.e(cert);
        logger.debug("listAdd: cert={}; dir={}", (Object)string, (Object)file);
        if (!map.containsKey(string)) {
            try {
                File file2 = this.a(file, cert);
                if (!file2.exists()) {
                    cert.save(file2);
                }
            }
            catch (IOException iOException) {
                logger.error("Cannot write to directory " + file, (Throwable)iOException);
            }
            map.put(string, cert);
        }
        logger.debug("certificates.size()={}", (Object)map.size());
    }

    private void b(Map<String, Cert> map, File file, Cert cert) {
        logger.debug("removeCertificate: cert={} dir={}", (Object)this.e(cert), (Object)file);
        logger.debug("certificates.size()={}", (Object)map.size());
        File file2 = this.a(file, cert);
        file2.delete();
        Cert cert2 = map.remove(this.e(cert));
        if (logger.isDebugEnabled()) {
            logger.debug("c=" + (cert2 == null ? "null" : (Object)cert2.getEncodedThumbprint()));
            logger.debug("certificates.size()={}", (Object)map.size());
        }
    }
}

