/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.application;

import com.prosysopc.ua.stack.application.Application;
import com.prosysopc.ua.stack.application.EndpointDiscoveryService;
import com.prosysopc.ua.stack.application.ServiceHandler;
import com.prosysopc.ua.stack.application.ServiceHandlerComposition;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.ApplicationDescription;
import com.prosysopc.ua.stack.core.ApplicationType;
import com.prosysopc.ua.stack.core.EndpointDescription;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.core.UserTokenPolicy;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.IEncodeable;
import com.prosysopc.ua.stack.transport.Endpoint;
import com.prosysopc.ua.stack.transport.EndpointBinding;
import com.prosysopc.ua.stack.transport.EndpointServer;
import com.prosysopc.ua.stack.transport.UriUtil;
import com.prosysopc.ua.stack.transport.endpoint.EndpointBindingCollection;
import com.prosysopc.ua.stack.transport.https.HttpsServer;
import com.prosysopc.ua.stack.transport.security.CertificateValidator;
import com.prosysopc.ua.stack.transport.security.KeyPair;
import com.prosysopc.ua.stack.transport.security.SecurityMode;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.transport.tcp.nio.OpcTcpServer;
import com.prosysopc.ua.stack.utils.EndpointUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server {
    @Deprecated
    public static final String SOAP_XML_TRANSPORT_PROFILE_URI = "http://opcfoundation.org/UA-Profile/Transport/soaphttp-wssc-uaxml-uabinary";
    @Deprecated
    public static final String UATCP_BINARY_TRANSPORT_PROFILE_URI = "http://opcfoundation.org/UA-Profile/Transport/uatcp-uasc-uabinary";
    @Deprecated
    public static final String HTTPS_BINARY_TRANSPORT_PROFILE_URI = "http://opcfoundation.org/UA-Profile/Transport/https-uabinary";
    static Logger logger = LoggerFactory.getLogger(Server.class);
    protected ServiceHandlerComposition serviceHandlers = new ServiceHandlerComposition();
    protected List<UserTokenPolicy> userTokenPolicies = new CopyOnWriteArrayList<UserTokenPolicy>();
    protected EndpointBindingCollection endpointBindings;
    protected EndpointDiscoveryService endpointDiscoveryService;
    protected Application application;
    HttpsServer os;
    OpcTcpServer ot;
    protected List<EndpointServer.EndpointHandle> boundHandles = new CopyOnWriteArrayList<EndpointServer.EndpointHandle>();

    public static Server createServerApplication() {
        Application application = new Application();
        Server server = new Server(application);
        application.getOpctcpSettings().setCertificateValidator(CertificateValidator.ALLOW_ALL);
        application.getHttpsSettings().setCertificateValidator(CertificateValidator.ALLOW_ALL);
        return server;
    }

    public Server(Application application) {
        this.application = application;
        this.endpointBindings = new EndpointBindingCollection();
        this.endpointDiscoveryService = new EndpointDiscoveryService(this.endpointBindings);
        this.addServiceHandler(this.endpointDiscoveryService);
    }

    public void addServiceHandler(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("null arg");
        }
        logger.debug("addServiceHandler: {}", object);
        if (logger.isTraceEnabled()) {
            logger.trace("addServiceHandler: from {}", (Object)Thread.currentThread().getStackTrace()[2]);
        }
        this.serviceHandlers.add(object);
    }

    public void addUserTokenPolicy(UserTokenPolicy userTokenPolicy) {
        this.userTokenPolicies.add(userTokenPolicy);
    }

    public List<EndpointServer.EndpointHandle> bind(String string, Endpoint endpoint) throws ServiceResultException {
        ArrayList<EndpointServer.EndpointHandle> arrayList = new ArrayList<EndpointServer.EndpointHandle>();
        String string2 = UriUtil.getTransportProtocol(string);
        List<SocketAddress> list = EndpointUtil.toSocketAddresses(string);
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        EndpointServer endpointServer = this.getOrCreateEndpointServer(string2);
        for (SocketAddress socketAddress : list) {
            EndpointBinding endpointBinding = new EndpointBinding(endpointServer, endpoint, this);
            EndpointServer.EndpointHandle endpointHandle = endpointServer.bind(socketAddress, endpointBinding);
            this.boundHandles.add(endpointHandle);
        }
        return arrayList;
    }

    public List<EndpointServer.EndpointHandle> bind(String string, String string2, Collection<SecurityMode> collection) throws ServiceResultException {
        Endpoint endpoint = new Endpoint(string2, collection.toArray(SecurityMode.EMPTY_ARRAY));
        return this.bind(string, endpoint);
    }

    public List<EndpointServer.EndpointHandle> bind(String string, String string2, SecurityMode ... securityModeArray) throws ServiceResultException {
        Endpoint endpoint = new Endpoint(string2, securityModeArray);
        return this.bind(string, endpoint);
    }

    public void bindReverse(String string, String string2) throws ServiceResultException {
        URI uRI;
        String string3 = UriUtil.getTransportProtocol(string);
        if (!"opc.tcp".equals(string3)) {
            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "ReverseHello is only supported for 'opc.tcp'");
        }
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, (Throwable)uRISyntaxException, "Cannot resolve the given URI: " + string);
        }
        String string4 = uRI.getHost();
        if (string4 == null) {
            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "Cannot resolve host component of the given URI: " + string);
        }
        int n2 = uRI.getPort();
        if (n2 < 0) {
            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "Cannot resolve port component of the given URI: " + string);
        }
        EndpointServer endpointServer = this.getOrCreateEndpointServer("opc.tcp");
        endpointServer.bindReverse(new InetSocketAddress(string4, n2), string2);
    }

    public void close() {
        for (EndpointServer.EndpointHandle endpointHandle : this.boundHandles) {
            logger.debug("unbind: {}", (Object)endpointHandle);
            endpointHandle.close();
        }
        this.boundHandles.clear();
        if (this.os != null) {
            this.os.close();
            this.os = null;
        }
        if (this.ot != null) {
            this.ot.close();
            this.ot = null;
        }
        logger.info("Server {} closed", (Object)this);
    }

    public ApplicationDescription createApplicationDescription() {
        ApplicationDescription applicationDescription = this.application.N.clone();
        applicationDescription.setApplicationType(ApplicationType.Server);
        return applicationDescription;
    }

    public Application getApplication() {
        return this.application;
    }

    public EndpointServer[] getBindings() {
        ArrayList<EndpointServer> arrayList = new ArrayList<EndpointServer>();
        for (EndpointBinding endpointBinding : this.endpointBindings.get(this)) {
            if (arrayList.contains(endpointBinding.endpointServer)) continue;
            arrayList.add(endpointBinding.endpointServer);
        }
        return arrayList.toArray(new EndpointServer[arrayList.size()]);
    }

    public EncoderContext getEncoderContext() {
        return this.application.getEncoderContext();
    }

    public EndpointBindingCollection getEndpointBindings() {
        return this.endpointBindings;
    }

    public Endpoint getEndpointByUri(String string) {
        List<EndpointBinding> list = this.endpointBindings.get(string);
        if (list.isEmpty()) {
            return null;
        }
        return list.get((int)0).endpointAddress;
    }

    public EndpointDescription[] getEndpointDescriptions() {
        return this.getEndpointDescriptions(null);
    }

    public EndpointDescription[] getEndpointDescriptions(SocketAddress socketAddress) {
        Object[] objectArray;
        Object[] objectArray2;
        Object object;
        ArrayList<EndpointDescription> arrayList = new ArrayList<EndpointDescription>(this.endpointBindings.size());
        UserTokenPolicy[] userTokenPolicyArray = this.getUserTokenPolicies();
        ApplicationDescription applicationDescription = this.createApplicationDescription();
        ArrayList<Endpoint> arrayList2 = new ArrayList<Endpoint>();
        if (socketAddress != null) {
            logger.trace("Server.getEndpointDescriptions: requestAddress=", (Object)socketAddress);
            for (EndpointServer object2 : this.endpointBindings.getEndpointServers()) {
                logger.trace("Server.getEndpointDescriptions: EndpointServer es=", (Object)object2);
                if (object2 instanceof OpcTcpServer) {
                    object = (OpcTcpServer)object2;
                    objectArray2 = ((OpcTcpServer)object).socketHandleSnapshot();
                    for (Object object3 : objectArray2) {
                        if (!socketAddress.equals(((OpcTcpServer.SocketHandle)object3).getSocketAddress())) continue;
                        for (Object object4 : objectArray = ((OpcTcpServer.SocketHandle)object3).endpointHandleSnapshot()) {
                            arrayList2.add(((OpcTcpServer.OpcTcpEndpointHandle)object4).endpointBinding().endpointAddress);
                        }
                    }
                }
                if (!(object2 instanceof HttpsServer)) continue;
                object = (HttpsServer)object2;
                objectArray2 = ((HttpsServer)object).socketHandleSnapshot();
                for (Object object5 : objectArray2) {
                    if (!socketAddress.equals(((HttpsServer.SocketHandle)object5).getSocketAddress())) continue;
                    for (Object object4 : objectArray = ((HttpsServer.SocketHandle)object5).endpointHandleSnapshot()) {
                        arrayList2.add(((HttpsServer.HttpsEndpointHandle)object4).endpointBinding().endpointAddress);
                    }
                }
            }
        }
        for (Endpoint endpoint : this.endpointBindings.getEndpointAddresses()) {
            if (socketAddress != null && !arrayList2.contains(endpoint)) continue;
            object = endpoint.getEndpointUrl();
            objectArray2 = UriUtil.getTransportProtocol((String)object).toLowerCase();
            for (KeyPair keyPair : this.application.getApplicationInstanceCertificates()) {
                objectArray = endpoint.getSecurityModes();
                logger.trace("getEndpointDescriptions: endpoint={}", (Object)endpoint);
                logger.trace("getEndpointDescriptions: keyPair={}", (Object)keyPair);
                if (logger.isTraceEnabled()) {
                    logger.trace("getEndpointDescriptions: securityModes={}", (Object)Arrays.toString(objectArray));
                }
                for (Object object4 : objectArray) {
                    MessageSecurityMode messageSecurityMode = MessageSecurityMode.None;
                    String string = "";
                    String string2 = UATCP_BINARY_TRANSPORT_PROFILE_URI;
                    int n2 = 0;
                    if ("opc.https".equals(objectArray2)) {
                        messageSecurityMode = ((SecurityMode)object4).getMessageSecurityMode();
                        n2 = messageSecurityMode == MessageSecurityMode.None ? 0 : (messageSecurityMode == MessageSecurityMode.Sign ? 2 : -1);
                        string = ((SecurityMode)object4).getSecurityPolicy().getPolicyUri();
                        string2 = HTTPS_BINARY_TRANSPORT_PROFILE_URI;
                    } else if ("http".equals(objectArray2)) {
                        n2 = 0;
                        string = SecurityPolicy.NONE.getPolicyUri();
                        string2 = HTTPS_BINARY_TRANSPORT_PROFILE_URI;
                    } else if ("opc.tcp".equals(objectArray2)) {
                        messageSecurityMode = ((SecurityMode)object4).getMessageSecurityMode();
                        n2 = messageSecurityMode == MessageSecurityMode.None ? 0 : (messageSecurityMode == MessageSecurityMode.Sign ? 1 : (messageSecurityMode == MessageSecurityMode.SignAndEncrypt ? 2 : -1));
                        string = ((SecurityMode)object4).getSecurityPolicy().getPolicyUri();
                    }
                    if ((MessageSecurityMode.SignAndEncrypt == messageSecurityMode || MessageSecurityMode.Sign == messageSecurityMode) && !((SecurityMode)object4).getSecurityPolicy().isUsableWith(keyPair.certificate)) continue;
                    EndpointDescription endpointDescription = new EndpointDescription();
                    endpointDescription.setEndpointUrl(endpoint.getEndpointUrl());
                    endpointDescription.setSecurityMode(messageSecurityMode);
                    endpointDescription.setSecurityLevel(UnsignedByte.valueOf(n2));
                    endpointDescription.setSecurityPolicyUri(string);
                    endpointDescription.setServer(applicationDescription);
                    endpointDescription.setServerCertificate(ByteString.valueOf(keyPair.getCertificate().getEncoded()));
                    endpointDescription.setTransportProfileUri(string2);
                    endpointDescription.setUserIdentityTokens(userTokenPolicyArray);
                    arrayList.add(endpointDescription);
                }
            }
        }
        logger.trace("getEndpointDescriptions: result={}" + arrayList);
        return arrayList.toArray(new EndpointDescription[0]);
    }

    public Endpoint[] getEndpoints() {
        List<EndpointBinding> list = this.endpointBindings.get(this);
        List<Endpoint> list2 = EndpointBindingCollection.getEndpointAddresses(list);
        return list2.toArray(new Endpoint[list2.size()]);
    }

    public synchronized EndpointServer getOrCreateEndpointServer(String string) throws ServiceResultException {
        if (string.equals("opc.tcp")) {
            return this.getOrCreateOpcTcpServer();
        }
        if (string.equals("http") || string.equals("opc.https")) {
            return this.getOrCreateHttpsServer();
        }
        throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "Cannot find EndpointServer for scheme " + string);
    }

    public synchronized HttpsServer getOrCreateHttpsServer() throws ServiceResultException {
        if (this.os == null) {
            this.os = new HttpsServer(this.getApplication());
        }
        return this.os;
    }

    public synchronized OpcTcpServer getOrCreateOpcTcpServer() throws ServiceResultException {
        if (this.ot == null) {
            this.ot = new OpcTcpServer(this.getApplication());
        }
        return this.ot;
    }

    public <T> T getServiceHandlerByService(Class<? extends ServiceRequest> clazz) {
        return this.serviceHandlers.getServiceHandlerByService(clazz);
    }

    public ServiceHandlerComposition getServiceHandlerComposition() {
        return this.serviceHandlers;
    }

    public ServiceHandler[] getServiceHandlers() {
        return this.serviceHandlers.getServiceHandlers();
    }

    public UserTokenPolicy[] getUserTokenPolicies() {
        return this.userTokenPolicies.toArray(new UserTokenPolicy[0]);
    }

    public boolean handlesService(Class<? extends IEncodeable> clazz) {
        return this.serviceHandlers.supportsService(clazz);
    }

    public boolean hasEndpoint(String string) {
        List<EndpointBinding> list = this.endpointBindings.get(string);
        return !list.isEmpty();
    }

    public void removeUserTokenPolicy(UserTokenPolicy userTokenPolicy) {
        this.userTokenPolicies.remove(userTokenPolicy);
    }

    public synchronized void setEndpointBindings(EndpointBindingCollection endpointBindingCollection) {
        this.endpointBindings = endpointBindingCollection;
        this.endpointDiscoveryService.endpointBindings = endpointBindingCollection;
    }

    public String toString() {
        return "Server " + this.application.getApplicationUri();
    }
}

